

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/OracleObjectQuery.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  OracleObjectQuery                                          */
/*  Author	:  Prashanth Bangalore                                        */
/*  Description :  Stored proc used to support Oracle 12C CDB redirect restore */
/******************************************************************************/
--dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/OracleObjectQuery.sp,v $ $Id: OracleObjectQuery.sp,v 1.7.2.4.28.1 2021/05/03 22:33:31 bvallabhaneni Exp $";
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='OracleObjectQuery')
BEGIN
	print '>>> Drop Stored Procedure: OracleObjectQuery <<<'
	drop procedure OracleObjectQuery
END
IF EXISTS (select * from GxQscripts where name='OracleObjectQuery')
	delete from GxQscripts where name = 'OracleObjectQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OracleObjectQuery')
	delete from GXDBVersions where aliasname = 'OracleObjectQuery'
GO
print '... Creating Procedure: OracleObjectQuery'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure OracleObjectQuery
  @i_instance integer = 0,
  @opType integer = 0,
  @appIdOrTaskId integer = 0,
  @actionType integer = 0,
  @timeStamp integer = 0
AS
  DECLARE @objType integer = 0
  DECLARE @pdbName varchar(30)
  DECLARE @pdbId integer
  DECLARE @tsName varchar(64)
  DECLARE @tsId integer		
  DECLARE @dfName varchar(max)
  DECLARE @dfId integer
  DECLARE @dfMaxSize bigint
  DECLARE @dfNewName varchar(max)
  DECLARE @storageType integer
  DECLARE @status integer
SET NOCOUNT ON
DECLARE @pdbClone  integer = 4
SELECT @pdbClone = (@opType & @pdbClone)
IF @pdbClone <> 0
BEGIN
	SELECT @opType = (@opType & ~@pdbClone)
END
IF @actionType <> 0
BEGIN
	IF @actionType <> -2
	BEGIN
		SET @actionType = 0
	END
	SELECT	o.Type, isnull(p.name, ''), isnull(p.pdbId, 0), t.name, t.id, d.name, d.contType,d.maxDBdataSize, isnull(o.name, ''), t.tablespaceId, d.status
	FROM	OracleObjects o, OracleDataFiles d, OracleTableSpaces t
			LEFT OUTER JOIN OraclePluggableDbs p  with (nolock) ON p.pdbId = t.pdbId
	WHERE	o.instId = @i_instance   and  setType = @opType
		AND	( (@opType = 1 and o.taskId = @appIdOrTaskId) or (@opType = 2 and o.subClientId = @appIdOrTaskId) )
		AND	( (o.type = 1 and o.objId = d.id) OR (o.type = 5 and o.objId = t.id) OR (o.type = 20 and o.objId = p.pdbId)
				OR (@pdbClone = 4 AND p.instId = @i_instance AND  p.name in ('CDB$ROOT','PDB$SEED')
				    AND (@timestamp = 0 or p.created < @timestamp) AND ( p.deleteFlag = 0 or p.deleted >= @timeStamp) ) )
		AND	t.id = d.tblId and (@actionType = -2 OR o.actionType = @actionType)
		AND ( ( @timeStamp = 0 and t.deleteFlag = 0)
			OR (t.created < @timeStamp and (t.deleteFlag = 0 or t.deleted >= @timeStamp) ) )
		AND ( ( @timeStamp = 0 and d.deleteFlag = 0)
			OR (d.created < @timeStamp and (d.deleteFlag = 0 or d.deleted >= @timeStamp) ) )
	ORDER BY t.pdbId, d.tblId, d.name, o.Type Desc
END
-- For Oracle snap backups  we  need to fetch entire DB
ELSE
BEGIN
	SELECT	@actionType, isnull(p.name, ''), isnull(p.pdbId, 0),  t.name, t.id, d.name, d.contType,d.maxDBdataSize, '', t.tablespaceId, d.status
	FROM	OracleDataFiles d, OracleTableSpaces t
		LEFT OUTER JOIN OraclePluggableDbs p  with (nolock) ON p.pdbId = t.pdbId
	WHERE	t.instId = @i_instance   and t.id = d.tblId
		AND ( ( @timeStamp = 0 and t.deleteFlag = 0)
			OR (t.created < @timeStamp and (t.deleteFlag = 0 or t.deleted >= @timeStamp) ) )
		AND ( ( @timeStamp = 0 and d.deleteFlag = 0)
			OR (d.created < @timeStamp and (d.deleteFlag = 0 or d.deleted >= @timeStamp) ) )
	ORDER BY t.pdbId, d.tblId, d.name
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'OracleObjectQuery')
	delete from GxQscripts where name = 'OracleObjectQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OracleObjectQuery')
	delete from GXDBVersions where aliasname = 'OracleObjectQuery'
GO

insert into GXDBVersions values(2, 'OracleObjectQuery',  'v1.7.2.4.28.1', 'OracleObjectQuery', 'v1.7.2.4.28.1')
GO

