

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/OraUpdateDb2BrowseResp.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/OraUpdateDb2BrowseResp.sp,v $ $Id: OraUpdateDb2BrowseResp.sp,v 1.1.2.8 2018/12/19 23:43:15 stelagamsetti Exp $";
-- +-----------------------------------------------------------------------+
-- | 			Procedure : "OraUpdateDb2BrowseResp"		   |
-- |	This procedure is used to update the DB2 browse response in CS DB. |
-- +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='OraUpdateDb2BrowseResp')
BEGIN
	print '>>> Drop Stored Procedure: OraUpdateDb2BrowseResp <<<'
	drop procedure OraUpdateDb2BrowseResp
END
IF EXISTS (select * from GxQscripts where name='OraUpdateDb2BrowseResp')
	delete from GxQscripts where name = 'OraUpdateDb2BrowseResp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OraUpdateDb2BrowseResp')
	delete from GXDBVersions where aliasname = 'OraUpdateDb2BrowseResp'
GO
print '... Creating Procedure: OraUpdateDb2BrowseResp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure OraUpdateDb2BrowseResp
-- Input arguments
  @i_xmlText XML
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_detectedTblSpaces INT;
  DECLARE @o_detectedDataFiles INT;
  DECLARE @o_errorCode INT;
  DECLARE @o_errorMessage VARCHAR(1024);
DECLARE @instanceId						INT
DECLARE @backupsetId					INT
DECLARE @subclientId					INT
DECLARE @syncTime						INT
DECLARE @backupNode						VARCHAR(MAX)
DECLARE @opType							INT = 0
DECLARE @defaultSubclientOnlineFull		INT = 0
DECLARE @upHighWaterMark				INT = 0
DECLARE	@idoc INT = 0
SET @o_detectedTblSpaces = 0
SET @o_detectedDataFiles = 0
SET @o_errorCode = 0
SET @o_errorMessage = ''
IF object_id('tempdb.dbo.#tblSpaces') is not null DROP TABLE #tblSpaces
CREATE TABLE #tblSpaces (
				id			INT DEFAULT 0,
				dbAlias		VARCHAR(1024),
				tsName		VARCHAR(1024),
				tsId		INT,
				tbsState	INT,
				totalBytes	BIGINT,
				usedBytes	BIGINT,
				tbsStatus	INT,
				highWatermark	BIGINT)
IF object_id('tempdb.dbo.#dataFiles') is not null DROP TABLE #dataFiles
CREATE TABLE #dataFiles (
				id				INT DEFAULT 0,
				tsName			VARCHAR(1024),
				tsId			INT DEFAULT 0,
				crId			INT,
				crName			VARCHAR(1024),
				contType		VARCHAR(1024),
				contTypeInt		INT,
				totalPages		BIGINT,
				dataSize		BIGINT,
				maxDataSize		BIGINT,
				underDBDir		INT,
				isAccessible	INT,
				status			INT)
--Read inputs
SET	@instanceId 	= ISNULL (( SELECT ref.value('@instanceId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_Db2BrowseDbContentsV2') R(ref)), 0)
SET	@backupsetId 	= ISNULL (( SELECT ref.value('@backupsetId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_Db2BrowseDbContentsV2') R(ref)), 0)
SET	@subclientId 	= ISNULL (( SELECT ref.value('@subclientId', 'INT')
					FROM  @i_xmlText.nodes ('Ida_Db2BrowseDbContentsV2') R(ref)), 0)
SET	@syncTime 		= ISNULL (( SELECT ref.value('@syncTime', 'INT')
					FROM  @i_xmlText.nodes ('Ida_Db2BrowseDbContentsV2') R(ref)), 0)
SET	@backupNode 	= ISNULL (( SELECT ref.value('@backupNode', 'VARCHAR(MAX)')
					FROM  @i_xmlText.nodes ('Ida_Db2BrowseDbContentsV2') R(ref)), '')
SET	@opType 		= ISNULL (( SELECT ref.value('@opType', 'INT')
					FROM  @i_xmlText.nodes ('Ida_Db2BrowseDbContentsV2') R(ref)), 0)
SET	@defaultSubclientOnlineFull 		= ISNULL (( SELECT ref.value('@defaultSubclientOnlineFull', 'INT')
					FROM  @i_xmlText.nodes ('Ida_Db2BrowseDbContentsV2') R(ref)), 0)
SET	@upHighWaterMark = ISNULL (( SELECT ref.value('@upHighWaterMark', 'INT')
					FROM  @i_xmlText.nodes ('Ida_Db2BrowseDbContentsV2') R(ref)), 0)
-- Check for valid inputs
IF @instanceId = 0
BEGIN
	SET @o_errorCode = 1
	SET @o_errorMessage = 'Invalid inputs. InstanceId is not set correctly.'
	GOTO PROC_EXIT
END
EXEC sp_xml_preparedocument @idoc OUTPUT, @i_xmlText
INSERT INTO #tblSpaces (dbAlias, tsName, tsId, tbsState, totalBytes, usedBytes, tbsStatus, highWatermark)
SELECT DISTINCT *
FROM OPENXML(@idoc, '//Ida_Db2BrowseDbContentsV2/tablespaceAttributes', 0)
WITH(
    dbAlias			VARCHAR(1024) '@dbAlias',
    tsName			VARCHAR(1024) '@tsName',
    tsId			INT '@tsId',
    tbsState		INT '@tbsState',
    totalBytes		BIGINT    '@totalBytes',
    usedBytes		BIGINT '@usedBytes',
    tbsStatus		INT '@tbsStatus',
	highWatermark	BIGINT '@highWatermark' )
INSERT INTO #dataFiles (tsName, crId, crName, contType, contTypeInt, dataSize, maxDataSize, totalPages, underDBDir, isAccessible, status)
SELECT DISTINCT *
FROM OPENXML(@idoc, '//Ida_Db2BrowseDbContentsV2/tablespaceAttributes/tablespaceContainers', 0)
WITH(
    tsName			VARCHAR(1024)	'../@tsName',
    crId			INT				'@crId',
    crName			VARCHAR(1024)	'@crName',
    contType		VARCHAR(1024)	'@contType',
    contTypeInt		INT				'@contTypeInt',
	dataSize		BIGINT			'@dataSize',
	maxDataSize		BIGINT			'@maxDataSize',
    totalPages		BIGINT			'@totalPages',
    underDBDir		INT				'@underDBDir',
    isAccessible	INT				'@isAccessible',
	status			INT				'@status')
--Update tablespace id for existing tablespaces
UPDATE	#tblSpaces
SET		id = O.id
FROM	#tblSpaces T, OracleTableSpaces O
WHERE	O.instId = @instanceId
	AND	O.name = T.tsName
	AND	O.tablespaceId = T.tsId
	AND	deleteFlag = 0
	AND	(O.bkpNode = @backupNode OR @backupNode = '')
	AND	(O.backupsetId = @backupsetId OR @backupsetId = 0)
--Update existing tablespaces
UPDATE	OracleTableSpaces
SET		status = T.tbsStatus, modified = @syncTime, maxDBdataSize = totalBytes, freeDBDataSize = (T.totalBytes - T.usedBytes), opType = ISNULL(T.tbsState, 0), highWatermark = ISNULL(T.highWatermark, 0)
FROM	#tblSpaces T, OracleTableSpaces O
WHERE	T.id = O.id
	AND	((@upHighWaterMark = 0) OR (T.highWatermark = 0) OR (T.highWatermark = o.highwatermark))
	AND	T.id <> 0
--Insert new tablespaces
INSERT	INTO OracleTableSpaces
SELECT	T.tsName, @instanceId, @backupNode, T.tbsStatus, @syncTime, 0, 0, @syncTime, ISNULL(T.tbsState, 0), @backupsetId, T.tsId, T.totalBytes, (T.totalBytes - T.usedBytes), 0, ISNULL(T.highWatermark, 0)
FROM	#tblSpaces T
		LEFT OUTER JOIN OracleTableSpaces O
			ON T.id = O.id
WHERE	T.id = 0
	OR	((@upHighWaterMark <> 0) AND (T.highWatermark > 0) AND (T.highWatermark <> o.highwatermark))
SELECT @o_detectedTblSpaces = @@ROWCOUNT
--Mark TableSpaces as deleted
UPDATE OracleTableSpaces
SET deleted = @syncTime
WHERE instId = @instanceId
	AND modified <> @syncTime
	AND deleteFlag = 0
	AND (@backupsetId = 0 OR @backupsetId = backupSetId)
	AND (@backupNode = '' OR  bkpNode = @backupNode);
UPDATE	oracleObjects
SET		objId = T2.id
FROM	oracleObjects O
	INNER JOIN oracleTableSpaces T1
		ON O.objId = T1.id AND O.instId = T1.instId
	AND T1.deleteFlag = 0
	AND T1.deleted <> @syncTime
	INNER JOIN oracleTableSpaces T2
		ON T1.instId = T2.instId
	AND T1.backupsetId = T2.backupsetId AND T1.tablespaceId = T2.tablespaceId
	AND T2.deleteFlag = 0 AND T2.deleted <> @syncTime AND O.objId <> T2.id
	AND T1.highwatermark <> T2.highwatermark
	AND T1.bkpNode = T2.bkpNode
WHERE	O.type = 5 /*ORAOBJ_TABLESPACE*/
	AND	O.subClientId <> 0
	AND	O.instId = @instanceId
--SetBackup for Tablespace
IF (@opType = 2 /*ORAOBJ_BACKUP_BROWSE*/ AND @defaultSubclientOnlineFull <> 1)
BEGIN
	--Update tablespace id for existing tablespaces
	UPDATE	#tblSpaces
	SET		id = O.id
	FROM	#tblSpaces T, OracleTableSpaces O
	WHERE	O.instId = @instanceId
		AND	O.name = T.tsName
		AND	O.tablespaceId = T.tsId
		AND	O.deleteFlag = 0
		AND O.deleted <> @syncTime
		AND	(O.bkpNode = @backupNode OR @backupNode = '')
		AND	(O.backupsetId = @backupsetId OR @backupsetId = 0)
	INSERT INTO OracleObjects
	SELECT	@subclientId,  0, @instanceId, 5 /*ORAOBJ_TABLESPACE*/, 0, T.id, 2 /*OBJECT_BACKUP_TYPE*/, 0 /*eOraDb2Action_BackupRestore*/, '', 0, 0, 0, 0
	FROM	#tblSpaces T LEFT OUTER JOIN OracleObjects O
		ON	O.subclientId = @subclientId AND O.type = 5 /*ORAOBJ_TABLESPACE*/ AND O.objId = T.id AND O.setType = 2 /*OBJECT_BACKUP_TYPE*/
	WHERE	O.id IS NULL
END
--Update tablespace id for datafiles
UPDATE	#dataFiles
SET		tsId = O.id
FROM	#dataFiles D, OracleTableSpaces O
WHERE	O.instId = @instanceId
	AND	O.name = D.tsName
	AND	O.deleteFlag = 0
	AND O.deleted <> @syncTime
	AND	(O.bkpNode = @backupNode OR @backupNode = '')
	AND	(O.backupsetId = @backupsetId OR @backupsetId = 0)
--Update DatafileId for already existing datafiles
UPDATE	#dataFiles
SET		id = D.id
FROM	#dataFiles DT, OracleDataFiles D
WHERE	D.name COLLATE Latin1_General_CS_AS = DT.crName
	AND	D.deleteFlag = 0
	AND	D.tblId = DT.tsId
	AND	(D.bkpNode = @backupNode OR @backupNode = '')
--Update OracleDataFiles for existing datafiles
UPDATE	OracleDataFiles
SET		status = DT.status, modified = @syncTime, maxDBdataSize = DT.maxDataSize, freeDBdataSize = (DT.maxDataSize - DT.dataSize), contType = DT.contTypeInt, totalPages = DT.totalPages, underDBDir = DT.underDBDir, isAccessible = DT.isAccessible
FROM	#dataFiles DT, OracleDataFiles D
WHERE	DT.id = D.id
	AND	DT.id <> 0
--Insert new datafiles
INSERT	INTO OracleDataFiles
SELECT	DT.crName, DT.tsId, @instanceId, @backupNode, DT.status, @syncTime, 0, 0, @syncTime, 0, @backupsetId, DT.maxDataSize, (DT.maxDataSize - DT.dataSize), DT.underDBDir, DT.contTypeInt, DT.totalPages, DT.isAccessible
FROM	#dataFiles DT
WHERE	DT.id = 0
SELECT @o_detectedDataFiles = @@ROWCOUNT
--Mark datafiles as deleted. note that deleteFlag would be marked later in OracleObjectAPI through MarkDeletedFlagOnOrphanOraTSAndDF
UPDATE oracleDataFiles
SET deleted = @syncTime
WHERE instId = @instanceId
	AND modified <> @syncTime
	AND deleteFlag = 0
	AND (@backupsetId = 0 OR @backupsetId = backupSetId)
	AND (@backupNode = '' OR  bkpNode = @backupNode);
--SetBackup for Datafile
IF (@opType = 2 /*ORAOBJ_BACKUP_BROWSE*/ AND @defaultSubclientOnlineFull <> 1)
BEGIN
	--Update tablespace id for existing tablespaces
	UPDATE	#dataFiles
	SET		id = D.id
	FROM	#dataFiles DT, OracleDataFiles D
	WHERE	D.name COLLATE Latin1_General_CS_AS = DT.crName
		AND	D.deleteFlag = 0
		AND D.deleted <> @syncTime
		AND	D.tblId = DT.tsId
		AND	(D.bkpNode = @backupNode OR @backupNode = '')
	INSERT INTO OracleObjects
	SELECT	@subclientId,  0, @instanceId, 1 /*ORAOBJ_DATAFILE*/, D.tsId, D.id, 2 /*OBJECT_BACKUP_TYPE*/, 0 /*eOraDb2Action_BackupRestore*/, '', 0, 0, 0, 0
	FROM	#dataFiles D LEFT OUTER JOIN OracleObjects O
		ON	O.instId = @instanceId AND O.subclientId = @subclientId AND O.type = 1 /*ORAOBJ_DATAFILE*/ AND O.objId = D.id
	WHERE	O.id IS NULL
END
PROC_EXIT:
SELECT @o_detectedTblSpaces, @o_detectedDataFiles, @o_errorCode, @o_errorMessage
IF object_id('tempdb.dbo.#dataFiles') is not null DROP TABLE #dataFiles
IF object_id('tempdb.dbo.#tblSpaces') is not null DROP TABLE #tblSpaces
GO

IF EXISTS (select * from GxQscripts where name = 'OraUpdateDb2BrowseResp')
	delete from GxQscripts where name = 'OraUpdateDb2BrowseResp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OraUpdateDb2BrowseResp')
	delete from GXDBVersions where aliasname = 'OraUpdateDb2BrowseResp'
GO

insert into GXDBVersions values(2, 'OraUpdateDb2BrowseResp',  '00010001000200080000', 'OraUpdateDb2BrowseResp', '00010001000200080000')
GO

