

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/OraDeleteObjectsByEntity.sp] ---------- 

/******************************************************************************/
/*  Copyright (c) CommVault Systems                                           */
/*  All Rights Reserved                                                       */
/*                                                                            */
/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
/*  The copyright notice above does not evidence any                          */
/*  actual or intended publication of such source code.                       */
/*                                                                            */
/*  File name   :  OraDeleteObjectsByEntity                                   */
/*  Author	:  Sunil Telagamsetti                                             */
/*  Description :  Stored proc used to prune oracle objects                   */
/*             associated with given instanceid / backupsetid / subclientid   */
/******************************************************************************/
--dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/OraDeleteObjectsByEntity.sp,v $ $Id: OraDeleteObjectsByEntity.sp,v 1.1.2.4 2018/03/27 08:58:07 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: OraDeleteObjectsByEntity <<<'

IF EXISTS (select * from sysobjects where name='OraDeleteObjectsByEntity')
	drop procedure OraDeleteObjectsByEntity
IF EXISTS (select * from GxQscripts where name='OraDeleteObjectsByEntity')
	delete from GxQscripts where name = 'OraDeleteObjectsByEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OraDeleteObjectsByEntity')
	delete from GXDBVersions where aliasname = 'OraDeleteObjectsByEntity'
GO
print '... Creating Procedure: OraDeleteObjectsByEntity'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure OraDeleteObjectsByEntity
  @i_entityId integer,
  @i_entityType integer
AS
  DECLARE @errCode integer = 0
  DECLARE @errStr varchar(256) = ''
	IF @i_entityId = 0 OR @i_entityType NOT IN (5, 6, 7) -- INSTANCE_ENTITY, BACKUPSET_ENTITY, SUBCLIENT_ENTITY
	BEGIN
		set @errStr = 'Invalid Input'
		set @errCode = -1
		goto EXIT_PROC
	END
	BEGIN TRY
		IF (@i_entityType = 5) --INSTANCE_ENTITY
		BEGIN
			DELETE OracleDataFiles WHERE instId = @i_entityId
			DELETE OracleTableSpaces WHERE instId = @i_entityId
			DELETE OraclePluggableDBs WHERE instId = @i_entityId
			DELETE OracleObjects WHERE instId = @i_entityId
		END
		IF (@i_entityType = 6) --BACKUPSET_ENTITY
		BEGIN
			DELETE	OracleObjects
			FROM	OracleObjects O
				INNER JOIN OracleTableSpaces T
				ON O.instId = T.instId
			WHERE	T.backupsetId = @i_entityId
				AND	((O.parentId = T.TableSpaceId AND O.type = 1) OR (O.objId = T.TableSpaceId AND O.type = 5))
			DELETE	OracleDataFiles
			WHERE	backupsetId = @i_entityId
			DELETE	OracleTableSpaces
			WHERE	backupsetId = @i_entityId
		END
		IF (@i_entityType = 7) --SUBCLIENT_ENTITY
		BEGIN
			DELETE OracleObjects WHERE subClientId = @i_entityId and setType = 2
		END
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		select @errCode = @@ERROR, @errStr = ERROR_MESSAGE()
	END CATCH
	EXIT_PROC:
	SELECT  @errCode, ISNULL(@errStr, '')
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'OraDeleteObjectsByEntity')
	delete from GxQscripts where name = 'OraDeleteObjectsByEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OraDeleteObjectsByEntity')
	delete from GXDBVersions where aliasname = 'OraDeleteObjectsByEntity'
GO

insert into GXDBVersions values(2, 'OraDeleteObjectsByEntity',  '00010001000200040000', 'OraDeleteObjectsByEntity', '00010001000200040000')
GO

