

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/OraBrowseDatabaseFiles.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/OraBrowseDatabaseFiles.sp,v $ $Id: OraBrowseDatabaseFiles.sp,v 1.1.2.4 2019/09/28 02:48:42 rgunda Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='OraBrowseDatabaseFiles')
BEGIN
	print '>>> Drop Stored Procedure: OraBrowseDatabaseFiles <<<'
	drop procedure OraBrowseDatabaseFiles
END
IF EXISTS (select * from GxQscripts where name='OraBrowseDatabaseFiles')
	delete from GxQscripts where name = 'OraBrowseDatabaseFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OraBrowseDatabaseFiles')
	delete from GXDBVersions where aliasname = 'OraBrowseDatabaseFiles'
GO
print '... Creating Procedure: OraBrowseDatabaseFiles'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure OraBrowseDatabaseFiles
  @i_xmlString XML
AS
  DECLARE @o_xmlString XML;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN TRY
	--DEBUG
	--SET @i_xmlString =	'<Api_DBBrowseRequest path="\TESTTS1">
	--							<entity applicationId="22" clientName="sunilmysql" instanceId="9" clientId="6" instanceName="ORCL" appName="Oracle"/>
	--						</Api_DBBrowseRequest>'
	DECLARE @instId INT
	DECLARE @pointInTime INT = 0
	DECLARE @backupSetId INT = 0
	SET @instId = ISNULL((SELECT @i_xmlString.value('(/Api_DBBrowseRequest/entity/@instanceId)[1]','INT')), 0)
	SET @backupSetId = ISNULL((SELECT @i_xmlString.value('(/Api_DBBrowseRequest/entity/@backupsetId)[1]','INT')), 0)
	IF (@instId = 0)
		GOTO PROC_EXIT
	IF OBJECT_ID('tempdb.dbo.#oraclePDBs') IS NOT NULL
		DROP TABLE #oraclePDBs
	IF OBJECT_ID('tempdb.dbo.#oracleTablespaces') IS NOT NULL
		DROP TABLE #oracleTablespaces
	IF OBJECT_ID('tempdb.dbo.#oracleDatafiles') IS NOT NULL
		DROP TABLE #oracleDatafiles
	CREATE TABLE #oraclePDBs (InstanceId INT, tablespaceId INT, pdbid int, pdb nvarchar(512))
	CREATE TABLE #oracleTablespaces (InstanceId INT, tablespaceId INT, tablespacename nvarchar(512),opType INT)
	CREATE TABLE #oracleDatafiles (InstanceId INT, tablespaceId INT, datafileId INT, datafileName nvarchar(1024),contType INT,totalPages INT)
	INSERT INTO #oraclePDBs
	SELECT	@instId, tbsp.id, pdbs.pdbid, pdbs.name
	FROM	OraclePluggableDBs pdbs
		INNER JOIN oracleTableSpaces tbsp
			ON pdbs.pdbId = tbsp.pdbId AND pdbs.instId = @instId AND tbsp.instId = @instId AND tbsp.backupsetId = @backupSetId
	WHERE	pdbs.instId = @instId AND tbsp.backupsetId = @backupSetId
			AND ((@pointInTime = 0 AND pdbs.deleteFlag = 0)
				OR ((pdbs.created < @pointInTime) AND (pdbs.deleted > @pointInTime or pdbs.deleted = 0)))
	INSERT INTO	#oracleTablespaces
	SELECT	@instId, tbsp.id, tbsp.name,tbsp.opType
	FROM	oracleTableSpaces tbsp
	WHERE	tbsp.instId = @instId AND tbsp.backupsetId = @backupSetId
			AND ((@pointInTime = 0 AND tbsp.deleteFlag = 0)
				OR ((tbsp.created < @pointInTime) AND (tbsp.deleted > @pointInTime or tbsp.deleted = 0)))
	INSERT INTO #oracleDatafiles
	SELECT	@instId, tblId, id, name,contType,totalPages
	FROM	oracleDataFiles od
	WHERE	instId = @instId AND backupsetId = @backupSetId
			AND ((@pointInTime = 0 AND od.deleteFlag = 0)
				OR ((od.created < @pointInTime) AND (od.deleted > @pointInTime or od.deleted = 0)))
	SET @o_xmlString =
		(SELECT
				(SELECT
					P.pdb as '@database',
					T.tablespacename as '@tableSpace',
					T.opType as '@tableSpaceStorageType',
					D.datafileName as '@dataFile',
					D.totalPages as '@totalPages',
					D.contType as '@contType',
					1 as '@fileType'
				FOR XML PATH('oracleContent'), TYPE)
		FROM	#oracleTablespaces T
			INNER JOIN #oracleDatafiles D
				ON T.tablespaceId = D.tablespaceId
			LEFT OUTER JOIN #oraclePDBs P
				ON T.tablespaceId = P.tablespaceId
		ORDER BY P.pdb, T.tablespacename, D.datafileName
		FOR XML PATH(''), ROOT('Api_DBBrowseResp'))
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET  @o_xmlString = (SELECT @@ERROR AS '@errorCode', 'Failed to get database content details.' AS '@errorMessage'
			FOR XML PATH ('error'), root(N'Api_DBBrowseResp'))
END CATCH
PROC_EXIT:
IF @o_xmlString IS NULL
	SET @o_xmlString = '<Api_DBBrowseResp/>'
IF OBJECT_ID('tempdb.dbo.#oraclePDBs') IS NOT NULL
	DROP TABLE #oraclePDBs
IF OBJECT_ID('tempdb.dbo.#oracleTablespaces') IS NOT NULL
	DROP TABLE #oracleTablespaces
IF OBJECT_ID('tempdb.dbo.#oracleDatafiles') IS NOT NULL
	DROP TABLE #oracleDatafiles
SELECT @o_xmlString AS o_xmlString
GO

IF EXISTS (select * from GxQscripts where name = 'OraBrowseDatabaseFiles')
	delete from GxQscripts where name = 'OraBrowseDatabaseFiles'
GO

IF EXISTS (select * from GXDBVersions where aliasname='OraBrowseDatabaseFiles')
	delete from GXDBVersions where aliasname = 'OraBrowseDatabaseFiles'
GO

insert into GXDBVersions values(2, 'OraBrowseDatabaseFiles',  '00010001000200040000', 'OraBrowseDatabaseFiles', '00010001000200040000')
GO

