

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NtGetDynamicUsersForAlert.sp] ---------- 

SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NtGetDynamicUsersForAlert <<<'

IF EXISTS (select * from sysobjects where name='NtGetDynamicUsersForAlert')
	drop procedure NtGetDynamicUsersForAlert
IF EXISTS (select * from GxQscripts where name='NtGetDynamicUsersForAlert')
	delete from GxQscripts where name = 'NtGetDynamicUsersForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NtGetDynamicUsersForAlert')
	delete from GXDBVersions where aliasname = 'NtGetDynamicUsersForAlert'
GO
print '... Creating Procedure: NtGetDynamicUsersForAlert'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NtGetDynamicUsersForAlert
  @sourceEntity varchar(1024),
  @alertId int
AS
  DECLARE @emailIds nvarchar(MAX) 
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @dynamicAlertRecipient nvarchar(MAX)
DECLARE @dynamicAlertRecipientXml xml
DECLARE @sourceEntityXml xml
DECLARE @alsoNotify nvarchar(1024)
DECLARE @exclusionList nvarchar(1024)
DECLARE @entityType INT
DECLARE @entityId INT
DECLARE @roleXml xml
DECLARE @recipientList nvarchar(MAX)=''
IF object_id('tempdb.dbo.#entityPermissionTable') IS NOT null DROP TABLE #entityPermissionTable
CREATE TABLE #entityPermissionTable(entityId  int,entityType int, permissionId int)
IF object_id('tempdb.dbo.#userPermissionsTable') IS NOT null DROP TABLE #userPermissionsTable
CREATE TABLE #userPermissionsTable(userId INT,permissionId INT)
IF object_id('tempdb.dbo.#emails') IS NOT null DROP TABLE #emails
CREATE TABLE #emails(mail nvarchar(512))
SET @sourceEntityXml = cast(@sourceEntity as XML)
select @entityType = @sourceEntityXml.value('(/CvEntities_GenericEntity/@_type_)[1]','int')
-- handle other entities as required
select @entityId =
	case @entityType
WHEN 128 THEN @sourceEntityXml.value('(/CvEntities_GenericEntity/@dataSourceId)[1]','int')
WHEN 3 THEN @sourceEntityXml.value('(/CvEntities_GenericEntity/@clientId)[1]','int')
	end
SELECT @dynamicAlertRecipient = attrVal from NTNotificationProp WHERE attrName = 'Dynamic Alert Recipients' and modified = 0 and componentNameId = @alertId
SET @dynamicAlertRecipientXml = cast(@dynamicAlertRecipient as XML)
--get the details defined during alert creation
SELECT @exclusionList = @dynamicAlertRecipientXml.value('(/dynamicRecipientsList/@exclusionList)[1]','nvarchar(1024)')
SELECT @alsoNotify = @dynamicAlertRecipientXml.value('(/dynamicRecipientsList/@alsoNotify)[1]','nvarchar(1024)')
-- list of available entities with permissions
INSERT INTO #entityPermissionTable
SELECT  case  ds.col.value('@_type_','int')
WHEN 128 then ds.col.value('@dataSourceId','int')
WHEN 3 then ds.col.value('@clientId','int')
	    end ,
			 ds.col.value('@_type_','int'),
			 ps.col.value('@permissionId','int')
		from @dynamicAlertRecipientXml.nodes('dynamicRecipientsList/dynamicRecipients') as list(col)
		cross apply list.col.nodes('dataSource') as ds(col)
		cross apply list.col.nodes('permissions') as ps(col)
--consider only for the given entity
delete from #entityPermissionTable where entityId<>@entityId or entityType<>@entityType
IF EXISTS (select 1 from #entityPermissionTable WHERE entityId=@entityId and entityType=@entityType)
BEGIN
	--get all users for who has any permission on this entity
declare @filter int = 1 | 8
	exec sec_getSecurityForEntity @userId=1, @xmlOut=@roleXml OUTPUT, @entityType1=@entityType,@entityId1= @entityId,@getAssociationTypeFilter = @filter
	--filter out users with required permissions
	insert into #userPermissionsTable
select case when ug.col.value('@_type_','int')=13 then ug.col.value('@userId','int') else userid end ,
	UMRP.permissionId
	from @roleXml.nodes('associations') as list(col)
	cross apply list.col.nodes('userOrGroup') as ug(col)
	cross apply list.col.nodes('properties/role') as ps(col)
	inner join UMRolesWithPermissionsExpanded UMRP on UMRP.roleId = ps.col.value('@roleId','int')
	inner join #entityPermissionTable EPT on EPT.entityType = @entityType and EPT.entityId = @entityId and EPT.permissionId = UMRP.permissionId
	left join umusergroup on groupId=ug.col.value('@userGroupId','int')
	--filter out users with required permissions(inherited)
	insert into #userPermissionsTable
select case when ug.col.value('@_type_','int')=13 then ug.col.value('@userId','int') else userid end ,
	UMRP.permissionId
	from @roleXml.nodes('inheritedAssociations/association') as list(col)
	cross apply list.col.nodes('userOrGroup') as ug(col)
	cross apply list.col.nodes('properties/role') as ps(col)
	inner join UMRolesWithPermissionsExpanded UMRP on UMRP.roleId = ps.col.value('@roleId','int')
	inner join #entityPermissionTable EPT on EPT.entityType = @entityType and EPT.entityId = @entityId and EPT.permissionId = UMRP.permissionId
	left join umusergroup on groupId=ug.col.value('@userGroupId','int')
	insert into #emails
	select distinct email from umusers inner join #userPermissionsTable on userId = id
END
insert into #emails
select data from split(@alsoNotify,',')
delete email
from #emails email
inner join (select data from split(@exclusionList,','))Exclude
on Exclude.data=mail
select @recipientList+= mail+',' from #emails
drop table #entityPermissionTable
drop table #userPermissionsTable
drop table #emails
select @recipientList
GO

IF EXISTS (select * from GxQscripts where name = 'NtGetDynamicUsersForAlert')
	delete from GxQscripts where name = 'NtGetDynamicUsersForAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NtGetDynamicUsersForAlert')
	delete from GXDBVersions where aliasname = 'NtGetDynamicUsersForAlert'
GO

insert into GXDBVersions values(2, 'NtGetDynamicUsersForAlert',  '00000000000000000000', 'NtGetDynamicUsersForAlert', '00000000000000000000')
GO

