

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTValidateEntityList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTValidateEntityList <<<'

IF EXISTS (select * from sysobjects where name='NTValidateEntityList')
	drop procedure NTValidateEntityList
IF EXISTS (select * from GxQscripts where name='NTValidateEntityList')
	delete from GxQscripts where name = 'NTValidateEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTValidateEntityList')
	delete from GXDBVersions where aliasname = 'NTValidateEntityList'
GO
print '... Creating Procedure: NTValidateEntityList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTValidateEntityList
  @userIdParam INT,
  @entityList XML
AS
  DECLARE @retVal INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#EntityListTableTemp') IS NOT NULL
	DROP TABLE #EntityListTableTemp
CREATE TABLE #EntityListTableTemp
(
	_type_  INT,
	entityType1 INT,
	entityId1 INT,
	entityType2 INT,
	entityId2 INT,
	entityType3 INT,
	entityId3 INT,
	entityType4 INT,
	entityId4 INT,
	entityType5 INT,
	entityId5 INT,
	entityAssociatedBlob XML,
	entityAssociatedModifiedBlob XML,
	includeAll INT
)
INSERT INTO #EntityListTableTemp(_type_, entityAssociatedBlob, includeAll)
        SELECT
			ISNULL(Entity.value('@_type_','INT'),0),
			Entity.query('.'),
			ISNULL(Entity.value('(flags/@includeAll)[1]', 'INT'), 0)
        FROM @entityList.nodes('/CVGui_CommCellTreeNode/associations') AS Ref(Entity)
SET @retVal = 1	--assuming all entities are valid. Will set to 0 later if some invalid entity
DELETE FROM #EntityListTableTemp
WHERE _type_ IN (	27,
2,
10,
34,
8,
16,
20,
114,
113,
95,
14,
12)
IF EXISTS (SELECT 1 FROM #EntityListTableTemp tbl LEFT OUTER JOIN APP_Entity entity
						ON tbl._type_ = entity.entityType
					WHERE entity.entityType IS NULL)
BEGIN
	SET @retVal = 0
	GOTO EXIT_PRO
END
DELETE FROM #EntityListTableTemp WHERE includeAll = 1
IF NOT EXISTS (SELECT 1 FROM #EntityListTableTemp)
BEGIN
	GOTO EXIT_PRO
END
UPDATE #EntityListTableTemp
    SET entityAssociatedModifiedBlob = dbo.getEntityTypeHirearchyXMLFromGenericEntityXML(entityAssociatedBlob)
UPDATE #EntityListTableTemp
SET entityType1 = (SELECT ref.value('@entityType1', 'INT') AS entityType1
					FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId1 = (SELECT ref.value('@entityId1', 'INT') AS entityId1
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityType2 = (SELECT ref.value('@entityType2', 'INT') AS entityType2
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId2 = (SELECT ref.value('@entityId2', 'INT') AS entityId2
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityType3 = (SELECT ref.value('@entityType3', 'INT') AS entityType3
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId3 = (SELECT ref.value('@entityId3', 'INT') AS entityId3
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityType4 = (SELECT ref.value('@entityType4', 'INT') AS entityType4
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId4 = (SELECT ref.value('@entityId4', 'INT') AS entityId4
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityType5 = (SELECT ref.value('@entityType5', 'INT') AS entityType5
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref)),
    entityId5 = (SELECT ref.value('@entityId5', 'INT') AS entityId5
                    FROM entityAssociatedModifiedBlob.nodes('entityAssociated') R (ref))
DECLARE @tempentitytype		INT = 0
DECLARE @SQLStatement		NVARCHAR(MAX)
DECLARE @ParmDefinition		NVARCHAR(500)
DECLARE @invalid			INT
DECLARE tempcursor CURSOR FOR
    SELECT DISTINCT dbo.getEntityLevelFromEntityHierarchy(entityType1, entityType2, entityType3, entityTYpe4, entityType5)
    FROM #EntityListTableTemp
OPEN tempcursor
FETCH NEXT FROM tempcursor INTO @tempentitytype
WHILE @@FETCH_STATUS = 0
BEGIN
	IF EXISTS (SELECT 1 FROM APP_Entity WHERE entityType = @tempentitytype)
	BEGIN
IF (@tempentitytype NOT IN (3, 4, 5, 6, 7))
		BEGIN
			SET @invalid = 0
			SET @SQLStatement = N'SET @output = ISNULL((SELECT DISTINCT 1 FROM #EntityListTableTemp tbl LEFT OUTER JOIN '
									+ (SELECT tableName FROM APP_Entity WHERE entityType = @tempentitytype)
									+ ' entity ON tbl.entityType1 = @entityType AND tbl.entityId1 = entity.'
									+ (SELECT idColName FROM APP_Entity WHERE entityType = @tempentitytype)
									+ ' WHERE tbl.entityType1 = @entityType AND entity.'
									+ (SELECT idColName FROM APP_Entity WHERE entityType = @tempentitytype)
									+ ' IS NULL), 0)'
			SET @ParmDefinition = N' @entityType INT, @output INT OUTPUT';
			EXECUTE sp_executesql @SQLStatement, @ParmDefinition, @entityType = @tempentitytype, @output = @invalid OUTPUT
			IF (@invalid <> 0)
			BEGIN
				SET @retVal = 0
				GOTO EXIT_PRO
			END
		END
		ELSE
		BEGIN
			SET @invalid = 0
IF @tempentitytype = 3
			BEGIN
				SELECT @invalid = ISNULL((SELECT DISTINCT 1
					FROM #EntityListTableTemp tbl
						LEFT OUTER JOIN APP_Client client
ON tbl.entityType1 = 3 AND tbl.entityId1 = client.id
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 3
							AND client.id IS NULL), 0)
			END
ELSE IF @tempentitytype = 4
			BEGIN
				SELECT @invalid = ISNULL((SELECT DISTINCT 1
					FROM #EntityListTableTemp tbl
						LEFT OUTER JOIN APP_Client client
ON tbl.entityType1 = 3 AND tbl.entityId1 = client.id
						LEFT OUTER JOIN APP_IDAType ida
ON tbl.entityType2 = 4 AND tbl.entityId2 = ida.type
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 4
							AND (client.id IS NULL OR ida.type IS NULL)), 0)
			END
ELSE IF @tempentitytype = 5
			BEGIN
				SELECT @invalid = ISNULL((SELECT DISTINCT 1
					FROM #EntityListTableTemp tbl
						LEFT OUTER JOIN APP_Client client
ON tbl.entityType1 = 3 AND tbl.entityId1 = client.id
						LEFT OUTER JOIN APP_IDAType ida
ON tbl.entityType2 = 4 AND tbl.entityId2 = ida.type
						LEFT OUTER JOIN APP_InstanceName instance
ON tbl.entityType3 = 5 AND tbl.entityId3 = instance.id
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 5
							AND (client.id IS NULL OR ida.type IS NULL OR instance.id IS NULL)), 0)
			END
ELSE IF @tempentitytype = 6
			BEGIN
				SELECT @invalid = ISNULL((SELECT DISTINCT 1
					FROM #EntityListTableTemp tbl
						LEFT OUTER JOIN APP_Client client
ON tbl.entityType1 = 3 AND tbl.entityId1 = client.id
						LEFT OUTER JOIN APP_IDAType ida
ON tbl.entityType2 = 4 AND tbl.entityId2 = ida.type
						LEFT OUTER JOIN APP_InstanceName instance
ON tbl.entityType3 = 5 AND tbl.entityId3 = instance.id
						LEFT OUTER JOIN APP_BackupSetName backupset
ON tbl.entityType4 = 6 AND tbl.entityId4 = backupset.id
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 6
							AND (client.id IS NULL OR ida.type IS NULL OR instance.id IS NULL OR backupset.id IS NULL)), 0)
			END
ELSE IF @tempentitytype = 7
			BEGIN
				SELECT @invalid = ISNULL((SELECT DISTINCT 1
					FROM #EntityListTableTemp tbl
						LEFT OUTER JOIN APP_Client client
ON tbl.entityType1 = 3 AND tbl.entityId1 = client.id
						LEFT OUTER JOIN APP_IDAType ida
ON tbl.entityType2 = 4 AND tbl.entityId2 = ida.type
						LEFT OUTER JOIN APP_InstanceName instance
ON tbl.entityType3 = 5 AND tbl.entityId3 = instance.id
						LEFT OUTER JOIN APP_BackupSetName backupset
ON tbl.entityType4 = 6 AND tbl.entityId4 = backupset.id
						LEFT OUTER JOIN APP_Application subclient
ON tbl.entityType5 = 7 AND tbl.entityId5 = subclient.id
WHERE dbo.getEntityLevelFromEntityHierarchy(tbl.entityType1, tbl.entityType2, tbl.entityType3, tbl.entityTYpe4, tbl.entityType5) = 7
							AND (client.id IS NULL OR ida.type IS NULL OR instance.id IS NULL OR backupset.id IS NULL OR subclient.id IS NULL)), 0)
			END
			IF (@invalid <> 0)
			BEGIN
				SET @retVal = 0
				GOTO EXIT_PRO
			END
		END
	END
	ELSE
	BEGIN
		SET @retVal = 0
		GOTO EXIT_PRO
	END
    FETCH NEXT FROM tempcursor INTO @tempentitytype
END
CLOSE tempcursor
DEALLOCATE tempcursor
EXIT_PRO:
IF( CURSOR_STATUS('global', 'tempcursor') >= 0   OR CURSOR_STATUS('local', 'tempcursor') >= 0 )  -- CLOSE CURSOR IF OPEN
CLOSE tempcursor
IF( CURSOR_STATUS('global','tempcursor') = -1     OR CURSOR_STATUS('local','tempcursor') = -1 )
DEALLOCATE tempcursor
SELECT @retval
GO

IF EXISTS (select * from GxQscripts where name = 'NTValidateEntityList')
	delete from GxQscripts where name = 'NTValidateEntityList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTValidateEntityList')
	delete from GXDBVersions where aliasname = 'NTValidateEntityList'
GO

insert into GXDBVersions values(2, 'NTValidateEntityList',  '00000000000000000000', 'NTValidateEntityList', '00000000000000000000')
GO

