

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTUpdateAlertMessageForLocale.sp] ---------- 

-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTUpdateAlertMessageForLocale.sp,v $ $Id: NTUpdateAlertMessageForLocale.sp,v 1.1.2.2 2018/06/16 12:38:30 vdevassy Exp $";
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  NTUpdateAlertMessageForLocale()
--  |
--  | Description:  Updates localized message for all alerts.
--  |
--  |       Input:
--	|
--	|
--  |      Output:
--  |      Return:
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--	|	1.1		   Madhusudhanan N
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTUpdateAlertMessageForLocale <<<'

IF EXISTS (select * from sysobjects where name='NTUpdateAlertMessageForLocale')
	drop procedure NTUpdateAlertMessageForLocale
IF EXISTS (select * from GxQscripts where name='NTUpdateAlertMessageForLocale')
	delete from GxQscripts where name = 'NTUpdateAlertMessageForLocale'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTUpdateAlertMessageForLocale')
	delete from GXDBVersions where aliasname = 'NTUpdateAlertMessageForLocale'
GO
print '... Creating Procedure: NTUpdateAlertMessageForLocale'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure NTUpdateAlertMessageForLocale
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
  @userId Integer,
  @localeId Integer
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @o_errCode INTEGER = 0
DECLARE @o_errString NVARCHAR(1024) = ''
-- First check whether userId passed is tenant admin or MSP admin. If not throw error.
DECLARE @userRole   INTEGER
DECLARE @providerId INTEGER
DECLARE @startTranHere INTEGER = 0
EXEC AppGetUserRoleType  @userId, @userRole OUTPUT, @providerId  OUTPUT, @o_errCode OUTPUT, @o_errString OUTPUT
IF (@o_errCode <> 0)
BEGIN
	GOTO END_SP
END
-- If user isnt admin, throw error right away
IF (@userRole <> 0 AND @userRole <> 1 )
BEGIN
SET @o_errCode = (1878 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @o_errString = dbo.fn_EvFormatEventMsgText(0, @localeId, @o_errCode, 0,2)
	GOTO END_SP
END
DECLARE @loggedInUserOrg INTEGER = 0
SET @loggedInUserOrg = dbo.AppGetOrganizationForUser(@userID)
DECLARE @loggedInUserOrgName NVARCHAR(255)  = ''
SET @loggedInUserOrgName = dbo.AppGetOrganizationNameForUser(@userID)
DECLARE @localeName NVARCHAR(255) = ''
SELECT @localeName = displayString
FROM EvLocales WITH (NOLOCK)
WHERE cvLocaleId = @localeId
IF NOT EXISTS(SELECT 1 FROM NTNotificationTemplate WHERE locale=@localeId)
BEGIN
SET @o_errCode = (3667 | (CAST(POWER(2, 24) AS BIGINT) * 35))
	SET @o_errString = dbo.fn_EvFormatEventMsgText(0, @localeId, @o_errCode, 0,2)
	GOTO END_SP
END
if object_id('tempdb.dbo.#AlertLocTextUpdate') is not null
BEGIN
    DROP TABLE #AlertLocTextUpdate
END
CREATE TABLE #AlertLocTextUpdate (
	NTNotificationID	INT	,
	defaultHTMLMessage  NVARCHAR(MAX),
	defaultTextMessage  NVARCHAR(MAX),
	PRIMARY KEY (NTNotificationID)
)
INSERT INTO #AlertLocTextUpdate(NTNotificationID)
SELECT DISTINCT NTNotificationRule.ID
FROM NTNotificationRule (NOLOCK)
CROSS APPLY dbo.sec_getCreatorIdForEntity(64,id,0,0,0,0,0,0,0,0) Creator
LEFT JOIN UMGroups ON Creator.creatoruserGroupID = UMGroups.Id
WHERE NTNotificationRule.revision = 1
AND (NTNotificationRule.status & 2 ) = 0 -- We should not do this for deleted alerts.
-- If organizationId passed is 0, then we do for all commcell alerts. Else we do for tenant alerts only.
AND ( (Creator.creatoruserID>0 AND dbo.AppGetOrganizationForUser(Creator.creatoruserID) = @loggedInUserOrg) OR
		(Creator.creatoruserGroupID>0 AND UMGroups.umdsProviderId = @loggedInUserOrg) OR
		(Creator.creatoruserID = 0 AND Creator.creatorUserGroupId = 0 AND dbo.AppGetOrganizationForUser(notifOwner)=@loggedInUserOrg)
	)
AND alertTypeId<> 65
AND alertTypeId<> 62
AND alertTypeId<> 57
-- Dont do template updation for subscription based alerts.
AND (status & 128 ) = 0
BEGIN TRY
	BEGIN TRAN
	SET @startTranHere = 1
	UPDATE #AlertLocTextUpdate
	SET defaultHTMLMessage = dbo.NTGetDefaultAlertMessageWrapper(NTNotificationID,@localeId,1),
	defaultTextMessage = dbo.NTGetDefaultAlertMessageWrapper(NTNotificationID,@localeId,0)
	UPDATE NTNotificationRule
	SET locale = @localeId
	FROM NTNotificationRule INNER JOIN #AlertLocTextUpdate AlertLocTextUpdate ON
	AlertLocTextUpdate.NTNotificationID = NTNotificationRule.ID
	-- For default system created alerts as well as defayult organization alerts, replace messageIds and get formatted message.
	UPDATE NTMessageFormat
	SET formatStringHtml = AlertLocTextUpdate.defaultHTMLMessage
	FROM NTMessageFormat
	INNER JOIN #AlertLocTextUpdate AlertLocTextUpdate ON
	AlertLocTextUpdate.NTNotificationID = NTMessageFormat.NTNotificationID
	AND NTMessageFormat.messageType IN (1,8192)
	--  CVGui::NotificationType_EMAIL , CVGui::NotificationType_LIVEFEEDS
	UPDATE NTMessageFormat
	SET formatString = AlertLocTextUpdate.defaultTextMessage
	FROM NTMessageFormat
	INNER JOIN #AlertLocTextUpdate AlertLocTextUpdate ON
	AlertLocTextUpdate.NTNotificationID = NTMessageFormat.NTNotificationID
	AND NTMessageFormat.messageType IN (1,4,8,8192,32768)
	--  CVGui::NotificationType_EMAIL , CVGui::NotificationType_SNMP, CVGui::NotificationType_APPLOG, CVGui::NotificationType_SCOM  CVGui::NotificationType_LIVEFEEDS
	---------------------------------------------------
    -- Audit Parameters
    ---------------------------------------------------
    DECLARE @opMsgId            INTEGER
    DECLARE @opEvMsgId          INTEGER
    DECLARE @opId               INTEGER
    DECLARE @paramMsgId         INTEGER
    DECLARE @paramData          NVARCHAR(1024)
    DECLARE @dataIsEvent        INTEGER = 0
    ----------------------------------------------------
SET @opMsgId = (616 | (CAST(POWER(2, 24) AS BIGINT) * 84))
    EXEC EvGuiAuditSetOperation @opMsgId, @userId, @opEvMsgId OUTPUT, @opId OUTPUT
	IF @loggedInUserOrg <> 0
	BEGIN
SET @paramMsgId  = (1656 | (CAST(POWER(2, 24) AS BIGINT) * 85))
		EXEC EvGuiAuditSetParamData @opId, @loggedInUserOrgName, @dataIsEvent
		EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
	END
SET @paramMsgId  = (846 | (CAST(POWER(2, 24) AS BIGINT) * 85))
	EXEC EvGuiAuditSetParamData @opId, @localeName, @dataIsEvent
	EXEC EvGuiAuditSetParameter @opId, @paramMsgId, @userId
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     SET @o_errCode = 1
 END CATCH
END_SP:
IF (@startTranHere=1)
BEGIN
	IF @o_errCode = 0
	BEGIN
		COMMIT TRAN
	END
	ELSE
	BEGIN
		ROLLBACK TRAN
	END
END
if object_id('tempdb.dbo.#AlertLocTextUpdate') is not null
BEGIN
    DROP TABLE #AlertLocTextUpdate
END
DECLARE @xmlOutput XML
SET @xmlOutput = ( SELECT	@o_errCode '@errorCode' ,@o_errString '@errorMessage'
FOR XML PATH('Api_GenericResp') )
SELECT @xmlOutput AS xmlOutput
GO

IF EXISTS (select * from GxQscripts where name = 'NTUpdateAlertMessageForLocale')
	delete from GxQscripts where name = 'NTUpdateAlertMessageForLocale'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTUpdateAlertMessageForLocale')
	delete from GXDBVersions where aliasname = 'NTUpdateAlertMessageForLocale'
GO

insert into GXDBVersions values(2, 'NTUpdateAlertMessageForLocale',  '00010001000200020000', 'NTUpdateAlertMessageForLocale', '00010001000200020000')
GO

