

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTPreprocessTriggerTimeForRules.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  NTPreprocessTriggerTimeForRules()
--  |
--  | Description:  Preprocess for next trigger time computation for rules.
--  |
--  |      Input:   ???
--  |
--  |      Output:  Retrieves next repeated trigger time for each alert and escalation level.
--  |
--  |      Notes:
--  |
--  |   Revisions  Author		Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        mnatarajan 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTPreprocessTriggerTimeForRules')
BEGIN
	print '>>> Drop Stored Procedure: NTPreprocessTriggerTimeForRules <<<'
	drop procedure NTPreprocessTriggerTimeForRules
END
IF EXISTS (select * from GxQscripts where name='NTPreprocessTriggerTimeForRules')
	delete from GxQscripts where name = 'NTPreprocessTriggerTimeForRules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTPreprocessTriggerTimeForRules')
	delete from GXDBVersions where aliasname = 'NTPreprocessTriggerTimeForRules'
GO
print '... Creating Procedure: NTPreprocessTriggerTimeForRules'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTPreprocessTriggerTimeForRules
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
  DECLARE @lastRunTime integer
  DECLARE @lastRunTimeStr varchar(MAX)
set transaction isolation level read uncommitted
declare @ntRuleNextTriggerTime table
(
	ntRuleId int,
	alertType int,
	escLevel int,
	nextTriggerTime datetime,
	persistTimeSeconds int,
	isModified int
)
declare @csTimeZone nvarchar(max)
declare @lastNTNextRunTimeComputed int
set @csTimeZone = dbo.GetClientTimeZone(2)
SET @lastNTNextRunTimeComputed = ISNULL((Select value FROM GXGlobalParam with (nolock) WHERE Name = 'NTNextRunTimeComputed' and modified=0), N'0')
Insert into @ntRuleNextTriggerTime
select distinct ruleId,alertTypeId,esclationLevel,null,persistTimeSeconds,
	case when NTNotificationRule.lastModified>=@lastNTNextRunTimeComputed then 1
	else 0
	end
from NTSelCriteria
inner join NTNotificationRule on
NTSelCriteria.ruleId=NTNotificationRule.id
and NTNotificationRule.revision>0
and (NTNotificationRule.status&3)=0
-- In case lastComputedTime isnt computed so far for some rules, we compute it here.
Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select NextRepeated.componentNameId,N'NTLastRepeatedRunTimeForRule','7',   dbo.NTComputeLastRunTimeAttr(NextRepeated.componentNameId,1) ,dbo.getunixtime(getutcdate()),0
from NTNotificationProp NextRepeated
left join NTNotificationProp lastRepeated
on NextRepeated.componentNameId = lastRepeated.componentNameId
and NextRepeated.attrName = 'NTNextRepeatedRunTimeForRule'
and lastRepeated.attrName = 'NTLastRepeatedRunTimeForRule'
where lastRepeated.componentNameId is NULL
and NextRepeated.attrName = 'NTNextRepeatedRunTimeForRule'
-- In case lastComputedTime for escalated alerts isnt computed so far for some rules, we compute it here.
Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select NextRepeated.componentNameId,N'NTLastRepeatedRunTimeForRuleEsc','7',   dbo.NTComputeLastRunTimeAttr(NextRepeated.componentNameId,2) ,dbo.getunixtime(getutcdate()),0
from NTNotificationProp NextRepeated
left join NTNotificationProp lastRepeated
on NextRepeated.componentNameId = lastRepeated.componentNameId
and NextRepeated.attrName = 'NTNextRepeatedRunTimeForRuleEsc'
and lastRepeated.attrName = 'NTLastRepeatedRunTimeForRuleEsc'
where lastRepeated.componentNameId is NULL
and NextRepeated.attrName = 'NTNextRepeatedRunTimeForRuleEsc'
-- In case alert is modified, recompute next trigger time.
Update NTNotificationProp
set attrval = dbo.NTComputeNextRunTimeAttr(NTNotificationProp.componentnameid,1),
created = dbo.getunixtime(getutcdate())
from NTNotificationProp inner join @ntRuleNextTriggerTime NtRuleNextTriggerTime
on NTNotificationProp.componentNameid=NtRuleNextTriggerTime.ntRuleId
and NtRuleNextTriggerTime.isModified = 1
and NTNotificationProp.attrname='NTNextRepeatedRunTimeForRule'
Update NTNotificationProp
set attrval = dbo.NTComputeNextRunTimeAttr(NTNotificationProp.componentnameid,2),
created = dbo.getunixtime(getutcdate())
from NTNotificationProp inner join @ntRuleNextTriggerTime NtRuleNextTriggerTime
on NTNotificationProp.componentNameid=NtRuleNextTriggerTime.ntRuleId
and NtRuleNextTriggerTime.isModified = 1
and NTNotificationProp.attrname='NTNextRepeatedRunTimeForRuleEsc'
-- List of rules which reached their next run time.
declare @notifRulesTable table
(
	notifRuleId int,
	escLevel int
)
-- Also insert notification rules which support repeated alerts (regular/escalated) and which do not have any detected alerts for the rule. So that next run time is computed only from time there are alerts in pending state
Insert into @notifRulesTable
select NTProp.componentnameId,1
from
(
	select NTDParams.value,min(NTDParams.created) as Created
	from NTDParams
	inner join NTDetectedalerts on NTDParams.eventId = NTDetectedAlerts.eventId
	and (NTDetectedAlerts.processStat&2)>0
	and NTDetectedAlerts.processStat!=8
	and NTDParams.type = 143 --  enumMatchedRuleIds = 143,
	and isnumeric(value)=1
	group by value
)  NTDParamGrouped
inner join
(
	select componentnameId,attrVal
	from NTnotificationProp
	inner join NTSelCriteria
    on  NTSelCriteria.ruleId = NTnotificationProp.componentnameId
	and NTSelCriteria.esclationLevel=1
	and NTSelCriteria.persistTimeSeconds>0
	and attrName='NTLastRepeatedRunTimeForRule'
) NTProp
on NTDParamGrouped.value = convert(nvarchar(10),NTProp.componentnameId)
and cast(NTProp.attrval as int)<NTDParamGrouped.Created
union
select NTProp.componentnameId,2
from
(
	select NTDParams.value,min(NTDParams.created) as Created
	from NTDParams
	inner join NTDetectedalerts on NTDParams.eventId = NTDetectedAlerts.eventId
	and (NTDetectedAlerts.processStat&2)>0
	and NTDetectedAlerts.processStat!=8
	and NTDParams.type = 144 --  enumMatchedRuleIdsEscalated = 144,
	and isnumeric(value)=1
	group by value
)  NTDParamGrouped
inner join
(
	select attrval,componentnameid
	from NTnotificationProp
	inner join NTSelCriteria on NTSelCriteria.ruleId = NTnotificationProp.componentnameId
	and NTSelCriteria.esclationLevel=2
	and NTSelCriteria.persistTimeSeconds>0
	and NTnotificationProp.attrName='NTLastRepeatedRunTimeForRuleEsc'
)NTProp
on
NTDParamGrouped.value = convert(nvarchar(10),NTProp.componentnameId)
and cast(NTProp.attrval as int)<NTDParamGrouped.Created
-- update next run time for alerts to some value less than current time so that it gets recomputed.
Update NTnotificationProp
set attrVal=@lastNTNextRunTimeComputed-1000,
created = dbo.getunixtime(getutcdate())
from NTnotificationProp inner join @notifRulesTable notifRulesTable on
notifRulesTable.notifRuleid=NTnotificationProp.componentnameId
and NTnotificationProp.attrName='NTNextRepeatedRunTimeForRule'
and notifRulesTable.escLevel = 1
Update NTnotificationProp
set attrVal=@lastNTNextRunTimeComputed-1000,
created = dbo.getunixtime(getutcdate())
from NTnotificationProp inner join @notifRulesTable notifRulesTable on
notifRulesTable.notifRuleid=NTnotificationProp.componentnameId
and NTnotificationProp.attrName='NTNextRepeatedRunTimeForRuleEsc'
and notifRulesTable.escLevel = 2
-- Update Next RepeatedAlert triggerTime wherever appropriate for all rules (for both regular and escalatedlevels) if needed
Merge NTnotificationProp
using (select distinct ruleId,persistTimeSeconds from NTSelCriteria where esclationLevel=1 and persistTimeSeconds>0) as RegRuleRepeatedTime
on NTnotificationProp.componentNameId=RegRuleRepeatedTime.ruleId and NTnotificationProp.attrname=N'NTNextRepeatedRunTimeForRule'
and NTnotificationProp.modified=0
WHEN MATCHED AND convert(int,attrval)<@lastNTNextRunTimeComputed
   THEN UPDATE SET attrVal = dbo.getunixtime(dateadd(second,RegRuleRepeatedTime.persistTimeSeconds,getutcdate())),
   created = dbo.getunixtime(getutcdate())
when Not matched then
	Insert(componentNameId,attrName,attrType,attrVal,created,modified)
	values(RegRuleRepeatedTime.ruleId,N'NTNextRepeatedRunTimeForRule','7',dbo.getunixtime(dateadd(second,RegRuleRepeatedTime.persistTimeSeconds,getutcdate())),dbo.getunixtime(getutcdate()),0)
Output inserted.componentNameId,1 into @notifRulesTable;
Merge NTnotificationProp
using (select distinct ruleId,persistTimeSeconds from NTSelCriteria where esclationLevel=2 and persistTimeSeconds>0) as RegRuleRepeatedTime
on NTnotificationProp.componentNameId=RegRuleRepeatedTime.ruleId and NTnotificationProp.attrname=N'NTNextRepeatedRunTimeForRuleEsc'
and NTnotificationProp.modified=0
WHEN MATCHED AND convert(int,attrval)<@lastNTNextRunTimeComputed
   THEN UPDATE SET attrVal = dbo.getunixtime(dateadd(second,RegRuleRepeatedTime.persistTimeSeconds,getutcdate())),
   created = dbo.getunixtime(getutcdate())
when Not matched then
	Insert(componentNameId,attrName,attrType,attrVal,created,modified)
	values(RegRuleRepeatedTime.ruleId,N'NTNextRepeatedRunTimeForRuleEsc','7',dbo.getunixtime(dateadd(second,RegRuleRepeatedTime.persistTimeSeconds,getutcdate())),dbo.getunixtime(getutcdate()),0)
Output inserted.componentNameId,2 into @notifRulesTable;
-- update last run time
Update NTnotificationProp
set attrVal=@lastNTNextRunTimeComputed,
created = dbo.getunixtime(getutcdate())
from NTnotificationProp inner join @notifRulesTable notifRulesTable on
notifRulesTable.notifRuleid=NTnotificationProp.componentnameId
and NTnotificationProp.attrName='NTLastRepeatedRunTimeForRule'
and notifRulesTable.escLevel = 1
Update NTnotificationProp
set attrVal=@lastNTNextRunTimeComputed,
created = dbo.getunixtime(getutcdate())
from NTnotificationProp inner join @notifRulesTable notifRulesTable on
notifRulesTable.notifRuleid=NTnotificationProp.componentnameId
and NTnotificationProp.attrName='NTLastRepeatedRunTimeForRuleEsc'
and notifRulesTable.escLevel = 2
declare @timeStamp				integer
SET @timeStamp = dbo.GetUnixTime (GetUTCdate())
if exists(select 1 from Gxglobalparam where name='NTNextRunTimeComputed' and modified=0)
begin
	update GxGlobalParam
	set value=@timeStamp
	where name='NTNextRunTimeComputed'
	and modified=0
end
else
begin
	Insert into GxGlobalParam
	select 'NTNextRunTimeComputed',@timeStamp,0,0
end
SET @lastNTNextRunTimeComputed = ISNULL((Select value FROM GXGlobalParam with (nolock) WHERE Name = 'NTNextRunTimeComputed' and modified=0), N'0')
-- Idea is we update the next trigger time for rules one cycle after evaluating next trigger time for detected alerts and matching them.
select @lastNTNextRunTimeComputed,dbo.UTCToLocalDateTimeConversionManaged( DATEADD(second, @lastNTNextRunTimeComputed, '01/01/1970') , @csTimeZone)
GO

IF EXISTS (select * from GxQscripts where name = 'NTPreprocessTriggerTimeForRules')
	delete from GxQscripts where name = 'NTPreprocessTriggerTimeForRules'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTPreprocessTriggerTimeForRules')
	delete from GXDBVersions where aliasname = 'NTPreprocessTriggerTimeForRules'
GO

insert into GXDBVersions values(2, 'NTPreprocessTriggerTimeForRules',  '00000000000000000000', 'NTPreprocessTriggerTimeForRules', '00000000000000000000')
GO

