

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTMatchEntity.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTMatchEntity.sp,v $ $Id: NTMatchEntity.sp,v 1.1.2.8 2018/03/27 08:54:36 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   NTMatchEntity   - Fetch alert details for mongo client processing.
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTMatchEntity <<<'

IF EXISTS (select * from sysobjects where name='NTMatchEntity')
	drop procedure NTMatchEntity
IF EXISTS (select * from GxQscripts where name='NTMatchEntity')
	delete from GxQscripts where name = 'NTMatchEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTMatchEntity')
	delete from GXDBVersions where aliasname = 'NTMatchEntity'
GO
print '... Creating Procedure: NTMatchEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTMatchEntity
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlData xml
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @ntRuleId int=0
-- Get the unique list of entities from request.
if object_id('tempdb.dbo.#entitiesInReq') is not null
BEGIN
	DROP TABLE #entitiesInReq
END
Create table #entitiesInReq
(
	entityInReqID			integer identity(1,1),
	entityType1				integer default 0,
	entityId1				integer default 0,
	entityType2				integer default 0,
	entityId2				integer default 0,
	entityType3				integer default 0,
	entityId3				integer default 0,
	entityType4				integer default 0,
	entityId4				integer default 0,
	entityType5				integer default 0,
	entityId5				integer default 0,
	entity					xml,
	entityString			nvarchar(max) null,
	primary key (entityInReqID)
)
DECLARE	@isSubscriptionBasedAlert	integer = 0
declare @isEntityMatched			integer = 0
declare @isEntityMatchedForDigest	integer = 0
declare @isDigestReq				integer = 0
DECLARE @entityHierarchy			xml
declare @outputXml					xml
declare @isDigestMethodEnabled		integer = 1
declare @entityMatched				xml	= null
select @isDigestMethodEnabled = value from Gxglobalparam WITH (READUNCOMMITTED)
where name='NTShareIsDigestEnabled'
SELECT @ntRuleId = ISNULL (( SELECT ref.value('@alertId', 'INT')
                    FROM @xmlData.nodes ('Api_NTMatchEntityReq/alert') R(ref)), 0)
SELECT @isDigestReq = ISNULL (( SELECT ref.value('@isDigestReq', 'INT')
                    FROM @xmlData.nodes ('Api_NTMatchEntityReq') R(ref)), 0)
-- If its a digest request and digest is not enabled, then return no match response
if (@isDigestMethodEnabled=0 and @isDigestReq>0)
begin
	set @outputXml = (
		select 0 '@doesEntityMatchForReq',
		0 '@doesEntityMatchForDigestReq'
		for xml path('Api_NTMatchEntityResp')
	)
	select @outputXml
	return
end
-- If the alert is disabled/deleted then we will return match as false
if exists(select 1 from NTNotificationRule where id=@ntRuleId
and (NTNotificationRule.status& (1|2|512 ))>0
)
begin
	set @isEntityMatched=0
	set @outputXml = (select @isEntityMatched '@doesEntityMatchForReq'
	for xml path('Api_NTMatchEntityResp'))
	select @outputXml
	return
end
	Insert into #entitiesInReq(entity)
	select ref.query('.')
		FROM @xmlData.nodes('Api_NTMatchEntityReq/entities') R(ref)
	update #entitiesInReq
	set entityString = convert(nvarchar(max),entity)
	-- Convert entity node to CvEntities_GenericEntity
	update #entitiesInReq
	set entityString = replace(entityString,'<entities>','<CvEntities_GenericEntity>')
	update #entitiesInReq
	set entityString = replace(entityString,'</entities>','</CvEntities_GenericEntity>')
	update #entitiesInReq
	set entityString = replace(entityString,'<entities ','<CvEntities_GenericEntity ')
	update #entitiesInReq
	set entity	= convert(xml,entityString)
	-- Check whether its a subscription based alert.
select @isSubscriptionBasedAlert=1 from NTNotificationRule where ((status & 128)>0)
			and id = @ntRuleId
	if object_id('tempdb.dbo.#userSubscriptionData') is not null
	BEGIN
		DROP TABLE #userSubscriptionData
	END
	CREATE TABLE #userSubscriptionData
	(
		userId integer NOT NULL,
		flags int,
		entityInReqId integer,
		primary key(userId,entityInReqId)
	)
	if (@isSubscriptionBasedAlert=0)
	begin
		-- For digest requests dont match against regular alert.
		if @isDigestReq=0
		begin
			declare @subscripNTRuleXmlEntityList xml
			select @subscripNTRuleXmlEntityList = xmlEntityList from NTNotificationRule
			where id=@ntRuleId
			declare @entityMatchedStr nvarchar(max)
			set @subscripNTRuleXmlEntityList = @subscripNTRuleXmlEntityList.query('CVGui_CommCellTreeNode/associations')
			set @subscripNTRuleXmlEntityList = convert(xml,replace(replace(convert(nvarchar(max),@subscripNTRuleXmlEntityList),
				'<associations','<entity'),'</associations>','</entity>'))
			set @subscripNTRuleXmlEntityList = (
				select @subscripNTRuleXmlEntityList.query('.')
				for xml path(''),root('App_Associations')
				)
			select @entityMatched=entity from #entitiesInReq entitiesInReq where dbo.IsEntityInAssocList(entity,@subscripNTRuleXmlEntityList, @ntRuleId)=1
			if @entityMatched is not null
			begin
				set @isEntityMatched = 1
				-- Change root from CvEntities_GenericEntity to matchedEntity
				set @entityMatchedStr = convert(nvarchar(max),@entityMatched)
				set @entityMatchedStr = replace(@entityMatchedStr,'<CvEntities_GenericEntity>','<matchedEntityRRecipients>')
				set @entityMatchedStr = replace(@entityMatchedStr,'</CvEntities_GenericEntity>','</matchedEntityRRecipients>')
				set @entityMatchedStr = replace(@entityMatchedStr,'<CvEntities_GenericEntity ','<matchedEntityRRecipients ')
				set @entityMatched	= convert(xml,@entityMatchedStr)
			end
		end
	end
	else
	begin
		-- From generic entity, get the hierarchy
		update #entitiesInReq
		set entity = dbo.getEntityTypeHirearchyXMLFromGenericEntityXML(entity)
		update #entitiesInReq
		set entityType1 = IsNull(entity.value('(entityAssociated/@entityType1)[1]', 'int'),0),
			entityId1 = IsNull(entity.value('(entityAssociated/@entityId1)[1]','int'),0),
			entityType2 = IsNull(entity.value('(entityAssociated/@entityType2)[1]','int'),0),
			entityId2 = IsNull(entity.value('(entityAssociated/@entityId2)[1]','int'),0),
			entityType3 = IsNull(entity.value('(entityAssociated/@entityType3)[1]','int'),0),
			entityId3 = IsNull(entity.value('(entityAssociated/@entityId3)[1]','int'),0),
			entityType4 = IsNull(entity.value('(entityAssociated/@entityType4)[1]','int'),0),
			entityId4 = IsNull(entity.value('(entityAssociated/@entityId4)[1]','int'),0),
			entityType5 = IsNull(entity.value('(entityAssociated/@entityType5)[1]','int'),0),
			entityId5 = IsNull(entity.value('(entityAssociated/@entityId5)[1]','int'),0)
		-- From the entity hierarchy identify users who have subscribed to this.
		Insert into #userSubscriptionData
		select distinct NTAlertSubScriptions.userId,NTAlertSubScriptions.flags,entitiesInReq.entityInReqId
		from NTAlertSubScriptions
		inner join #entitiesInReq entitiesInReq on ntRuleId=@ntRuleId and escalationLevel=1
		AND (NTAlertSubScriptions.entityId1 = entitiesInReq.entityId1 ) AND NTAlertSubScriptions.entityType1 = entitiesInReq.entityType1
		AND (NTAlertSubScriptions.entityId2 = entitiesInReq.entityId2 ) AND NTAlertSubScriptions.entityType2 = entitiesInReq.entityType2
		AND (NTAlertSubScriptions.entityId3 = entitiesInReq.entityId3 ) AND NTAlertSubScriptions.entityType3 = entitiesInReq.entityType3
		AND (NTAlertSubScriptions.entityId4 = entitiesInReq.entityId4 ) AND NTAlertSubScriptions.entityType4 = entitiesInReq.entityType4
		AND (NTAlertSubScriptions.entityId5 = entitiesInReq.entityId5 ) AND NTAlertSubScriptions.entityType5 = entitiesInReq.entityType5
		Insert into #userSubscriptionData
		select distinct NTAlertSubScriptions.userId,NTAlertSubScriptions.flags,entitiesInReq.entityInReqId
		from NTAlertSubScriptions
		inner join #entitiesInReq entitiesInReq on ntRuleId=@ntRuleId and escalationLevel=1
		AND (NTAlertSubScriptions.entityId1 = entitiesInReq.entityId1 ) AND NTAlertSubScriptions.entityType1 = entitiesInReq.entityType1
		AND (NTAlertSubScriptions.entityId2 = entitiesInReq.entityId2 ) AND NTAlertSubScriptions.entityType2 = entitiesInReq.entityType2
		AND (NTAlertSubScriptions.entityId3 = entitiesInReq.entityId3 ) AND NTAlertSubScriptions.entityType3 = entitiesInReq.entityType3
		AND (NTAlertSubScriptions.entityId4 = entitiesInReq.entityId4 ) AND NTAlertSubScriptions.entityType4 = entitiesInReq.entityType4
		AND (NTAlertSubScriptions.entityId5 = 0 ) AND NTAlertSubScriptions.entityType5 = 0 and entitiesInReq.entityId5>0
		left join #userSubscriptionData userSubscriptionData on NTAlertSubScriptions.userId=userSubscriptionData.userId and
		entitiesInReq.entityInReqId = userSubscriptionData.entityInReqId
		Where userSubscriptionData.userId is null
		Insert into #userSubscriptionData
		select distinct NTAlertSubScriptions.userId,NTAlertSubScriptions.flags,entitiesInReq.entityInReqId
		from NTAlertSubScriptions
		inner join #entitiesInReq entitiesInReq on ntRuleId=@ntRuleId and escalationLevel=1
		AND (NTAlertSubScriptions.entityId1 = entitiesInReq.entityId1 ) AND NTAlertSubScriptions.entityType1 = entitiesInReq.entityType1
		AND (NTAlertSubScriptions.entityId2 = entitiesInReq.entityId2 ) AND NTAlertSubScriptions.entityType2 = entitiesInReq.entityType2
		AND (NTAlertSubScriptions.entityId3 = entitiesInReq.entityId3 ) AND NTAlertSubScriptions.entityType3 = entitiesInReq.entityType3
		AND (NTAlertSubScriptions.entityId4 = 0 ) AND NTAlertSubScriptions.entityType4 = 0
		AND (NTAlertSubScriptions.entityId5 = 0 ) AND NTAlertSubScriptions.entityType5 = 0 and entitiesInReq.entityId4>0
		left join #userSubscriptionData userSubscriptionData on NTAlertSubScriptions.userId=userSubscriptionData.userId and
		entitiesInReq.entityInReqId = userSubscriptionData.entityInReqId
		Where userSubscriptionData.userId is null
		Insert into #userSubscriptionData
		select distinct NTAlertSubScriptions.userId,NTAlertSubScriptions.flags,entitiesInReq.entityInReqId
		from NTAlertSubScriptions
		inner join #entitiesInReq entitiesInReq on ntRuleId=@ntRuleId and escalationLevel=1
		AND (NTAlertSubScriptions.entityId1 = entitiesInReq.entityId1 ) AND NTAlertSubScriptions.entityType1 = entitiesInReq.entityType1
		AND (NTAlertSubScriptions.entityId2 = entitiesInReq.entityId2 ) AND NTAlertSubScriptions.entityType2 = entitiesInReq.entityType2
		AND (NTAlertSubScriptions.entityId3 = 0 ) AND NTAlertSubScriptions.entityType3 = 0
		AND (NTAlertSubScriptions.entityId4 = 0 ) AND NTAlertSubScriptions.entityType4 = 0
		AND (NTAlertSubScriptions.entityId5 = 0 ) AND NTAlertSubScriptions.entityType5 = 0 and entitiesInReq.entityId3>0
		left join #userSubscriptionData userSubscriptionData on NTAlertSubScriptions.userId=userSubscriptionData.userId and
		entitiesInReq.entityInReqId = userSubscriptionData.entityInReqId
		Where userSubscriptionData.userId is null
		Insert into #userSubscriptionData
		select distinct NTAlertSubScriptions.userId,NTAlertSubScriptions.flags,entitiesInReq.entityInReqId
		from NTAlertSubScriptions
		inner join #entitiesInReq entitiesInReq on ntRuleId=@ntRuleId and escalationLevel=1
		AND (NTAlertSubScriptions.entityId1 = entitiesInReq.entityId1 ) AND NTAlertSubScriptions.entityType1 = entitiesInReq.entityType1
		AND (NTAlertSubScriptions.entityId2 = 0 ) AND NTAlertSubScriptions.entityType2 = 0
		AND (NTAlertSubScriptions.entityId3 = 0 ) AND NTAlertSubScriptions.entityType3 = 0
		AND (NTAlertSubScriptions.entityId4 = 0 ) AND NTAlertSubScriptions.entityType4 = 0
		AND (NTAlertSubScriptions.entityId5 = 0 ) AND NTAlertSubScriptions.entityType5 = 0 and entitiesInReq.entityId2>0
		left join #userSubscriptionData userSubscriptionData on NTAlertSubScriptions.userId=userSubscriptionData.userId and
		entitiesInReq.entityInReqId = userSubscriptionData.entityInReqId
		Where userSubscriptionData.userId is null
		Insert into #userSubscriptionData
		select distinct NTAlertSubScriptions.userId,NTAlertSubScriptions.flags,entitiesInReq.entityInReqId
		from NTAlertSubScriptions
		inner join #entitiesInReq entitiesInReq on ntRuleId=@ntRuleId and escalationLevel=1
		AND (NTAlertSubScriptions.entityId1 = 0 ) AND NTAlertSubScriptions.entityType1 = 0
		AND (NTAlertSubScriptions.entityId2 = 0 ) AND NTAlertSubScriptions.entityType2 = 0
		AND (NTAlertSubScriptions.entityId3 = 0 ) AND NTAlertSubScriptions.entityType3 = 0
		AND (NTAlertSubScriptions.entityId4 = 0 ) AND NTAlertSubScriptions.entityType4 = 0
		AND (NTAlertSubScriptions.entityId5 = 0 ) AND NTAlertSubScriptions.entityType5 = 0 and entitiesInReq.entityId1>0
		left join #userSubscriptionData userSubscriptionData on NTAlertSubScriptions.userId=userSubscriptionData.userId and
		entitiesInReq.entityInReqId = userSubscriptionData.entityInReqId
		Where userSubscriptionData.userId is null
		if @isDigestReq=0
		begin
			-- Check whether user has opted for Digest notification.
			select @isEntityMatched = 1 from #userSubscriptionData
where (flags&1) >0 and (flags&2)=0
			-- Check whether user has opted for Digest notification
			if (@isDigestMethodEnabled>0)
			begin
				select @isEntityMatchedForDigest = 1 from #userSubscriptionData
where (flags&1) >0 and (flags&2)>0
			end
			-- Keep only recipients which have no digest notification and who have subscribed.
			delete from #userSubscriptionData
where ( (flags&1)>0 and (flags&2)>0 )
		end
		else
		begin
			if (@isDigestMethodEnabled>0)
			begin
				select @isEntityMatched = 1 from #userSubscriptionData
where (flags&1) >0 and (flags&2)>0
				set @isEntityMatchedForDigest = @isEntityMatched
			end
			-- Keep only recipients which have digest notification and who have subscribed.
			delete from #userSubscriptionData
where ( (flags&1)>0 and (flags&2)=0 )
		end
	end
set @outputXml = (
	select @isEntityMatched '@doesEntityMatchForReq',
		@isEntityMatchedForDigest '@doesEntityMatchForDigestReq',
		@entityMatched.query('.'),
		(
			select userId '@userId', max(entitiesInReq.EntityId1) as '@shareId'
			from #userSubscriptionData userSubscriptionData
			inner join #entitiesInReq entitiesInReq on entitiesInReq.entityInReqId = userSubscriptionData.entityInReqId
where (flags&1) >0
			group by userID
			for xml path('matchedEntityRRecipients'),type
		)
		for xml path('Api_NTMatchEntityResp')
)
if @outputXml is null
begin
	set @outputXml='<Api_NTMatchEntityResp/>'
end
if object_id('tempdb.dbo.#entitiesInReq') is not null
BEGIN
	DROP TABLE #entitiesInReq
END
select @outputXml
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'NTMatchEntity')
	delete from GxQscripts where name = 'NTMatchEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTMatchEntity')
	delete from GXDBVersions where aliasname = 'NTMatchEntity'
GO

insert into GXDBVersions values(2, 'NTMatchEntity',  '00010001000200080000', 'NTMatchEntity', '00010001000200080000')
GO

