

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTMarkProcessedDbAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTMarkProcessedDbAlerts.sp,v $ $Id: NTMarkProcessedDbAlerts.sp,v 1.1.2.2 2018/03/20 00:15:59 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  NTMarkProcessedDbAlerts( int lastProcessedEvent )
--  |
--  | Description:  Marks  processed db alerts as processed.
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        nchorappan     Initial Edit
--  +========================================================================+
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTMarkProcessedDbAlerts <<<'

IF EXISTS (select * from sysobjects where name='NTMarkProcessedDbAlerts')
	drop procedure NTMarkProcessedDbAlerts
IF EXISTS (select * from GxQscripts where name='NTMarkProcessedDbAlerts')
	delete from GxQscripts where name = 'NTMarkProcessedDbAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTMarkProcessedDbAlerts')
	delete from GXDBVersions where aliasname = 'NTMarkProcessedDbAlerts'
GO
print '... Creating Procedure: NTMarkProcessedDbAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTMarkProcessedDbAlerts
  @lastProcessedDBAlerts int
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
UPDATE NTDBDetectedAlert
SET processStat = 1  -- processed
WHERE eventId <= @lastProcessedDBAlerts
select @@error
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'NTMarkProcessedDbAlerts')
	delete from GxQscripts where name = 'NTMarkProcessedDbAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTMarkProcessedDbAlerts')
	delete from GXDBVersions where aliasname = 'NTMarkProcessedDbAlerts'
GO

insert into GXDBVersions values(2, 'NTMarkProcessedDbAlerts',  '00010001000200020000', 'NTMarkProcessedDbAlerts', '00010001000200020000')
GO

