

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTLMPruneDelayedProcessedAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTLMPruneDelayedProcessedAlerts.sp,v $ $Id: NTLMPruneDelayedProcessedAlerts.sp,v 1.5.46.2 2018/03/20 00:48:20 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  NTLMPruneDelayedProcessedAlerts()
--  |
--  | Description:  Retrieves the Commcell Schedules
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        mali     Initial Edit
--  +========================================================================+
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTLMPruneDelayedProcessedAlerts <<<'

IF EXISTS (select * from sysobjects where name='NTLMPruneDelayedProcessedAlerts')
	drop procedure NTLMPruneDelayedProcessedAlerts
IF EXISTS (select * from GxQscripts where name='NTLMPruneDelayedProcessedAlerts')
	delete from GxQscripts where name = 'NTLMPruneDelayedProcessedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTLMPruneDelayedProcessedAlerts')
	delete from GXDBVersions where aliasname = 'NTLMPruneDelayedProcessedAlerts'
GO
print '... Creating Procedure: NTLMPruneDelayedProcessedAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTLMPruneDelayedProcessedAlerts
-- following are the "columns" returned, in the order in which they are returned
AS
SET NOCOUNT ON
if not exists
(
	select 1 from NTDetectedAlerts
	where processStat = 24 --eAlertStatusProcessedDelayedDelete
)
begin
	-- nothing to do..
	return
end
declare @monitoringCriteriaList table
(
	monitoringCriteriaId int,
	delayTime int
)
Insert into @monitoringCriteriaList
select distinct monitoringCriteriaId,0 from NTLMalert
declare @criteriaRuleAssoc table
(
	monitoringcriteriaId int,
	ruleId int,
	delayTime int
)
declare @xmlEntityList table
(
	ntRuleId int,
	xmlEntityList xml
)
Insert into @xmlEntityList
select id ,xmlEntityList
from NTnotificationRule with (nolock)
where id in
(
	select ruleId from NTSelCriteria with (nolock)
	where NTSelCriteria.availCriteriaid=61
)
-- Also only look at rules created for the given alert type.
and (alerttypeid=57 OR alerttypeid=62)
-- Handle the earlier format as before.
declare @allXmls xml
set @allXmls = (select ntRuleId '@ruleId',xmlEntityList
			from @xmlEntityList
		where xmlEntityList.exist('CVGui_CommCellTreeNode/associations')=1
		for xml path('eachRule'),root('newroot'))
declare @assocIdoc int
EXEC sp_xml_preparedocument @assocIdoc OUTPUT, @allXmls
--select @allXmls
Insert into @criteriaRuleAssoc
select isNull(criteriaId,0), ruleId,0
from OPENXML(@assocIdoc, '//newroot/eachRule/xmlEntityList/CVGui_CommCellTreeNode/associations', 0)
with (criteriaId int '@criteriaId',ruleId int '../../../@ruleId')
set @allXmls = (select ntRuleId '@ruleId',xmlEntityList
			from @xmlEntityList
		where xmlEntityList.exist('CVGui_CommCellTreeNode/associations')=0
		for xml path('eachRule'),root('newroot'))
if (@allXmls is null)
begin
	set @allXmls = '<newroot/>'
end
declare @idoc int
EXEC sp_xml_preparedocument @idoc OUTPUT, @allXmls
Insert into @criteriaRuleAssoc
select criteriaId, ruleId,0
from OPENXML(@idoc, '//newroot/eachRule/xmlEntityList/CVGui_CommCellTreeNode/criterias/criterias', 0)
with (criteriaId int '@criteriaId',ruleId int '../../../../@ruleId')
-- Now look at case where all criterias are selected.
;With rulesAllCriteriasSelected as
(
	select ruleId = ruleId
	from OPENXML(@idoc, '//newroot/eachRule/xmlEntityList/CVGui_CommCellTreeNode/criterias', 0)
	with (includeAll int '@includeAll',ruleId int '../../../@ruleId')
	where includeAll = 1
	union -- All criterias selected from associations level.
	select ruleId
	from @criteriaRuleAssoc
	where monitoringcriteriaId = 0
)
Insert into @criteriaRuleAssoc
select APP_Criteria.criteriaId,T.ruleId,0
from rulesAllCriteriasSelected T inner join
APP_MonitorAlertAssoc on APP_MonitorAlertAssoc.alertId = T.ruleId
inner join APP_Criteria on
APP_Criteria.monitorPolicyId = APP_MonitorAlertAssoc.monitorPolicyId
Update tempTbl
set delayTime = NTSelCriteria.delayTimeSeconds
from NTSelCriteria,@criteriaRuleAssoc tempTbl
where NTSelCriteria.ruleId = tempTbl.ruleId
update Criterias
set delayTime = T.delayTime
from @monitoringCriteriaList Criterias
inner join
(
	select criteriaRuleAssoc.monitoringcriteriaId,MAX(criteriaRuleAssoc.delayTime) as delayTime
	from @criteriaRuleAssoc criteriaRuleAssoc
	group by criteriaRuleAssoc.monitoringcriteriaId
) T
on T.monitoringcriteriaId = Criterias.monitoringCriteriaId
-- Now delete from NTDetectedAlerts who were created before this time
Update NTDetectedAlerts
set processStat=8
from NTDetectedAlerts
inner join NTLMalert on
NTDetectedAlerts.eventId = NTLMalert.eventId
inner join @monitoringCriteriaList criterias
on criterias.monitoringCriteriaId = NTLMalert.monitoringCriteriaId
where (alertType=57 OR alertType=62)
and processStat = 24 --eAlertStatusProcessedDelayedDelete
and (dbo.GetUnixTime(getdate())-dbo.GetUnixTime(occurTime))>criterias.delayTime
RETURN
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'NTLMPruneDelayedProcessedAlerts')
	delete from GxQscripts where name = 'NTLMPruneDelayedProcessedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTLMPruneDelayedProcessedAlerts')
	delete from GXDBVersions where aliasname = 'NTLMPruneDelayedProcessedAlerts'
GO

insert into GXDBVersions values(2, 'NTLMPruneDelayedProcessedAlerts',  '00010005004600020000', 'NTLMPruneDelayedProcessedAlerts', '00010005004600020000')
GO

