

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTLMDetectedCustomAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTLMDetectedCustomAlerts.sp,v $ $Id: NTLMDetectedCustomAlerts.sp,v 1.1.4.4 2018/09/29 19:02:21 snandhini Exp $";
--
--  +========================================================================+
--  |   Cursor:    NTLMDetectedCustomAlerts()
--  |
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTLMDetectedCustomAlerts <<<'

IF EXISTS (select * from sysobjects where name='NTLMDetectedCustomAlerts')
	drop procedure NTLMDetectedCustomAlerts
IF EXISTS (select * from GxQscripts where name='NTLMDetectedCustomAlerts')
	delete from GxQscripts where name = 'NTLMDetectedCustomAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTLMDetectedCustomAlerts')
	delete from GXDBVersions where aliasname = 'NTLMDetectedCustomAlerts'
GO
print '... Creating Procedure: NTLMDetectedCustomAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTLMDetectedCustomAlerts
  @notificationRuleId integer,
  @pendingAlertPass integer,
  @timeBuff varchar(max)
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @eventId integer
  DECLARE @criteria integer
  DECLARE @alertType integer
  DECLARE @category integer
  DECLARE @status integer
  DECLARE @processStat integer
  DECLARE @occurTime datetime
  DECLARE @processTime datetime
declare @useGroupBy			INTEGER = 0
declare @searchId			INTEGER
select @searchId = IsNull(convert(xml,NTNotificationQueryMapping.xmlInfo).value('(CVGui_QueryAdditionalInfo/externalQueryInfo/@externalQueryId)[1]','int'),0)
from NTNotificationQueryMapping
where NTNotificationId=@notificationRuleId
declare @searchXml xml
declare @thisManyTimes int
select @searchXml = searchInfo from LMUserSearch
where searchId=@searchId
/*
select @thisManyTimes=Tbl.Col.value('../@thisManyTimes','int'),
	@useGroupBy=IsNull(Tbl.Col.value('../@useGroupBy','int'),0)
from @searchXml.nodes('(/LogMonitoring_SearchURLInfo/alertInfoLst/alertEntity[@alertId=sql:variable("@notificationRuleId")])') as Tbl(Col)
*/
SELECT  @thisManyTimes= tbl.t.value('@thisManyTimes','int'),
		@useGroupBy = IsNull(tbl.t.value('@useGroupBy','int'),0)
		FROM APP_LMAlertInfo
		CROSS APPLY Alertprop.nodes('alertInfoLst') AS tbl(t)
		WHERE AlertId = @notificationRuleId
-- First we delete all entries which have incomplete buckets. This we do only when groupBy isnt enabled
if @thisManyTimes>0 and @useGroupBy=0
BEGIN
	delete NTDetectedAlerts from NTDetectedAlerts
	inner join NTDqueryResults
	on NTDetectedAlerts.eventId=NTDqueryResults.eventId
	inner join
	(
		select columIndex1 as bucketId from NTDQueryResults -- Hopefully bucketIds are unique across all alert rules.
		group by columIndex1
		having count(*)<>(@thisManyTimes+1)
	) t on
	t.bucketId = NTDQueryResults.columIndex1
	where NTDetectedAlerts.NTNotificationId=@notificationRuleId
	and occurtime < dateadd(second,-30*60,getDate())
	and (NTdetectedAlerts.processStat & (8) = 0)
END
-- This we do only when groupBy isnt enabled
if @thisManyTimes>0 and @useGroupBy=0
begin
	select NTdetectedAlerts.* from NTdetectedAlerts
	inner join NTDQueryResults on
	NTdetectedAlerts.eventId=NTDQueryResults.eventId
	inner join
	(
		select NTDQ.columIndex1 as bucketId from NTDQueryResults NTDQ
		inner join NTdetectedAlerts NTDA on
		NTDQ.eventId=NTDA.eventId
		where NTDA.NTNotificationId=@notificationRuleId
		and (NTDA.processStat & (8) = 0)
		AND (NTDA.occurTime < @timeBuff) AND (NTDA.processStat) != 0
		group by NTDQ.columIndex1
		having count(*)=(@thisManyTimes+1)
	) t on
	t.bucketId = NTDQueryResults.columIndex1
	where NTdetectedAlerts.NTNotificationId=@notificationRuleId
	and (NTdetectedAlerts.processStat & (8) = 0)
	AND occurTime < @timeBuff AND processStat != 0
	order by NTDQueryResults.columIndex1,ntdetectedAlerts.eventId
end
else
begin
	select NTdetectedAlerts.* from NTdetectedAlerts
	where NTdetectedAlerts.NTNotificationId=@notificationRuleId
	and (NTdetectedAlerts.processStat & (8) = 0)
	AND occurTime < @timeBuff AND processStat != 0
	order by ntdetectedAlerts.eventId
end
GO

IF EXISTS (select * from GxQscripts where name = 'NTLMDetectedCustomAlerts')
	delete from GxQscripts where name = 'NTLMDetectedCustomAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTLMDetectedCustomAlerts')
	delete from GXDBVersions where aliasname = 'NTLMDetectedCustomAlerts'
GO

insert into GXDBVersions values(2, 'NTLMDetectedCustomAlerts',  '00010001000400040000', 'NTLMDetectedCustomAlerts', '00010001000400040000')
GO

