

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTIsCurrentHoursJobPendingCountAnomalous.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- -----------------------------------------------------------------------------------------
--        ProcName: NTIsCurrentHoursJobPendingCountAnomalous
--        Returns whether the job pending count of current hour is anomalous or not
--
--		  input: 1. userID
--				 2. jobTypes
--                  (1 - bkp,2 - restore,4 - admin,8 -laptopbackup)
--
--        output: 0/1
--
--
--------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTIsCurrentHoursJobPendingCountAnomalous')
BEGIN
	print '>>> Drop Stored Procedure: NTIsCurrentHoursJobPendingCountAnomalous <<<'
	drop procedure NTIsCurrentHoursJobPendingCountAnomalous
END
IF EXISTS (select * from GxQscripts where name='NTIsCurrentHoursJobPendingCountAnomalous')
	delete from GxQscripts where name = 'NTIsCurrentHoursJobPendingCountAnomalous'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTIsCurrentHoursJobPendingCountAnomalous')
	delete from GXDBVersions where aliasname = 'NTIsCurrentHoursJobPendingCountAnomalous'
GO
print '... Creating Procedure: NTIsCurrentHoursJobPendingCountAnomalous'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure NTIsCurrentHoursJobPendingCountAnomalous
  @userId INT,
  @jobTypes INT = 15
AS
  DECLARE @isAnomalous INT
  DECLARE @threshold INT
  DECLARE @currentCount INT
  DECLARE @expectedCount INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--consider only those jobs that are pending/waiting for more than 1 hour (60 minutes)
	DECLARE @currentTime DATETIME = getutcdate()
	DECLARE @time INT = DATEDIFF(SECOND, '1970-01-01 00:00:00', @currentTime)
	DECLARE @secondsInhour INT = 60*60
	DECLARE @secondsInDay INT = @secondsInhour * 24
	DECLARE @currentDate INT = (DATEDIFF(SECOND, '1970-01-01 00:00:00', @currentTime) / @secondsInDay) * @secondsInDay
	DECLARE @currentHour INT = DATEPART(hour,@currentTime)
	DECLARE @multiple FLOAT = 3.5
	DECLARE @criticality VARCHAR(50) = ''
	DECLARE @pendingTimeMins INT = 60
	DECLARE @daysToConsider INT = 90
	DECLARE @earliestJobDate INT
	DECLARE @startDateDate DATETIME
	DECLARE @daysToConsiderForExpectedCount INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='DaysToConsiderForExpectedCountCalc' and modified=0),30)
	DECLARE @configurableFromDateTimestamp INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='FromTimeForAnomalyAlert' and modified=0),0)
	DECLARE @minimumDaysForData INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='MinimumDaysForDataInPendingJobAnomaly' and modified=0),30)
	SELECT @earliestJobDate = MIN(servStartDate) FROM JMBkpStats
	IF @configurableFromDateTimestamp > @earliestJobDate
		SET @earliestJobDate = @configurableFromDateTimestamp
	IF (@time - @configurableFromDateTimestamp)/(60*60*24) < @daysToConsider
		SET @daysToConsider = (@time - @configurableFromDateTimestamp)/(60*60*24)
	SET @currentCount = 0
	SET @isAnomalous = 0
	SET @threshold = 0
	SET @expectedCount = 0
	--we dont have enough data
	IF @earliestJobDate IS NULL OR ((@currentDate/@secondsInDay) - (@earliestJobDate/@secondsInDay) < @minimumDaysForData)
	BEGIN
		SELECT @isAnomalous, @threshold, @currentCount, @expectedCount
		RETURN;
	END
	DECLARE @startDate INT = @currentDate - (@secondsInDay * (@daysToConsider-1))
	IF @earliestJobDate > @startDate
		SET @startDate = (@earliestJobDate /@secondsInDay) * @secondsInDay
	SET @startDateDate =  DATEADD(SECOND,@startDate,'19700101')
	SELECT @criticality = value from GxGlobalParam WHERE name='AdminAlertSensitivity' and modified=0
	IF @criticality = 'Low'
	  SET @multiple = 4.5
	ELSE IF @criticality = 'High'
	  SET @multiple = 3
	IF OBJECT_ID('tempdb.dbo.#historyData') IS NOT NULL
		DROP TABLE #historyData
	CREATE TABLE #historyData
	(
		occ INT,
		failedDay INT
	)
	IF OBJECT_ID('tempdb.dbo.#Dates') IS NOT NULL
        DROP TABLE #Dates
    CREATE TABLE #Dates
    (
		day INT,
		hour INT,
		day_date datetime
    )
	;WITH cteNums(n) AS
    (
        SELECT @startDate
        UNION ALL
        SELECT n + @secondsInday
        FROM cteNums WHERE n < @currentDate-@secondsInDay -- get till previous day
    )
	INSERT #Dates
    SELECT n,@currentHour,null FROM cteNums
    OPTION (MAXRECURSION 0)
	;WITH cteNums(n) AS
    (
        SELECT  0
        UNION ALL
        SELECT n + 1
        FROM cteNums WHERE n < @currentHour-1 -- get till previous hour
    )
	INSERT #Dates
    SELECT @currentDate,n,null FROM cteNums
    OPTION (MAXRECURSION 0)
	UPDATE #Dates
	SET day_date = DATEADD(second,day,'19700101')
	INSERT INTO #historyData
		SELECT ISNULL(occur,0),DATEDIFF(DAY, @startDateDate, DT.day_date)+1 FROM
			(
				SELECT SUM(occurances) occur, Summary.evDate evDate, Summary.evHour evHour
				FROM historyDb.dbo.JobStatSummary Summary
				INNER JOIN #Dates DA
				ON DA.day_date = Summary.evDate AND DA.hour = Summary.evHour AND @jobTypes & Summary.jobType > 0
				AND Summary.jobStatus in (2,3) --CVJobState_PENDING,CVJobState_WAITING
				GROUP BY Summary.evDate,Summary.evHour
			)A
			RIGHT JOIN #Dates DT ON DT.day_date = A.evDate AND DT.hour = A.evHour
IF @jobTypes & 2 <> 0
		SELECT @currentCount += COUNT(1) FROM RunningRestores
		WHERE DATEDIFF(MINUTE,DATEADD(SECOND,jobStartTime,'19700101'),@currentTime) > @pendingTimeMins
		AND state IN (2,3)
IF @jobTypes & 4 <> 0
		SELECT @currentCount += COUNT(1) FROM RunningAdminJobs
		WHERE DATEDIFF(MINUTE,DATEADD(SECOND,jobStartTime,'19700101'),@currentTime) > @pendingTimeMins
		AND state IN (2,3)
AND opType NOT IN (17,39,92,35,36,67,68,84,64,90)
IF @jobTypes & 1 <> 0
		SELECT @currentCount += COUNT(1) FROM RunningBackups Bkp
INNER JOIN App_Client Cli ON Bkp.clientId = Cli.id AND Cli.status & (CONVERT(INT,0x1000)|convert(INT,0x10000000)) = 0
		WHERE DATEDIFF(MINUTE,DATEADD(SECOND,jobStartTime,'19700101'),@currentTime) > @pendingTimeMins
		AND state IN (2,3)
IF @jobTypes & 8 <> 0
		SELECT @currentCount += COUNT(1) FROM RunningBackups Bkp
INNER JOIN App_Client Cli ON Bkp.clientId = Cli.id AND Cli.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) > 0
		WHERE DATEDIFF(MINUTE,DATEADD(SECOND,jobStartTime,'19700101'),@currentTime) > @pendingTimeMins
		AND state IN (2,3)
	UPDATE #historyData SET occ = CEILING(occ * (((failedDay * 1.0) - 1) / failedDay)) WHERE failedDay <> @daysToConsider
	SELECT @expectedCount = AVG(occ) FROM #historyData WHERE failedDay <> @daysToConsider AND @daysToConsider - failedDay <= @daysToConsiderForExpectedCount
	EXEC Stat_IsDataAnomalous @currentCount, @multiple, @isAnomalous OUT, @threshold OUT
	SELECT @isAnomalous,@threshold,@currentCount,@expectedCount
	IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
		DROP TABLE #jobTable
	IF OBJECT_ID('tempdb.dbo.#historyData') IS NOT NULL
		DROP TABLE #historyData
GO

IF EXISTS (select * from GxQscripts where name = 'NTIsCurrentHoursJobPendingCountAnomalous')
	delete from GxQscripts where name = 'NTIsCurrentHoursJobPendingCountAnomalous'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTIsCurrentHoursJobPendingCountAnomalous')
	delete from GXDBVersions where aliasname = 'NTIsCurrentHoursJobPendingCountAnomalous'
GO

insert into GXDBVersions values(2, 'NTIsCurrentHoursJobPendingCountAnomalous',  '00000000000000000000', 'NTIsCurrentHoursJobPendingCountAnomalous', '00000000000000000000')
GO

