

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTIsCurrentHoursJobFailureCountAnomalous.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- -----------------------------------------------------------------------------------------
--        ProcName: NTIsCurrentHoursJobFailureCountAnomalous
--        Returns whether the job failed count of current hour is anomalous or not
--
--		  input: 1. userID
--				 2. jobTypes
--                  (1 - bkp,2 - restore,4 - admin,8 -laptopbackup)
--
--        output: 0/1
--
--
--------------------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTIsCurrentHoursJobFailureCountAnomalous')
BEGIN
	print '>>> Drop Stored Procedure: NTIsCurrentHoursJobFailureCountAnomalous <<<'
	drop procedure NTIsCurrentHoursJobFailureCountAnomalous
END
IF EXISTS (select * from GxQscripts where name='NTIsCurrentHoursJobFailureCountAnomalous')
	delete from GxQscripts where name = 'NTIsCurrentHoursJobFailureCountAnomalous'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTIsCurrentHoursJobFailureCountAnomalous')
	delete from GXDBVersions where aliasname = 'NTIsCurrentHoursJobFailureCountAnomalous'
GO
print '... Creating Procedure: NTIsCurrentHoursJobFailureCountAnomalous'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure NTIsCurrentHoursJobFailureCountAnomalous
  @userId INT,
  @jobTypes INT = 15
AS
  DECLARE @isAnomalous INT
  DECLARE @threshold INT
  DECLARE @currentCount INT
  DECLARE @expectedCount INT
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--calculate for the previous hour as the current hour's data would not be complete
	DECLARE @useHistoryTable INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='UseHistoryTableInsteadOfJobStats' and modified=0),1)
	DECLARE @daysToConsider INT = 90
	DECLARE @secondsInhour INT = 60*60
	DECLARE @secondsInDay INT = @secondsInhour * 24
	DECLARE @time INT
	IF @useHistoryTable = 0 -- for holding old logic
		SET @time = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE()) - @secondsInhour
	ELSE
		SET @time = DATEDIFF(SECOND, '1970-01-01 00:00:00', GETUTCDATE())
	DECLARE @currentDate INT = (@time / @secondsInDay) * @secondsInDay
	DECLARE @currentDateDate DATETIME = DATEADD(SECOND, @currentDate, '19700101')
	DECLARE @currentHour INT = ((@time - @currentDate) / @secondsInhour)
	DECLARE @earliestJobDate INT
	DECLARE @multiple FLOAT = 3.5
	DECLARE @criticality VARCHAR(50)=''
	DECLARE @configurableFromDateTimestamp INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='FromTimeForAnomalyAlert' and modified=0),0)
	DECLARE @minimumDaysForData INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='MInimumDaysForDataInFailedJobAnomaly' and modified=0),30)
	DECLARE @daysToConsiderForExpectedCount INT = ISNULL((SELECT TOP 1 value from GxGlobalParam WHERE name='DaysToConsiderForExpectedCountCalc' and modified=0),30)
	SELECT @earliestJobDate = MIN(servStartDate) FROM JMBkpStats
	IF @configurableFromDateTimestamp > @earliestJobDate
		SET @earliestJobDate = @configurableFromDateTimestamp
	IF (@time - @configurableFromDateTimestamp)/(60*60*24) < @daysToConsider
		SET @daysToConsider = (@time - @configurableFromDateTimestamp)/(60*60*24)
	SET @currentCount = 0
	SET @isAnomalous = 0
	SET @threshold = 0
	SET @expectedCount = 0
	IF @earliestJobDate IS NULL OR ((@currentDate/@secondsInDay) - (@earliestJobDate/@secondsInDay) < @minimumDaysForData)
	BEGIN
		SELECT @isAnomalous, @threshold, @currentCount, @expectedCount
		RETURN;
	END
	DECLARE @startDate INT = @currentDate - (@secondsInDay * (@daysToConsider-1))
	IF @earliestJobDate > @startDate
		SET @startDate = (@earliestJobDate /@secondsInDay) * @secondsInDay
	DECLARE @startDateDate DATETIME = DATEADD(SECOND,@startDate,'19700101')
	IF OBJECT_ID('tempdb.dbo.#Dates') IS NOT NULL
        DROP TABLE #Dates
    CREATE TABLE #Dates
    (
		day INT,
		hour INT,
		day_date datetime
    )
	;WITH cteNums(n) AS
    (
        SELECT @startDate
        UNION ALL
        SELECT n + @secondsInday
        FROM cteNums WHERE n < @currentDate-@secondsInDay -- get till currnt time
    )
	INSERT #Dates
    SELECT n,@currentHour,null FROM cteNums
    OPTION (MAXRECURSION 0)
	;WITH cteNums(n) AS
    (
        SELECT  0
        UNION ALL
        SELECT n + 1
        FROM cteNums WHERE n < @currentHour-1 -- get till currnt time
    )
	INSERT #Dates
    SELECT @currentDate,n,null FROM cteNums
    OPTION (MAXRECURSION 0)
	UPDATE #Dates
	SET day_date = DATEADD(second,day,'19700101')
	SELECT @criticality = value from GxGlobalParam WHERE name='AdminAlertSensitivity' and modified=0
	IF @criticality = 'Low'
	  SET @multiple = 4.5
	ELSE IF @criticality = 'High'
	  SET @multiple = 3
	IF OBJECT_ID('tempdb.dbo.#historyData') IS NOT NULL
		DROP TABLE #historyData
	CREATE TABLE #historyData
	(
		occ INT,
		failedDay INT
	)
	IF(@useHistoryTable = 0)
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
			DROP TABLE #jobTable
		CREATE TABLE #jobTable
		(
		    jobId INT,
			subclientId INT,
			commcellId INT,
			evDate INT,
			evHour INT
		)
IF @jobTypes & 1 <> 0 OR @jobTypes & 8 <> 0
		INSERT INTO #jobTable
		 SELECT
			jobID,appId,commcellID,
			(servEndDate / @secondsInDay) * @secondsInDay,
			(servEndDate % @secondsInDay) / @secondsInhour
			FROM JMBkpStats
			WHERE servEndDate > @startDate AND (((servEndDate / @secondsInDay)* @secondsInDay) = @currentDate OR ((servEndDate % @secondsInDay) / @secondsInhour) = @currentHour )
			AND status IN (2,3,4,14,15) -- (_CVJobStatus::Fail,_CVJobStatus::PARTIALSUCCESS,_CVJobStatus::KILLED,_CVJobStatus::JMSUCCESSWITHWARNINGS,_CVJobStatus::SYSTEMFAILED)
IF @jobTypes & 2 <> 0
		INSERT INTO #jobTable
		 SELECT
			jobId,0,commcellId,
			(servEndTime / @secondsInDay) * @secondsInDay,
			(servEndTime % @secondsInDay) / @secondsInhour
			FROM JMRestoreStats
			WHERE servEndTime > @startDate AND (((servEndTime / @secondsInDay)* @secondsInDay) = @currentDate OR ((servEndTime % @secondsInDay) / @secondsInhour) = @currentHour )
			AND status IN (2,3,4,14,15)
IF @jobTypes & 4 <> 0
		INSERT INTO #jobTable
		 SELECT
			jobId,0,2,
			(servEnd / @secondsInDay) * @secondsInDay,
			(servEnd % @secondsInDay) / @secondsInhour
			FROM JMAdminJobStatsTable
			WHERE servEnd > @startDate AND (((servEnd / @secondsInDay)* @secondsInDay) = @currentDate OR ((servEnd % @secondsInDay) / @secondsInhour) = @currentHour )
			AND status IN (2,3,4,14,15)
AND opType NOT IN (17,39,92,35,36,67,68,84,64,90)
		--if only one these two are selected, then filter out based on the type selected
IF (@jobTypes & 1 <> 0 AND @jobTypes & 8 = 0)OR(@jobTypes & 1 = 0 AND @jobTypes & 8 <> 0)
		BEGIN
			 DELETE Bkp
			 FROM #jobTable Bkp
			 INNER JOIN App_Application App ON Bkp.subclientId= App.Id
			 INNER JOIN App_Client Client ON Client.id = App.clientId
WHERE (Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) > 0 AND @jobTypes & 8 = 0) OR
(Client.status & (CONVERT(INT,0x1000)|CONVERT(INT,0x10000000)) = 0 AND @jobTypes & 1 = 0)
		END
		SET @currentCount = (SELECT COUNT(1) FROM #jobTable WHERE evDate = @currentDate AND evHour = @currentHour)
							 --AND dbo.isVisible(@userId,jobId,commcellId,0,0,0,0,0,0)=1)
							 --commenting out visibility check as the history data doesnt those details
		DELETE FROM #jobTable WHERE (evDate = @currentDate AND evHour = @currentHour)
		--delete the jobs that are not visible
		/*DELETE FROM #jobTable
		WHERE
		dbo.isVisible(@userId,jobId,commcellId,0,0,0,0,0,0) = 0*/
		--now find the hourly sum
		INSERT INTO #historyData
		SELECT COUNT(evDate), (DT.day - @startDate)/@secondsInDay + 1
		FROM #jobTable RIGHT OUTER JOIN #Dates DT ON #jobTable.evDate = DT.day AND #jobTable.evHour = DT.hour
		GROUP BY DT.day, DT.hour
		ORDER BY DT.day, DT.hour
	END
	ELSE
	BEGIN
		--if history table doesnt contain the data for current hour, populate it
		IF NOT EXISTS( SELECT 1 FROM historyDB.dbo.jobStatusSummary WHERE evHour = @currentHour AND evDate = @currentDateDate)
			EXEC EvMoveJobStatsToHistoryDB
		INSERT INTO #historyData
		SELECT ISNULL(occur,0), DATEDIFF(DAY,@startDateDate,DT.day_date )+1 FROM
		(
			SELECT SUM(occurances) occur, Summary.evDate evDate, Summary.evHour evHour
			FROM historyDb.dbo.JobStatusSummary Summary
			INNER JOIN #Dates DA ON DA.day_date = Summary.evDate AND DA.hour = Summary.evHour AND @jobTypes & Summary.jobType > 0
			AND Summary.jobStatus in (2,3,4,14,15)
			GROUP BY Summary.evDate,Summary.evHour
		)A
		RIGHT JOIN #Dates DT ON DT.day_date = A.evDate AND DT.hour = A.evHour
		SET @currentCount = (SELECT ISNULL(SUM(occurances),0) FROM historydb.dbo.JobStatusSummary
								WHERE evDate = @currentDateDate AND evHour = @currentHour
										AND jobStatus in (2,3,4,14,15) AND @jobTypes & jobType > 0
							)
	END
	UPDATE #historyData SET occ = CEILING(occ * (((failedDay * 1.0) - 1) / failedDay)) WHERE failedDay <> @daysToConsider
	SELECT @expectedCount = SUM(occ)/SUM((((failedDay * 1.0) - 1) / failedDay)) FROM #historyData WHERE failedDay <> @daysToConsider AND @daysToConsider - failedDay <= @daysToConsiderForExpectedCount
	EXEC Stat_IsDataAnomalous @currentCount, @multiple, @isAnomalous OUT, @threshold OUT
	SELECT @isAnomalous,@threshold,@currentCount,@expectedCount
	IF OBJECT_ID('tempdb.dbo.#jobTable') IS NOT NULL
		DROP TABLE #jobTable
	IF OBJECT_ID('tempdb.dbo.#historyData') IS NOT NULL
		DROP TABLE #historyData
GO

IF EXISTS (select * from GxQscripts where name = 'NTIsCurrentHoursJobFailureCountAnomalous')
	delete from GxQscripts where name = 'NTIsCurrentHoursJobFailureCountAnomalous'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTIsCurrentHoursJobFailureCountAnomalous')
	delete from GXDBVersions where aliasname = 'NTIsCurrentHoursJobFailureCountAnomalous'
GO

insert into GXDBVersions values(2, 'NTIsCurrentHoursJobFailureCountAnomalous',  '00000000000000000000', 'NTIsCurrentHoursJobFailureCountAnomalous', '00000000000000000000')
GO

