

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetWorkFlowURL.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetWorkFlowURL.sp,v $ $Id: NTGetWorkFlowURL.sp,v 1.1.2.3 2018/03/27 09:06:37 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: NTGetWorkFlowURL
--  |
--  | Description:
--  |   This procedure will give URL pointing to given workflow entity with its given input
--  |   The URL will be pointing to given workflow entity with given webconsole
--	|
--  |
--  |   Revisions  Author              Description
--  |   ---------  -----------        -------------------------------
--  |   1.0        Nikhil Chorappan    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetWorkFlowURL <<<'

IF EXISTS (select * from sysobjects where name='NTGetWorkFlowURL')
	drop procedure NTGetWorkFlowURL
IF EXISTS (select * from GxQscripts where name='NTGetWorkFlowURL')
	delete from GxQscripts where name = 'NTGetWorkFlowURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetWorkFlowURL')
	delete from GXDBVersions where aliasname = 'NTGetWorkFlowURL'
GO
print '... Creating Procedure: NTGetWorkFlowURL'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetWorkFlowURL
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @workFlowEntity XML ,
  @input XML ,
  @webConsoleURL NVARCHAR(MAX)
AS
  DECLARE @workFlowURL NVARCHAR(MAX)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @workFlowName     NVARCHAR(MAX)
DECLARE @workflowId       INT
DECLARE @inputsInUrlFormat NVARCHAR(MAX) = ''
SELECT
   @workflowId   = ISNULL(ref.value('@workflowId','INT'),0),
   @workFlowName = ISNULL(ref.value('@workflowName','NVARCHAR(MAX)'),0)
FROM @workFlowEntity.nodes ('CvEntities_GenericEntity') R(ref)
IF object_id('tempdb.dbo.#inputParamValuePair') is not null DROP TABLE #inputParamValuePair
SELECT
    NodeName = C.value('local-name(.)', 'varchar(50)'),
    NodeValue = C.value('(.)[1]', 'varchar(50)')
INTO #inputParamValuePair
FROM @input.nodes('/inputs/*') AS T(C)
SELECT @inputsInUrlFormat =  COALESCE(@inputsInUrlFormat + '&' +  dbo.UrlEncode( NodeName ) + '=' +  dbo.UrlEncode( NodeValue) ,'' )
FROM #inputParamValuePair
-- Kludge all above data and make browse url
SET @workFlowURL = @webConsoleURL + '/forms/?tab=0' + '&workflowName=' + dbo.UrlEncode(@workFlowName) +  '&workflowId=' + dbo.UrlEncode( CAST ( @workflowId AS NVARCHAR(MAX) ))  + @inputsInUrlFormat + '&_submit=true'
IF (  @workFlowURL IS NULL ) SET @workFlowURL = ''
SELECT @workFlowURL
END

IF EXISTS (select * from GxQscripts where name = 'NTGetWorkFlowURL')
	delete from GxQscripts where name = 'NTGetWorkFlowURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetWorkFlowURL')
	delete from GXDBVersions where aliasname = 'NTGetWorkFlowURL'
GO

insert into GXDBVersions values(2, 'NTGetWorkFlowURL',  '00010001000200030000', 'NTGetWorkFlowURL', '00010001000200030000')
GO

