

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetUserListForRule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetUserListForRule.sp,v $ $Id: NTGetUserListForRule.sp,v 1.4.14.13 2019/09/12 20:17:43 pkumar Exp $";
--
--  +========================================================================+
--  | Stored Precedure: NTGetUserListForRule
--  |
--  | Description:
--  |   This procedure will give emailList and login list that need to be notified.,
--  |
--	|
--  |
--  |   Revisions  Author              Description
--  |   ---------  -----------        -------------------------------
--  |   1.0        Nikhil Chorappan    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTGetUserListForRule')
BEGIN
	print '>>> Drop Stored Procedure: NTGetUserListForRule <<<'
	drop procedure NTGetUserListForRule
END
IF EXISTS (select * from GxQscripts where name='NTGetUserListForRule')
	delete from GxQscripts where name = 'NTGetUserListForRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetUserListForRule')
	delete from GXDBVersions where aliasname = 'NTGetUserListForRule'
GO
print '... Creating Procedure: NTGetUserListForRule'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetUserListForRule
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ruleId INT,
  @escalationLevel INT,
  @clientName nvarchar(1024),
  @userList xml,
  @messType INT
AS
  DECLARE @emailList nvarchar(MAX) 
  DECLARE @noemailList nvarchar(MAX)
  DECLARE @loginList nvarchar(MAX)
  DECLARE @userIdList nvarchar(MAX)
  DECLARE @ccEmailList nvarchar(MAX) 
  DECLARE @bccEmailList nvarchar(MAX) 
  DECLARE @phoneNumList nvarchar(MAX)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-- DECLARE @messTypeBuff int
-- SET  @messTypeBuff = @messType
-- IF @messType = NT_ACTIONEMAIL_ALERTNOTIF  --  NT_ACTIONEMAIL_ALERTNOTIF should get only users for the email notification type.
-- BEGIN
--   SET  @messType = NT_EMAIL_ALERTNOTIF
-- END
DECLARE @laptopclientId INTEGER
SET @lapTopClientId   = ISNULL((Select id from APP_CLIENT Where name=@clientName), 0)
IF @messType not in (16, 4, 8)
    BEGIN
	    declare @eSeperator   nvarchar(10)
		declare @lSeperator   nvarchar(10)
		declare @neSeperator  nvarchar(10)
		declare @email   nvarchar(1024)
		declare @login   nvarchar(1024)
		declare @userIdVar  int
		declare @UserName   nvarchar(1024)
		DECLARE @uidSep    nvarchar(10)
	    DECLARE @sep       nvarchar(10)
		declare @recipientType   int
		declare @phoneNum varchar(16)
		SET @sep = '; '
if(@messType = 262144 )
		BEGIN
                    SET @sep = ';'
                END
		SET     @eSeperator  = ''
		SET     @lSeperator  = ''
		SET     @neSeperator = ''
		SET     @emailList   = ''
		SET     @noEmailList = ''
		SET     @loginList   = ''
		SET     @userIdList  = ''
		SET     @uidSep      = ''
		SET		@ccEmailList = ''
		SET		@bccEmailList = ''
		SET		@phoneNumList = ''
		declare @reciepientDetails table
		(
			userId      int,
			Login       nvarchar(max),
			UserName    nvarchar(max),
			Email       nvarchar(max),
			recipientType int,
			phoneNum	varchar(16)
		)
		Insert into @reciepientDetails(userId, Login, UserName, Email, recipientType)
		select *
		from dbo.NTGetUsersForAlertRule(@ruleId ,@escalationLevel ,@messType, @lapTopClientId, @userList )
		-- For subscription based alerts which restrict recipients based on user security, remove recipients who shouldnt receive this alert.
IF EXISTS (select 1 from NTnotificationRule where [ID] = @ruleId and (status & 128)>0 )
		begin
			-- if new security is enabled or alert is associated to plan.
			if exists(select 1 from Gxglobalparam where name='bEnableSecurityForSubscriptionAlerts' and value='true' and modified=0)
			begin
				-- Call security api to see which user has CAT_ALERT_RECIPIENTS_ADD_REMOVE cap on alert.
				 DECLARE @i_entityList XML
				 SET @i_entityList = (SELECT
64 as '@entityType1',
				 @ruleId  as '@entityId1'
				 for xml path('entity'),root('entityList') )
				 IF object_id('tempdb.dbo.#tgroupObjects') is not null
					DROP TABLE #tgroupObjects
CREATE TABLE #tgroupObjects ([userORGroupId] integer, [isUSer] integer, [roleId] integer, [permissionId] integer, [entitytype1]	 integer, [entityId1] integer, [entityType2] integer DEFAULT 0, [entityId2] integer DEFAULT 0, [entityType3] integer DEFAULT 0, [entityId3] integer DEFAULT 0, [entityType4] integer DEFAULT 0, [entityId4] integer DEFAULT 0, [entityType5] integer DEFAULT 0,  [entityId5] integer DEFAULT 0)
exec sec_getUMEntityandPermissionOnEntity '#tgroupObjects' ,64, @i_entityList,0,1,154,0
				 -- For users not associated to plan we check security recipient list.
				 delete from @reciepientDetails
				 where userId>0 and userId not in
				 (
					select tgroupObjects.userORGroupId from #tgroupObjects tgroupObjects
					where tgroupObjects.isUSer=1
				 )
				 and dbo.appgetPlanforUser(userId)=0
			end
if exists(select 1 from App_planProp with (READUNCOMMITTED) where attrname='Alert' + ' ' + cast(@ruleId as nvarchar(32)) and attrval='1') OR
exists(select 1 from App_planProp with (READUNCOMMITTED) where attrname='Alert' and @ruleId in (select cast(_ID as int) FROM dbo.SplitIDString(attrVal)) )
			begin
				-- if user recipient property is not set for alert, then refresh.
				 if not exists(select 1 from NTNotificationProp with (READUNCOMMITTED) where componentNameId = @ruleId
and attrName = 'Recipient UserId' and modified = 0)
					and not exists(select 1 from NTNotificationProp with (READUNCOMMITTED) where componentNameId = @ruleId
and attrName = 'Recipient UserGroupId' and modified = 0)
				begin
					declare @userRGroupListFromPlan table
					(
						userRGroupId int,
						isUser int
					)
					Insert into @userRGroupListFromPlan
					select * from dbo.NTGetPlanRecipientsForRule(@ruleId)
					Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @ruleId,'Recipient UserId',7,userRGroupId, dbo.getunixtime(getutcdate()),0
					from @userRGroupListFromPlan
					where isUser=1
					Insert into NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
select @ruleId,'Recipient UserGroupId',7,userRGroupId, dbo.getunixtime(getutcdate()),0
					from @userRGroupListFromPlan
					where isUser=0
				end
				-- For users associated to some plan we check plan recipient list.
				 delete from @reciepientDetails
				 where userId>0 and userId not in
				 (
					select cast(attrval as int) from NTNotificationProp
					where componentNameId = @ruleId
and attrName = 'Recipient UserId'
					and modified = 0
					union
					select UMUsergroup.userid from NTNotificationProp
					inner join UMuserGroup
					on componentNameId = @ruleId
and attrName = 'Recipient UserGroupId'
					and modified = 0
					and isnumeric(attrval)=1
					and cast(attrval as int)=UMUsergroup.groupId
				 )
				 and dbo.appgetPlanforUser(userId)>0
			end
		end
		update R
		SET phoneNum = contactPhone
		FROM @reciepientDetails R
			INNER JOIN ProfileCustomerContact P
				ON R.userId = P.contactUserId
        DECLARE conCat_Cursor CURSOR FOR
        SELECT DISTINCT userId, login, userName, email ,recipientType, phoneNum
        FROM @reciepientDetails
WHERE  ( @messType = 262144 AND userId IS NOT NULL  )  OR  @messType <> 262144
        OPEN conCat_Cursor
        FETCH NEXT FROM conCat_Cursor INTO @userIdVar, @login, @UserName, @email,@recipientType, @phoneNum
        WHILE @@FETCH_STATUS = 0
        BEGIN
            if (@email <> '')
            BEGIN
				if @recipientType=1
				begin
					set @ccEmailList     = @ccEmailList     + @sep + @email
				end
				else if @recipientType=2
				begin
					set @bccEmailList     = @bccEmailList     + @sep + @email
				end
				else
				begin
					set @emailList     = @emailList     + @eseperator + @email
					set @eSeperator = @sep
				end
            END
            else
            BEGIN
                set @noEmailList     = @noEmailList     + @neseperator + @login
                set @neSeperator = @sep
            END
            if (@login <> '')
            BEGIN
                set @loginList     = @loginList     + @lseperator + @login
                set @lSeperator = @sep
            END
if(@messType = 262144 )
	    BEGIN
                set @userIdList     = @userIdList     + @uidSep +  CAST( @userIdVar AS NVARCHAR(MAX))
                set @uidSep = @sep
            END
            if (@phoneNum <> '')
            BEGIN
                set @phoneNumList     = @phoneNumList     + @sep + @phoneNum
            END
			FETCH NEXT FROM conCat_Cursor INTO @userIdVar, @login, @UserName, @email ,@recipientType, @phoneNum
        END
        CLOSE       conCat_Cursor
        DEALLOCATE  conCat_Cursor
    END
	if len(@ccEmailList)>0
	begin
		set @ccEmailList=substring(@ccEmailList,2,len(@ccEmailList))
	end
	if len(@bccEmailList)>0
	begin
		set @bccEmailList=substring(@bccEmailList,2,len(@bccEmailList))
	end
	if len(@phoneNumList)>0
	begin
		set @phoneNumList=substring(@phoneNumList,2,len(@phoneNumList))
	end
SELECT @emailList , @noemailList , @loginList ,  @userIdList, @ccEmailList, @bccEmailList, @phoneNumList
END

IF EXISTS (select * from GxQscripts where name = 'NTGetUserListForRule')
	delete from GxQscripts where name = 'NTGetUserListForRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetUserListForRule')
	delete from GXDBVersions where aliasname = 'NTGetUserListForRule'
GO

insert into GXDBVersions values(2, 'NTGetUserListForRule',  '00010004001400130000', 'NTGetUserListForRule', '00010004001400130000')
GO

