

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetTriggerTimeForDetectedAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  NTGetTriggerTimeForDetectedAlerts()
--  |
--  | Description:  Generate next repeated trigger time for each notification rule so that pending events can be pushed to Spool Queue only at that time.
--  |			 :  To reduce load on the spool queue
--  |
--  |      Input:   ???
--  |
--  |      Output:  Retrieves next repeated trigger time for each alert and escalation level.
--  |
--  |      Notes:
--  |
--  |   Revisions  Author		Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        mnatarajan 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTGetTriggerTimeForDetectedAlerts')
BEGIN
	print '>>> Drop Stored Procedure: NTGetTriggerTimeForDetectedAlerts <<<'
	drop procedure NTGetTriggerTimeForDetectedAlerts
END
IF EXISTS (select * from GxQscripts where name='NTGetTriggerTimeForDetectedAlerts')
	delete from GxQscripts where name = 'NTGetTriggerTimeForDetectedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetTriggerTimeForDetectedAlerts')
	delete from GXDBVersions where aliasname = 'NTGetTriggerTimeForDetectedAlerts'
GO
print '... Creating Procedure: NTGetTriggerTimeForDetectedAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetTriggerTimeForDetectedAlerts
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
  DECLARE @xmlOutput XML      
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @ntRuleNextTriggerTime table
(
	ntRuleId int,
	alertType int,
	escLevel int,
	nextTriggerTime datetime,
	persistTimeSeconds int,
	isModified int
)
declare @csTimeZone nvarchar(max)
declare @lastNTNextRunTimeComputed int
set @csTimeZone = dbo.GetClientTimeZone(2)
SET @lastNTNextRunTimeComputed = ISNULL((Select value FROM GXGlobalParam with (nolock) WHERE Name = 'NTNextRunTimeComputed' and modified=0), N'0')
declare @lastLocalNTNextRunTimeComputed datetime
set @lastLocalNTNextRunTimeComputed=dbo.UTCToLocalDateTimeConversionManaged( DATEADD(second, @lastNTNextRunTimeComputed, '01/01/1970') , @csTimeZone)
Insert into @ntRuleNextTriggerTime
select distinct ruleId,alertTypeId,esclationLevel,null,persistTimeSeconds,
	case when NTNotificationRule.lastModified>=@lastNTNextRunTimeComputed then 1
	else 0
	end
from NTSelCriteria
inner join NTNotificationRule on
NTSelCriteria.ruleId=NTNotificationRule.id
and NTNotificationRule.revision>0
and (NTNotificationRule.status&3)=0
update TempTable
set nextTriggerTime = dbo.GetDateTime(convert(int,NTnotificationProp.attrval))
from NTnotificationProp, @ntRuleNextTriggerTime TempTable
where TempTable.ntRuleId = NTnotificationProp.componentNameId
and TempTable.escLevel = 1
and NTnotificationProp.modified=0
and NTnotificationProp.attrname='NTNextRepeatedRunTimeForRule'
update TempTable
set nextTriggerTime = dbo.GetDateTime(convert(int,NTnotificationProp.attrval))
from NTnotificationProp, @ntRuleNextTriggerTime TempTable
where TempTable.ntRuleId = NTnotificationProp.componentNameId
and TempTable.escLevel = 2
and NTnotificationProp.modified=0
and NTnotificationProp.attrname='NTNextRepeatedRunTimeForRuleEsc'
-- In case persistTimeSeconds is 0, then only fresh occurences will match (very first time event occurs or very first time it gets escalated)
-- So we set the nextTrigger time ahead by one day always relatively. Since it will never match.
Update @ntRuleNextTriggerTime
set nextTriggerTime=DATEADD(HOUR,24,GETUTCDATE())
where persistTimeSeconds=0
IF OBJECT_ID('tempdb.dbo.#DetectedAlertsToBeUpdated')IS NOT NULL
	DROP TABLE #DetectedAlertsToBeUpdated
CREATE TABLE #DetectedAlertsToBeUpdated
(
	eventId INT,
	nextTriggerTime DATETIME
)
CREATE CLUSTERED INDEX DetectedAlerts_eventId ON #DetectedAlertsToBeUpdated(eventId)
-- alertTypeCriteriaNextTriggerTime.nextTriggerTime to date in CS timezone.
-- It should be more than last runTime computed else it would have been covered in previous iteration.
INSERT INTO #DetectedAlertsToBeUpdated
SELECT NtdetectedAlerts.eventid, dbo.UTCToLocalDateTimeConversionManaged( DATEADD(second, dbo.getunixtime(ntRuleNextTriggerTime.nextTriggerTime), '01/01/1970') , @csTimeZone)
from NtdetectedAlerts
inner join
(
	select ntRuleNextTriggerTime.alertType,NTSelCriteria.availCriteriaid,min(ntRuleNextTriggerTime.nextTriggerTime) as nextTriggerTime
	from @ntRuleNextTriggerTime ntRuleNextTriggerTime
	inner join NTSelCriteria on
	ntRuleNextTriggerTime.ntRuleId=NTSelCriteria.ruleId
	group by ntRuleNextTriggerTime.alertType,NTSelCriteria.availCriteriaid
) ntRuleNextTriggerTime
on ntRuleNextTriggerTime.alertType=NTDetectedAlerts.alertType
and NtdetectedAlerts.criteria=ntRuleNextTriggerTime.availCriteriaid
and (NTDetectedAlerts.processStat&2)>0
and NTDetectedAlerts.NTNotificationId=0
-- Update nextTriggerTime only if needed
AND NtdetectedAlerts.nextTriggerTime > dbo.UTCToLocalDateTimeConversionManaged( DATEADD(second, dbo.getunixtime(ntRuleNextTriggerTime.nextTriggerTime), '01/01/1970') , @csTimeZone)
-- For detected alerts specific to notification rule we update next trigger time to alert rules next trigger time
INSERT INTO #DetectedAlertsToBeUpdated
SELECT NtdetectedAlerts.eventid, dbo.UTCToLocalDateTimeConversionManaged( DATEADD(second, dbo.getunixtime(ntRuleNextTriggerTime.nextTriggerTime), '01/01/1970') , @csTimeZone)
FROM NtdetectedAlerts
INNER JOIN
(
	select ntRuleNextTriggerTime.ntRuleId,min(ntRuleNextTriggerTime.nextTriggerTime) as nextTriggerTime
	from @ntRuleNextTriggerTime ntRuleNextTriggerTime
	inner join NTSelCriteria on
	ntRuleNextTriggerTime.ntRuleId=NTSelCriteria.ruleId
	group by ntRuleNextTriggerTime.ntRuleId
) ntRuleNextTriggerTime on
ntRuleNextTriggerTime.ntRuleId = NtdetectedAlerts.ntnotificationId
AND NtdetectedAlerts.ntnotificationId<>0
AND (NTDetectedAlerts.processStat&2)>0
AND NtdetectedAlerts.nextTriggerTime > dbo.UTCToLocalDateTimeConversionManaged( DATEADD(second, dbo.getunixtime(ntRuleNextTriggerTime.nextTriggerTime), '01/01/1970') , @csTimeZone)
-- Compute time for detectedAlert to move to pending state or pendingEsc state. (And update if needed)
INSERT INTO #DetectedAlertsToBeUpdated
SELECT NtdetectedAlerts.eventid, DATEADD(second,EVENTS.Value,occurtime)
FROM NTDetectedAlerts (NOLOCK) INNER JOIN
(
	SELECT NtdetectedAlerts.eventId, MIN(NTSelCriteria.delayTimeSeconds) Value
	from NtdetectedAlerts inner join NTNotificationRule on
	NTNotificationRule.alertTypeId=NTdetectedAlerts.alerTType
	and (NTDetectedAlerts.NTNotificationId=0 OR NTNotificationRule.id=NTDetectedAlerts.NTNotificationId)
	inner join NTSelCriteria on
	NTSelCriteria.ruleId=NTnotificationRule.id
	and NTSelCriteria.delayTimeSeconds>0
	and NTSelCriteria.esclationLevel=1
	left join NTDParams on NtdetectedAlerts.eventId=NTDParams.eventId
	and NTDParams.type=143 --enumMatchedRuleIds
	and NTDParams.value=NTNotificationRule.id
	where NTDParams.value is NULL
	and NTNotificationRule.revision>0
	and (NTNotificationRule.status&3)=0
	and (NTDetectedAlerts.processStat&2)>0
	GROUP BY NtdetectedAlerts.eventId
) EVENTS
ON Events.eventId = NTDetectedAlerts.EventId
AND NTDetectedAlerts.nextTriggerTime >  DATEADD(second,Events.value,occurtime)
INSERT INTO #DetectedAlertsToBeUpdated
SELECT NtdetectedAlerts.eventid, DATEADD(second,EVENTS.Value,occurtime)
FROM NTDetectedAlerts (NOLOCK) INNER JOIN
(
	SELECT NtdetectedAlerts.eventId, MIN(NTSelCriteria.delayTimeSeconds) Value
	from NtdetectedAlerts inner join NTNotificationRule on
	NTNotificationRule.alertTypeId=NTdetectedAlerts.alerTType
	and (NTDetectedAlerts.NTNotificationId=0 OR NTNotificationRule.id=NTDetectedAlerts.NTNotificationId)
	inner join NTSelCriteria on
	NTSelCriteria.ruleId=NTnotificationRule.id
	and NTSelCriteria.delayTimeSeconds>0
	and NTSelCriteria.esclationLevel=2
	left join NTDParams on NtdetectedAlerts.eventId=NTDParams.eventId
	and NTDParams.type=144 --enumMatchedRuleIdsEscalated
	and NTDParams.value=NTNotificationRule.id
	where NTDParams.value is NULL
	and NTNotificationRule.revision>0
	and (NTNotificationRule.status&3)=0
	and (NTDetectedAlerts.processStat&2)>0
	GROUP BY NtdetectedAlerts.eventId
) EVENTS
ON Events.eventId = NTDetectedAlerts.EventId
AND NTDetectedAlerts.nextTriggerTime >  DATEADD(second,Events.value,occurtime)
IF object_id('tempdb.dbo.#jobBasedAlerts') is not null
	DROP TABLE #jobBasedAlerts
CREATE TABLE #jobBasedAlerts(eventId int,jobId int)
CREATE CLUSTERED INDEX jobBasedAlerts_eventId_Index1 ON #jobBasedAlerts ([eventId])
CREATE NONCLUSTERED INDEX jobBasedAlerts_jobId_Index1 ON #jobBasedAlerts ([jobId])
Insert into #jobBasedAlerts
select eventid,jobId_l from NTDdpDr (NOLOCK)
DECLARE @interval INT = -5 -- By default we return Job Exceeded run time alert for all job states. Negetive value indicates no need to prune based on running jobs.
SELECT @interval = value FROM GXGlobalParam WHERE name LIKE 'NTDPJobRefreshInterval' and modified=0
if @interval>0
begin
	-- We need to send job exceeded run time alert for "running" jobs only.
	DELETE jobBasedAlerts
	FROM #jobBasedAlerts jobBasedAlerts
	INNER JOIN JMJobInfo with (nolock)
	ON JMJobInfo.jobId=jobBasedAlerts.jobId
	WHERE JMJobInfo.state<>1
end
-- For job exceeded run time alerts, for jobs which are in running state (based on param) we check if their running time exceeded specified time
-- And update nextTriggerTime accordingly.
INSERT INTO #DetectedAlertsToBeUpdated
SELECT NtdetectedAlerts.eventid, DATEADD(Hour,Events.value,occurtime)
FROM NTDetectedAlerts (NOLOCK) INNER JOIN
(
	SELECT NTDetectedAlerts.EventId, MIN(NTSelCriteriaParams.value)  Value
	FROM NTDetectedAlerts INNER JOIN NTSelCriteria ON
	NTDetectedAlerts.criteria=67
	and NTSelCriteria.availCriteriaId=67	--NT_JOB_EXCEEDED_RUNNINGTIME
	INNER JOIN NTnotificationrule ON
	NTnotificationrule.id = NTSelCriteria.ruleId
	and (NTDetectedAlerts.NTNotificationId=0 OR NTNotificationRule.id=NTDetectedAlerts.NTNotificationId)
	INNER JOIN #jobBasedAlerts jobBasedAlerts on
	jobBasedAlerts.eventId=NtdetectedAlerts.eventId
	INNER JOIN NTSelCriteriaParams on
	NTSelCriteriaParams.selCriteriaid=NTSelCriteria.id
	LEFT JOIN NTDParams on NtdetectedAlerts.eventId=NTDParams.eventId
	AND NTDParams.type=143 --enumMatchedRuleIds
	AND NTDParams.value=NTSelCriteria.ruleId
	WHERE NTDParams.value is NULL
	AND NTNotificationRule.revision>0
	AND (NTNotificationRule.status&3)=0
	AND (NTDetectedAlerts.processStat&2)>0
	GROUP BY NTDetectedAlerts.EventId
) Events
ON Events.eventId = NTDetectedAlerts.EventId
WHERE NTDetectedAlerts.nextTriggerTime >  DATEADD(Hour,Events.value,occurtime)
-- For job delayed alerts, we check if their running time exceeded specified time
-- And update nextTriggerTime accordingly.
INSERT INTO #DetectedAlertsToBeUpdated
SELECT NtdetectedAlerts.eventid, DATEADD(Hour,Events.value,occurtime)
FROM NTDetectedAlerts (NOLOCK) INNER JOIN
(
	SELECT NTDetectedAlerts.eventid, MIN(NTSelCriteriaParams.value)  Value
	from NTDetectedAlerts inner join NTSelCriteria on
	NtdetectedAlerts.criteria=5
	and NTSelCriteria.availCriteriaId=5	--NT_DELAYED
	inner join NTnotificationrule on
	NTnotificationrule.id = NTSelCriteria.ruleId
	and (NTDetectedAlerts.NTNotificationId=0 OR NTNotificationRule.id=NTDetectedAlerts.NTNotificationId)
	inner join NTSelCriteriaParams on
	NTSelCriteriaParams.selCriteriaid=NTSelCriteria.id
	left join NTDParams on NtdetectedAlerts.eventId=NTDParams.eventId
	and NTDParams.type=143 --enumMatchedRuleIds
	and NTDParams.value=NTSelCriteria.ruleId
	where NTDParams.value is NULL
	and NTNotificationRule.revision>0
	and (NTNotificationRule.status&3)=0
	and (NTDetectedAlerts.processStat&2)>0
	GROUP BY NTDetectedAlerts.EventId
) Events
ON Events.eventId = NTDetectedAlerts.EventId
WHERE NTDetectedAlerts.nextTriggerTime >  DATEADD(Hour,Events.value,occurtime)
-- No need to wait for X minutes before alerting client offline alert. Client checks every X minutes and alerts once its offline. Alert layer needs to notify immediately.
UPDATE NTD SET nextTriggerTime = DA.nextTriggerTime
FROM NTDetectedAlerts NTD INNER JOIN
(
	SELECT eventId,MIN(nextTriggerTime) nextTriggerTime
	FROM #DetectedAlertsToBeUpdated
	GROUP BY eventId
 )DA ON DA.eventId = NTD.eventId
SELECT
	(
		SELECT distinct escLevel '@escLevel' ,dbo.GetUnixTime(nextTriggerTime) '@nextTriggerTime' ,ntRuleId 'alert/@alertId'
		FROM @ntRuleNextTriggerTime
		FOR XML PATH('notificationRules'),TYPE
	),
	(
		SELECT eventId '@eventId' , MIN(nextTriggerTime) '@nextTriggerTime'
		FROM #DetectedAlertsToBeUpdated
		GROUP BY eventId
		FOR XML PATH('detectedAlerts'),TYPE
	)
	FOR XML PATH('App_RulesDetectedAlertsInfo')
IF object_id('tempdb.dbo.#jobBasedAlerts') is not null
	DROP TABLE #jobBasedAlerts
IF object_id('tempdb.dbo.#output_DetectedAlertsTbl') is not null
	DROP TABLE #output_DetectedAlertsTbl
IF OBJECT_ID('tempdb.dbo.#DetectedAlertsToBeUpdated')IS NOT NULL
	DROP TABLE #DetectedAlertsToBeUpdated
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetTriggerTimeForDetectedAlerts')
	delete from GxQscripts where name = 'NTGetTriggerTimeForDetectedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetTriggerTimeForDetectedAlerts')
	delete from GXDBVersions where aliasname = 'NTGetTriggerTimeForDetectedAlerts'
GO

insert into GXDBVersions values(2, 'NTGetTriggerTimeForDetectedAlerts',  '00000000000000000000', 'NTGetTriggerTimeForDetectedAlerts', '00000000000000000000')
GO

