

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetSupportedMessageTypeForNTRule.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  NTGetSupportedMessageTypeForNTRule()
--  |
--  | Description:  Check whether the notification rule supports only Text format or html format
--  |
--  |      Input:   ???
--  |
--  |      Output:  Retrieves an int ..0 indicates both being supported. 1 being for text and 2 for HTML.
--  |
--  |      Notes:
--  |
--  |   Revisions  Author		Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        mnatarajan 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetSupportedMessageTypeForNTRule <<<'

IF EXISTS (select * from sysobjects where name='NTGetSupportedMessageTypeForNTRule')
	drop procedure NTGetSupportedMessageTypeForNTRule
IF EXISTS (select * from GxQscripts where name='NTGetSupportedMessageTypeForNTRule')
	delete from GxQscripts where name = 'NTGetSupportedMessageTypeForNTRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetSupportedMessageTypeForNTRule')
	delete from GXDBVersions where aliasname = 'NTGetSupportedMessageTypeForNTRule'
GO
print '... Creating Procedure: NTGetSupportedMessageTypeForNTRule'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetSupportedMessageTypeForNTRule
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ntRuleId integer
AS
  DECLARE @messageFormatTypeSupported integer
set transaction isolation level read uncommitted
declare @supportedMessageFormatTypes int
declare @isHtmlSupported bit
declare @isTextSupported bit
declare @isLMAlert	int
set @isHtmlSupported = 0
set @isTextSupported = 0
set @isLMAlert = 0
select @isLMAlert = 1 from NTNotificationQueryMapping
where NTnotificationId=@ntRuleId and
convert(xml,xmlinfo).value('(CVGui_QueryAdditionalInfo/externalQueryInfo/@queryType)[1]','nvarchar(max)')='3'
select @isHtmlSupported = 1
from NTMessageFormat inner join NTNotificationRule
on NTMessageFormat.NTnotificationId=NTNotificationRule.id
and NTNotificationRule.id=@ntRuleId
where NTMessageFormat.messageFormatType=1
and (NTMessageFormat.messageType & NTNotificationRule.notifType)>0
if @isLMAlert=0
begin
	select @isTextSupported = 1
	from NTMessageFormat inner join NTNotificationRule
	on NTMessageFormat.NTnotificationId=NTNotificationRule.id
	and NTNotificationRule.id=@ntRuleId
	where NTMessageFormat.messageFormatType=0
	and (NTMessageFormat.messageType & NTNotificationRule.notifType)>0
end
else
begin
	select @isTextSupported = 1
	from NTMessageFormat inner join NTNotificationRule
	on NTMessageFormat.NTnotificationId=NTNotificationRule.id
	and NTNotificationRule.id=@ntRuleId
	where NTMessageFormat.messageFormatType=0
	and (NTMessageFormat.messageType & NTNotificationRule.notifType)>0
	and NTMessageFormat.messageType!=131072	--NT_ALERTNOTIF_FOR_CI
end
if @isHtmlSupported=1 and @isTextSupported=1
begin
	set @supportedMessageFormatTypes = 0
end
else if @isHtmlSupported=1
begin
	set @supportedMessageFormatTypes = 2
end
else if @isTextSupported=1
begin
	set @supportedMessageFormatTypes = 1
end
select @supportedMessageFormatTypes
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetSupportedMessageTypeForNTRule')
	delete from GxQscripts where name = 'NTGetSupportedMessageTypeForNTRule'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetSupportedMessageTypeForNTRule')
	delete from GXDBVersions where aliasname = 'NTGetSupportedMessageTypeForNTRule'
GO

insert into GXDBVersions values(2, 'NTGetSupportedMessageTypeForNTRule',  '00000000000000000000', 'NTGetSupportedMessageTypeForNTRule', '00000000000000000000')
GO

