

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetShortenedURL.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetShortenedURL.sp,v $ $Id: NTGetShortenedURL.sp,v 1.1.2.2 2018/03/27 08:57:16 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: NTGetShortenedURL
--  |
--  | Description:
--  |   This procedure will give shortened URL which will be convenient to use in email.
--  |   webConsoleURL is an optional parameter , if you give empty string you will get the relative URL to your webconsole.
--	|
--  |
--  |   Revisions  Author              Description
--  |   ---------  -----------        -------------------------------
--  |   1.0        Nikhil Chorappan    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetShortenedURL <<<'

IF EXISTS (select * from sysobjects where name='NTGetShortenedURL')
	drop procedure NTGetShortenedURL
IF EXISTS (select * from GxQscripts where name='NTGetShortenedURL')
	delete from GxQscripts where name = 'NTGetShortenedURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetShortenedURL')
	delete from GXDBVersions where aliasname = 'NTGetShortenedURL'
GO
print '... Creating Procedure: NTGetShortenedURL'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetShortenedURL
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @longURl nvarchar(max),
  @webConsoleURL nvarchar(max) 
AS
  DECLARE @shortenedUrl nvarchar(MAX) 
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @shortUrl            NVARCHAR(MAX)= ''
DECLARE @errorCode          int  = 0
DECLARE @goToLink           NVARCHAR(MAX)  = ISNULL((SELECT value FROM GXGlobalParam WHERE name='Short Url Template' AND modified=0), 'gtl.do?gid=')
EXEC AppShortUrlConvertion 1, @longURl OUTPUT, @shortUrl OUTPUT, @errorCode OUTPUT
SET @shortenedUrl  = @webConsoleURL + @goToLink + @shortUrl
SELECT @shortenedUrl
END

IF EXISTS (select * from GxQscripts where name = 'NTGetShortenedURL')
	delete from GxQscripts where name = 'NTGetShortenedURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetShortenedURL')
	delete from GXDBVersions where aliasname = 'NTGetShortenedURL'
GO

insert into GXDBVersions values(2, 'NTGetShortenedURL',  '00010001000200020000', 'NTGetShortenedURL', '00010001000200020000')
GO

