

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetRunningJobStats.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  NTGetRunningJobStats()
--  |
--  | Description:  Retrieves the stats for running backup jobs from DB
--  |
--  |      Input:   ???
--  |
--  |      Output:  Returns running backup job stats for users who have created alerts with jobs in pending state criteria selected.
--  |
--  |      Notes:
--  |
--  |   Revisions  Author		Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        mnatarajan 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetRunningJobStats <<<'

IF EXISTS (select * from sysobjects where name='NTGetRunningJobStats')
	drop procedure NTGetRunningJobStats
IF EXISTS (select * from GxQscripts where name='NTGetRunningJobStats')
	delete from GxQscripts where name = 'NTGetRunningJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetRunningJobStats')
	delete from GXDBVersions where aliasname = 'NTGetRunningJobStats'
GO
print '... Creating Procedure: NTGetRunningJobStats'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure NTGetRunningJobStats
  @alertId integer = 0
AS
  DECLARE @ntRuleId integer
  DECLARE @totalJobs integer
  DECLARE @pendingJobs integer
  DECLARE @isConditionCleared integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF object_id('tempdb.dbo.#expandedSelectedEntityIdsJobStats') is not null
		DROP TABLE #expandedSelectedEntityIdsJobStats
create table #expandedSelectedEntityIdsJobStats
(
	clientId int,
	appTypeId int,
	instanceId int,
	backupsetId int,
	subclientId int,
	subclientStatus int,
	ntRuleId int,
	primary key(clientId, subclientId, ntRuleId)
)
Insert into #expandedSelectedEntityIdsJobStats(clientId,appTypeId,instanceId,backupsetId,subclientId,subclientStatus,ntRuleId)
exec br_ntGetExpandedEntityListForAlerts @alertId,73,0 --  _NT_JOBS_PENDING_STATE
IF object_id('tempdb.dbo.#ntRuleIdVisibleJobs') is not null
		DROP TABLE #ntRuleIdVisibleJobs
create table #ntRuleIdVisibleJobs
(
	ntRuleId int,
	visiblejobId int,
	visibleJobstatus int,
	primary key(ntRuleId, visiblejobId)
)
Insert into #ntRuleIdVisibleJobs
select ntRules.ntRuleId,RunningBackups.jobId,RunningBackups.state
from #expandedSelectedEntityIdsJobStats ntRules,
RunningBackups ,
NTNotificationRule
where ntRules.ntRuleId = NTNotificationRule.id and (NTNotificationRule.id = @alertId or @alertId=0)
and (RunningBackups.userId = NTNotificationRule.notifOwner
Or dbo.isBkpJobVisible(NTNotificationRule.notifOwner,RunningBackups.commCellId,RunningBackups.clientId,
	RunningBackups.appTypeId,RunningBackups.instance,RunningBackups.backupSet,RunningBackups.applicationId)=1 )
and ntRules.subclientId = RunningBackups.applicationId
IF object_id('tempdb.dbo.#ntRuleIdJobStats') is not null
		DROP TABLE #ntRuleIdJobStats
create table #ntRuleIdJobStats
(
	ntRuleId int,
	totalJobs int,
	noOfPendingJobs int,
	isConditionCleared int
	primary key (ntRuleId)
)
Insert into #ntRuleIdJobStats
select distinct ntRuleId,0,0,1 from #ntRuleIdVisibleJobs
update ntRuleIdJobStats
set totalJobs = T.Count
from #ntRuleIdJobStats ntRuleIdJobStats,
(
	select ntRuleIdVisibleJobs.ntRuleId,count(*) as count from #ntRuleIdVisibleJobs ntRuleIdVisibleJobs
	group by ntRuleIdVisibleJobs.ntRuleId
) T
where T.ntRuleId = ntRuleIdJobStats.ntRuleId
update ntRuleIdJobStats
set noOfPendingJobs = T.Count
from #ntRuleIdJobStats ntRuleIdJobStats,
(
	select ntRuleIdVisibleJobs.ntRuleId,count(*) as count from #ntRuleIdVisibleJobs ntRuleIdVisibleJobs
	where (ntRuleIdVisibleJobs.visibleJobstatus=2 OR ntRuleIdVisibleJobs.visibleJobstatus=3)
	group by ntRuleIdVisibleJobs.ntRuleId
) T
where T.ntRuleId = ntRuleIdJobStats.ntRuleId
-- For users who cant see any jobs, we add entries to the job stats table with totaljobs and pendingjobs as 0.
Insert into #ntRuleIdJobStats
select distinct NTR.id,0,0,1 from NTnotificationRule NTR with (nolock)
	inner join NTSelCriteria with (nolock) on
	(NTR.id=@alertId or @alertId=0) and
	NTSelCriteria.ruleId = NTR.id
	and NTSelCriteria.availCriteriaId = 73 -- _NT_JOBS_PENDING_STATE
	where notifOwner !=-10
	and (NTR.status & (1|2)) = 0 --NT_STATUS_DISABLED|NT_STATUS_DELETED
	and NTR.id not in
	(
		select distinct ntRuleIdJobStats.ntRuleId from #ntRuleIdJobStats ntRuleIdJobStats
	)
declare @minJobsForjobPendingCriteria int = 5
select @minJobsForjobPendingCriteria = value from GxGlobalparam
where name='MinJobsForJobPendingCriteriaMatch'
and modified =0
update ntRuleIdJobStats
set isConditionCleared = 0
from #ntRuleIdJobStats ntRuleIdJobStats,
(
	select ruleid as NTRuleId,param1.value as PercentPendingJobs,param2.value as CountPendingJobs from NTSelCriteria
	inner join NTSelCriteriaParams param1 on
	NTSelCriteria.id=param1.selCriteriaid
	and param1.paramIndex=0 and (ruleId=@alertId or @alertId=0)
	inner join NTSelCriteriaParams param2 on
	NTSelCriteria.id=param2.selCriteriaid
	and param2.paramIndex=1 and (ruleId=@alertId or @alertId=0)
	where NTSelCriteria.availCriteriaId=73
) JobsPendingStateparams
where ntRuleIdJobStats.ntRuleId = JobsPendingStateparams.ntRuleId
and (ntRuleIdJobStats.noOfPendingJobs>JobsPendingStateparams.CountPendingJobs OR
(JobsPendingStateparams.PercentPendingJobs>0 and ntRuleIdJobStats.totalJobs>=@minJobsForjobPendingCriteria and ntRuleIdJobStats.totalJobs>0
and ntRuleIdJobStats.noOfPendingJobs*1.0/ntRuleIdJobStats.totalJobs > (JobsPendingStateparams.PercentPendingJobs*1.0/100))
)
IF object_id('tempdb.dbo.#expandedSelectedEntityIdsJobStats') is not null
	DROP TABLE #expandedSelectedEntityIdsJobStats
IF object_id('tempdb.dbo.#ntRuleIdVisibleJobs') is not null
	DROP TABLE #ntRuleIdVisibleJobs
select ntRuleId,totalJobs,noOfPendingJobs,isConditionCleared
from #ntRuleIdJobStats
IF object_id('tempdb.dbo.#ntRuleIdJobStats') is not null
		DROP TABLE #ntRuleIdJobStats
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetRunningJobStats')
	delete from GxQscripts where name = 'NTGetRunningJobStats'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetRunningJobStats')
	delete from GXDBVersions where aliasname = 'NTGetRunningJobStats'
GO

insert into GXDBVersions values(2, 'NTGetRunningJobStats',  '00000000000000000000', 'NTGetRunningJobStats', '00000000000000000000')
GO

