

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetRunningDPJobs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  | Stored procedure:  NTGetRunningDPJobs()
--  |
--  | Description     :  Gets the list of Data protection jobs which are in running state
--  |                    This is based on gxglobalparam 'NTDPJobRefreshInterval' if NTDPJobRefreshInterval is negative then this will always return -1
--  |      Input      :  ???
--  |
--  |      Output     :   Retrieves the list of jobs which are in running state.
--  |
--  |      Notes:
--  |
--  |   Revisions  Author		            Description
--  |   ---------  -----------------     ---------------------------------------------
--  |   1.1        Nikhil Chorappan 	   Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetRunningDPJobs <<<'

IF EXISTS (select * from sysobjects where name='NTGetRunningDPJobs')
	drop procedure NTGetRunningDPJobs
IF EXISTS (select * from GxQscripts where name='NTGetRunningDPJobs')
	delete from GxQscripts where name = 'NTGetRunningDPJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetRunningDPJobs')
	delete from GXDBVersions where aliasname = 'NTGetRunningDPJobs'
GO
print '... Creating Procedure: NTGetRunningDPJobs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure NTGetRunningDPJobs
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
  DECLARE @jobId integer
set transaction isolation level read uncommitted
DECLARE @now INT
DECLARE @interval INT
DECLARE @lastRefreshedTime INT
DECLARE @defaultInterval INT
DECLARE @minDelayHours INT
SET @now = (SELECT DATEDIFF(s, '1970-01-01 00:00:00', GETUTCDATE() ))
SET @defaultInterval = -5  -- Deactivated
IF NOT EXISTS( SELECT * FROM GXGlobalParam WHERE name LIKE 'NTDPJobLastRefreshedTime' )
  INSERT INTO GXGlobalParam VALUES ('NTDPJobLastRefreshedTime' ,@now ,@now,0  );
IF NOT EXISTS( SELECT * FROM GXGlobalParam WHERE name LIKE 'NTDPJobRefreshInterval' )
  INSERT INTO GXGlobalParam VALUES ('NTDPJobRefreshInterval' ,@defaultInterval ,@now,0  );
SELECT @interval = (value*60) FROM GXGlobalParam WHERE name LIKE 'NTDPJobRefreshInterval'
SELECT @lastRefreshedTime = value FROM GXGlobalParam WHERE name LIKE 'NTDPJobLastRefreshedTime'
IF ( (( @lastRefreshedTime + @interval ) <= @now )  AND  @interval > 0  )
BEGIN
  -- We need to refresh the events triger time
    UPDATE GXGlobalParam SET value = @now WHERE name LIKE 'NTDPJobLastRefreshedTime'
	SELECT  @minDelayHours =  MIN(value) FROM NTSelCriteria
	INNER JOIN NTSelCriteriaParams
	ON NTSelCriteria.id =  selCriteriaid
	WHERE availCriteriaid = 67  -- JOB EXCEEDES RUNNING TIME CRITERIA
	IF  @minDelayHours IS NOT NULL
	BEGIN
		SELECT jobId FROM RunningBackups
		WHERE state = 1  -- RUNNING STATE
		AND (@now - jobStartTime)/ (60 * 60)>= @minDelayHours  -- NEED ONLY JOBS STARTED ATLEAST 1 HOUR BEFORE
	END
	ELSE
	BEGIN
	  SELECT -2   -- negative value means this feature is deactivated since we dont have any alert rule with this criteria.
	END
END
ELSE IF (@interval < 0)
BEGIN
  SELECT -1   -- negative value means this feature is deactivated
END
ELSE
BEGIN
  SELECT 0
END

IF EXISTS (select * from GxQscripts where name = 'NTGetRunningDPJobs')
	delete from GxQscripts where name = 'NTGetRunningDPJobs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetRunningDPJobs')
	delete from GXDBVersions where aliasname = 'NTGetRunningDPJobs'
GO

insert into GXDBVersions values(2, 'NTGetRunningDPJobs',  '00000000000000000000', 'NTGetRunningDPJobs', '00000000000000000000')
GO

