

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetPossibleCausesForJobLongRunTime.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +========================================================================+
--  |   Procedure:  NTGetPossibleCausesForJobLongRunTime()
--  |
--  | Description:  Returns the possible reasons of why a job is running long
--  |
--  |       Input:  jobId, forReport, localeId
--  |
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTGetPossibleCausesForJobLongRunTime')
BEGIN
	print '>>> Drop Stored Procedure: NTGetPossibleCausesForJobLongRunTime <<<'
	drop procedure NTGetPossibleCausesForJobLongRunTime
END
IF EXISTS (select * from GxQscripts where name='NTGetPossibleCausesForJobLongRunTime')
	delete from GxQscripts where name = 'NTGetPossibleCausesForJobLongRunTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetPossibleCausesForJobLongRunTime')
	delete from GXDBVersions where aliasname = 'NTGetPossibleCausesForJobLongRunTime'
GO
print '... Creating Procedure: NTGetPossibleCausesForJobLongRunTime'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetPossibleCausesForJobLongRunTime
  @jobId INT,
  @forReport INT,
  @localeId INT
AS
  DECLARE @possibleCauses NVARCHAR(MAX)
	SELECT dbo.NTGetPossibleCausesForLongRunTime(@jobId,@forReport,@localeId)
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetPossibleCausesForJobLongRunTime')
	delete from GxQscripts where name = 'NTGetPossibleCausesForJobLongRunTime'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetPossibleCausesForJobLongRunTime')
	delete from GXDBVersions where aliasname = 'NTGetPossibleCausesForJobLongRunTime'
GO

insert into GXDBVersions values(2, 'NTGetPossibleCausesForJobLongRunTime',  '00000000000000000000', 'NTGetPossibleCausesForJobLongRunTime', '00000000000000000000')
GO

