

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetNotifRuleForEntity.sp] ---------- 

-- -------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetNotifRuleForEntity.sp,v $ $Id: NTGetNotifRuleForEntity.sp,v 1.3.66.3 2020/05/13 17:11:06 mnatarajan Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   NTGetNotifRuleForEntity   - Get Alerts which cover an entity
--	-------------------------------------------------------
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTGetNotifRuleForEntity')
BEGIN
	print '>>> Drop Stored Procedure: NTGetNotifRuleForEntity <<<'
	drop procedure NTGetNotifRuleForEntity
END
IF EXISTS (select * from GxQscripts where name='NTGetNotifRuleForEntity')
	delete from GxQscripts where name = 'NTGetNotifRuleForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetNotifRuleForEntity')
	delete from GXDBVersions where aliasname = 'NTGetNotifRuleForEntity'
GO
print '... Creating Procedure: NTGetNotifRuleForEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetNotifRuleForEntity
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @userId int,
  @xmlText xml output
AS
SET NOCOUNT ON
  DECLARE @o_xml xml;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET ANSI_WARNINGS ON
declare @clientId int = 0
declare @subclientId int = 0
declare @criteriaId int = 0
declare @alertTypeId int = 0
declare @notifId int = 0
declare @alertTypeList table
(
	alertTypeReq int
)
if (@alertTypeId=0)
begin
	Insert into @alertTypeList
select 20
	union
select 22
	union
select 4
	union
select 10
	union
select 3
	union
select 28
	union
select 25
	union
select 64
end
else
begin
	Insert into @alertTypeList
	select @alertTypeId
end
set @clientId = ISNULL(@xmlText.value('(CvEntities_GenericEntity/@clientId)[1]','int'),0)
set @subclientId = ISNULL(@xmlText.value('(CvEntities_GenericEntity/@subclientId)[1]','int'),0)
if @clientId=0
begin
	select @clientId = clientid from app_application
	where id=@subclientId
	if (@clientId is null)
	begin
		set @clientId = 0
	end
end
IF object_id('tempdb.dbo.#selectedEntityIds') is not null
		DROP TABLE #selectedEntityIds
CREATE TABLE #selectedEntityIds
(
	clientGroupId int,
    clientId int,
    appTypeId int,
    instanceId int,
    backupsetId int,
    subclientId int,
    excluded int,
    entityType int,
    ntRuleId int
)
CREATE CLUSTERED INDEX selectedEntityIds_ntRuleId_clientID_idx ON #selectedEntityIds (ntRuleId,clientID)
-- First check whether any alert is present
-- In case there are no active alerts , then SP returns empty
if not exists(
		select 1 from NTSelCriteria NTSel with (nolock)
		inner join NTNotificationRule  NTRule with (nolock)
		on NTRule.id = NTsel.ruleid
where (NTRule.status & (2)) = 0
	)
begin
	set @xmlText = '<CVGui_AlertListResp/>'
	return
end
IF object_id('tempdb.dbo.#xmlEntityListTbl') is not null
	DROP TABLE #xmlEntityListTbl
CREATE TABLE #xmlEntityListTbl
(
	ntRuleId int,
	xmlEntityList xml
)
CREATE CLUSTERED INDEX xmlEntityListTbl_ntRuleId_idx ON #xmlEntityListTbl (ntRuleId)
-- First look at all entities selected for non (deleted) alerts
Insert into #xmlEntityListTbl
select id,xmlEntityList
from NTnotificationRule with (nolock),
@alertTypeList AlertTypeList
where id in
(
	select ruleId from NTSelCriteria with (nolock)
	where (NTSelCriteria.availCriteriaid=@criteriaId or @criteriaId=0)
)
-- We dont want to look into deleted alerts.
and (status & (2)) = 0
-- We dont want to look at laptop alerts
and (status & (128)) = 0
-- Also only look at rules created for the given alert type.
and (NTnotificationRule.alertTypeId = AlertTypeList.alertTypeReq  or AlertTypeList.alertTypeReq=0)
and (NTnotificationRule.id = @notifId or @notifId=0)
-- Remove all entries which are job based alerts or schedule based alerts.
delete from #xmlEntityListTbl
where xmlEntityList.exist('CVGui_CommCellTreeNode/trackingJobs/jobs')=1
delete from #xmlEntityListTbl
where xmlEntityList.exist('CVGui_CommCellTreeNode/trackingSchedules/schedules')=1
-- Convert from older format to new format.
UPDATE #xmlEntityListTbl
SET xmlEntityList = dbo.NTGetAssociationFromCommcellTreeNode(xmlEntityList)
WHERE xmlEntityList.exist('CVGui_CommCellTreeNode/associations')=0
--- Now handle associations also ...
Insert into #selectedEntityIds(clientGroupId,clientId,appTypeId,instanceId,backupsetId,subclientId,entityType,excluded,ntRuleId)
select ISNULL(Tbl.Col.value('@clientGroupId', 'int'),0),
	ISNULL(Tbl.Col.value('@clientId', 'int'),0),
	ISNULL(Tbl.Col.value('@applicationId', 'int'),0),
	ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
	ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
	ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
	ISNULL(Tbl.Col.value('@_type_', 'int'),0),
	ISNULL(Tbl.Col.value('(flags/@exclude)[1]', 'int'),0),
	ntRuleID
	from #xmlEntityListTbl
	CROSS APPLY xmlEntityList.nodes('CVGui_CommCellTreeNode/associations') as Tbl(Col)
IF object_id('tempdb.dbo.#AlertIdListForEntity') is not null
	DROP TABLE #AlertIdListForEntity
CREATE TABLE #AlertIdListForEntity
(
	alertId int
)
CREATE CLUSTERED INDEX AlertIdListForEntity_alertId_idx ON #AlertIdListForEntity (alertId)
-- In case all client groups are selected. First check if client is part of any CG
IF EXISTS(SELECT 1 FROM App_clientGroupAssoc (NOLOCK) WHERE clientID = @clientId) AND EXISTS(select 1 from #selectedEntityIds
	where clientGroupId=0 and clientId =0 and appTypeId = 0 and instanceId = 0 and backupsetId =0 and subclientId = 0
	and excluded = 0 and entityType=27) --ALL_CLIENT_GROUPS_ENTITY
BEGIN
	INSERT INTO #AlertIdListForEntity
	SELECT NTRuleID FROM #selectedEntityIds
	WHERE clientGroupId=0 and clientId =0 and appTypeId = 0 and instanceId = 0 and backupsetId =0 and subclientId = 0
	and excluded = 0 and entityType=27
END
-- In case all clients are selected,
if exists(select 1 from #selectedEntityIds
	where clientGroupId=0 and clientId =0 and appTypeId = 0 and instanceId = 0 and backupsetId =0 and subclientId = 0
	and excluded = 0)
BEGIN
	INSERT INTO #AlertIdListForEntity
	SELECT NTRuleID FROM #selectedEntityIds
	WHERE clientGroupId=0 and clientId =0 and appTypeId = 0 and instanceId = 0 and backupsetId =0 and subclientId = 0
	and excluded = 0
END
-- If a client group is selected then all clients under the group is selected.
INSERT INTO #AlertIdListForEntity
SELECT NTRuleID
FROM App_clientGroupAssoc with (nolock) inner join #selectedEntityIds AEIds on
AEIds.clientGroupId = App_clientGroupAssoc.clientGroupId AND App_clientGroupAssoc.clientID = @clientId
WHERE AEIds.clientId = 0
UNION
SELECT NTRuleID
FROM #selectedEntityIds SelectedEntities
INNER JOIN App_Application (NOLOCK) ON (App_Application.id = @subclientID OR @subclientID = 0)
AND App_Application.clientID = @clientID
WHERE SelectedEntities.clientId = App_Application.clientId
AND (SelectedEntities.appTypeId = App_Application.appTypeId or SelectedEntities.appTypeId = 0)
AND (SelectedEntities.instanceId = App_Application.instance or SelectedEntities.instanceId = 0)
AND (SelectedEntities.backupsetId = App_Application.backupSet or SelectedEntities.backupsetId = 0)
AND (SelectedEntities.subclientId = App_Application.Id or SelectedEntities.subclientId = 0)
-- Remove alerts where given client or subclient is excluded.
DELETE #AlertIdListForEntity FROM #AlertIdListForEntity
INNER JOIN #selectedEntityIds SelectedEntities ON #AlertIdListForEntity.alertID = SelectedEntities.NTRuleID
INNER JOIN App_Application (NOLOCK) ON (App_Application.id = @subclientID OR @subclientID = 0)
AND App_Application.clientID = @clientID
WHERE SelectedEntities.clientId = App_Application.clientId
AND (SelectedEntities.appTypeId = App_Application.appTypeId or SelectedEntities.appTypeId = 0)
AND (SelectedEntities.instanceId = App_Application.instance or SelectedEntities.instanceId = 0)
AND (SelectedEntities.backupsetId = App_Application.backupSet or SelectedEntities.backupsetId = 0)
AND (SelectedEntities.subclientId = App_Application.Id or SelectedEntities.subclientId = 0)
AND SelectedEntities.excluded=1
-- Remove alerts where given clientgroup is excluded.
DELETE #AlertIdListForEntity FROM #AlertIdListForEntity
INNER JOIN #selectedEntityIds SelectedEntities ON #AlertIdListForEntity.alertID = SelectedEntities.NTRuleID
INNER JOIN App_ClientGroupAssoc (NOLOCK) ON App_ClientGroupAssoc.clientId = @clientID
AND App_ClientGroupAssoc.clientGroupId = SelectedEntities.clientGroupID AND SelectedEntities.clientID = 0
AND SelectedEntities.excluded=1
-- First retrieve all alerts which this user can see.
declare @alertsListRespTbl table
(
	alertListResp xml
)
Insert into @alertsListRespTbl
exec dbo.br_ntalertList @userId,0,2
declare @alertsListResp xml
set @alertsListResp = IsNull((select top 1 alertListResp from @alertsListRespTbl),'<CVGui_AlertListResp/>')
IF object_id('tempdb.dbo.#visibleAlertidList') is not null
	DROP TABLE #visibleAlertidList
CREATE TABLE #visibleAlertidList
(
	alertId int,
	alertListxml xml
)
CREATE CLUSTERED INDEX visibleAlertidList_alertId_idx ON #visibleAlertidList (alertId)
Insert into #visibleAlertidList(alertId,alertListxml)
select Tbl.Col.value('(alert/@id)[1]','int'),
	Tbl.Col.query('.')
from @alertsListResp.nodes('/CVGui_AlertListResp/alertList') as Tbl(Col)
DELETE visibleAlertidList FROM #visibleAlertidList visibleAlertidList
LEFT JOIN #AlertIdListForEntity ON visibleAlertidList.alertID = #AlertIdListForEntity.alertID
WHERE #AlertIdListForEntity.alertID IS NULL
set @xmlText = (select alertListxml.query('.')
	from #visibleAlertidList
for xml path(''),root('CVGui_AlertListResp'))
if @xmlText is null
begin
	set @xmlText = '<CVGui_AlertListResp/>'
end
IF object_id('tempdb.dbo.#selectedEntityIds') is not null
	DROP TABLE #selectedEntityIds
IF object_id('tempdb.dbo.#xmlEntityListTbl') is not null
	DROP TABLE #xmlEntityListTbl
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetNotifRuleForEntity')
	delete from GxQscripts where name = 'NTGetNotifRuleForEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetNotifRuleForEntity')
	delete from GXDBVersions where aliasname = 'NTGetNotifRuleForEntity'
GO

insert into GXDBVersions values(2, 'NTGetNotifRuleForEntity',  '00010003006600030000', 'NTGetNotifRuleForEntity', '00010003006600030000')
GO

