

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetNotifDetails.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetNotifDetails.sp,v $ $Id: NTGetNotifDetails.sp,v 1.1.2.2 2017/07/02 05:18:55 mnatarajan Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   NTGetNotifDetails   - Fetch alert details for mongo client processing.
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetNotifDetails <<<'

IF EXISTS (select * from sysobjects where name='NTGetNotifDetails')
	drop procedure NTGetNotifDetails
IF EXISTS (select * from GxQscripts where name='NTGetNotifDetails')
	delete from GxQscripts where name = 'NTGetNotifDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetNotifDetails')
	delete from GXDBVersions where aliasname = 'NTGetNotifDetails'
GO
print '... Creating Procedure: NTGetNotifDetails'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetNotifDetails
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlData xml
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @ntalertTypeId int=0
SELECT @ntalertTypeId = ISNULL (( SELECT ref.value('@alertTypeId', 'INT')
                    FROM @xmlData.nodes ('Api_NTGetAlertNotifDetailsReq') R(ref)), 0)
IF OBJECT_ID('tempdb.dbo.#shareIdsList') IS NOT NULL
	DROP TABLE #shareIdsList
CREATE TABLE #shareIdsList (shareId INT primary key(shareId) )
IF OBJECT_ID('tempdb.dbo.#shareDetails') IS NOT NULL
	DROP TABLE #shareDetails
CREATE TABLE #shareDetails (shareId INT primary key(shareId), shareName nvarchar(max), syncPath nvarchar(max) )
Insert into #shareIdsList
SELECT distinct ref.value('@val', 'int') AS Agent
FROM    @xmlData.nodes('Api_NTGetAlertNotifDetailsReq/shareIds') R ( ref )
declare @outputXml xml = '<Api_NTGetAlertNotifDetailsResp />'
declare @adminEmail nvarchar(max)=N''
if (@ntalertTypeId=72)
begin
	DECLARE @adminUserFlags int
	set @adminUserFlags = 0x040
	select @adminEmail = email from UMUsers WHERE ((UMUsers.flags & @adminUserFlags) <> 0) and enabled =1
	Insert into #shareDetails(shareId , shareName , syncPath)
	select App_SyncCloudConfig.syncwebFolderId, App_SyncCloudFolder.syncWebFolderName, App_SyncCloudConfig.syncpath
	from #shareIdsList shareIdsList inner join App_SyncCloudConfig on
	App_SyncCloudConfig.syncwebFolderId=shareIdsList.shareId
	inner join App_SyncCloudFolder on App_SyncCloudFolder.syncwebFolderId =App_SyncCloudConfig.syncwebFolderId
end
set @outputXml = (
	select @adminEmail '@adminEmail',
		(
			select syncPath '@syncPath', shareId 'shareEntity/@shareId', shareName 'shareEntity/@shareName'
			from #shareDetails
			for xml path('shareResp'),TYPE
		)
		for xml path('Api_NTGetAlertNotifDetailsResp')
)
if @outputXml is null
begin
	set @outputXml='<Api_NTGetAlertNotifDetailsResp/>'
end
IF OBJECT_ID('tempdb.dbo.#getshareIds') IS NOT NULL
	DROP TABLE #getshareIds
IF OBJECT_ID('tempdb.dbo.#shareDetails') IS NOT NULL
	DROP TABLE #shareDetails
select @outputXml
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetNotifDetails')
	delete from GxQscripts where name = 'NTGetNotifDetails'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetNotifDetails')
	delete from GXDBVersions where aliasname = 'NTGetNotifDetails'
GO

insert into GXDBVersions values(2, 'NTGetNotifDetails',  '00010001000200020000', 'NTGetNotifDetails', '00010001000200020000')
GO

