

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetMetricsAlarmProps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  NTGetMetricsAlarmProps()
--  |
--  | Description:  Get alarm properties for metrics queries
--  |
--  |      Input:   ???
--  |
--  |      Output:  Get alarm properties
--  |
--  |      Notes:
--  |
--  |   Revisions  Author		Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        mnatarajan 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetMetricsAlarmProps <<<'

IF EXISTS (select * from sysobjects where name='NTGetMetricsAlarmProps')
	drop procedure NTGetMetricsAlarmProps
IF EXISTS (select * from GxQscripts where name='NTGetMetricsAlarmProps')
	delete from GxQscripts where name = 'NTGetMetricsAlarmProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetMetricsAlarmProps')
	delete from GXDBVersions where aliasname = 'NTGetMetricsAlarmProps'
GO
print '... Creating Procedure: NTGetMetricsAlarmProps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetMetricsAlarmProps
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inpAlarmId int
AS
  DECLARE @type integer 
  DECLARE @userId integer
  DECLARE @alarmLabel nvarchar(max)
  DECLARE @extendedProps nvarchar(max)
  DECLARE @commcellGUID nvarchar(max)	
  DECLARE @email nvarchar(max)
  DECLARE @login nvarchar(max)
  DECLARE @paramName nvarchar(max)
  DECLARE @displayName nvarchar(max)
  DECLARE @commcellName nvarchar(max)
  DECLARE @reportName nvarchar(max)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SELECT	A.type,
		A.userId,
		'',
		CAST(A.extendedProps AS NVARCHAR(MAX)),
		A.CommCellGUID,
		A.email,
		(CASE WHEN ISNULL(U.name, '') = '' THEN U.login ELSE U.name END),
		A.ParamName,
		A.displayName,
		(SELECT CC.aliasName from APP_CommCell CC WHERE id = 2) AS 'CommCell Name',
		A.reportName
FROM	CustomAlarmProps A
		INNER JOIN UMUsers U
			ON A.userId = U.id
		where A.AlarmId = @inpAlarmId
--WHERE	A.flags = 0
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetMetricsAlarmProps')
	delete from GxQscripts where name = 'NTGetMetricsAlarmProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetMetricsAlarmProps')
	delete from GXDBVersions where aliasname = 'NTGetMetricsAlarmProps'
GO

insert into GXDBVersions values(2, 'NTGetMetricsAlarmProps',  '00000000000000000000', 'NTGetMetricsAlarmProps', '00000000000000000000')
GO

