

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetLMSearchProps.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  NTGetLMSearchProps()
--  |
--  | Description:  Get search properties for alerts
--  |
--  |      Input:   ???
--  |
--  |      Output:  Get search properties
--  |
--  |      Notes:
--  |
--  |   Revisions  Author		Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        mnatarajan 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetLMSearchProps <<<'

IF EXISTS (select * from sysobjects where name='NTGetLMSearchProps')
	drop procedure NTGetLMSearchProps
IF EXISTS (select * from GxQscripts where name='NTGetLMSearchProps')
	delete from GxQscripts where name = 'NTGetLMSearchProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetLMSearchProps')
	delete from GXDBVersions where aliasname = 'NTGetLMSearchProps'
GO
print '... Creating Procedure: NTGetLMSearchProps'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetLMSearchProps
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @inpSearchId int,
  @inpAlertId int
AS
  DECLARE @searchCriteria nvarchar(max)
  DECLARE @searchQuery nvarchar(max)
  DECLARE @searchUrl nvarchar(max)
  DECLARE @matchAboveLinesBelowLinesInfo nvarchar(max)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @lmAlertType int
declare @searchXml xml
declare @thisManyTimes int
declare @withinTheseManyMinutes int
declare @localeId int
declare @linesAboveMatchedLine int
declare @linesBelowMatchedLine int
declare @monitoringAppType	int
declare @lmUrl nvarchar(max)
declare @rateOfChangeValue nvarchar(max)
declare @rateOfChangeCriteria int
declare @webconsoleUrl nvarchar(max) = ''
set @localeId = 0
select @localeId=locale
from NTNotificationRule
where id=@inpAlertId
set @withinTheseManyMinutes = 0
set @thisManyTimes = 0
select @searchXml = searchInfo,@monitoringAppType = monitoringAppType from LMUserSearch
where searchId=@inpSearchId
select @searchQuery=Tbl.Col.value('@searchLabel','nvarchar(max)'),
@searchUrl = Tbl.Col.value('@browserURL','nvarchar(max)')
from @searchXml.nodes('/LogMonitoring_SearchURLInfo') as Tbl(Col)
set @searchCriteria = NULL
SELECT  @thisManyTimes= tbl.t.value('@thisManyTimes','int'),
		@withinTheseManyMinutes = tbl.t.value('@withinTheseManyMinutes','int'),
		@linesAboveMatchedLine = ISNULL(tbl.t.value('@linesAboveMatchedLine','int'),0),
		@linesBelowMatchedLine = ISNULL(tbl.t.value('@linesBelowMatchedLine','int'),0),
		@lmAlertType = ISNULL(tbl.t.value('@alertType','int'),0),
		@searchCriteria=tbl.t.value('@alertCriteria','nvarchar(max)')
		FROM APP_LMAlertInfo
		CROSS APPLY Alertprop.nodes('alertInfoLst') AS tbl(t)
		WHERE AlertId = @inpAlertId
if (@searchCriteria is NULL)
begin
	if (@lmAlertType<>2)
	begin
		if (@thisManyTimes>0 and @withinTheseManyMinutes>0)
		begin
			select @searchCriteria=Message from evlocalemsgs with (nolock)
where messageId=(1149 | (CAST(POWER(2, 24) AS BIGINT) * 74)) and localeId=@localeId
			set @searchCriteria=replace(@searchCriteria,'^1%s',convert(nvarchar(max),@thisManyTimes))
			set @searchCriteria=replace(@searchCriteria,'^2%s',convert(nvarchar(max),@withinTheseManyMinutes))
		end
	end
	else
	begin
		set @linesAboveMatchedLine = 0
		set @linesBelowMatchedLine = 0
		SELECT  @rateOfChangeCriteria= tbl.t.value('@rCriteria','int'),
		@rateOfChangeValue = tbl.t.value('@rateOfChange','nvarchar(max)')
		FROM APP_LMAlertInfo
		CROSS APPLY Alertprop.nodes('alertInfoLst/rateOfChangeAlertInfo') AS tbl(t)
		WHERE AlertId = @inpAlertId
		declare @trendcriteriaMappingText table
		(
			criteria int,
			text nvarchar(max)
		)
		Insert into @trendcriteriaMappingText
		select 0,'Rate of change increases by <0>'
		union
		select 1,'Rate of change increases by <0>%'
		union
		select 2,'Rate of change decreases by <0>'
		union
		select 3,'Rate of change decreases by <0>%'
		union
		select 4,'Rate of change increases/decreases by <0>'
		union
		select 5,'Rate of change increases/decreases by <0>%'
		select @searchCriteria = text from @trendcriteriaMappingText
		where criteria = @rateOfChangeCriteria
		set @searchCriteria = replace(@searchCriteria,'<0>',@rateOfChangeValue)
	end
end
-- for value based alerts and match the below criteria alerts, lines above and lines below are not applicable..
if (@lmAlertType=2)
begin
	set @linesAboveMatchedLine = 0
	set @linesBelowMatchedLine = 0
end
set @matchAboveLinesBelowLinesInfo = N''
if (@linesAboveMatchedLine>0)
begin
	set @matchAboveLinesBelowLinesInfo = convert(nvarchar(max),@linesAboveMatchedLine) + ' Lines above'
end
if (len(@matchAboveLinesBelowLinesInfo)>0 and @linesBelowMatchedLine>0)
begin
	set @matchAboveLinesBelowLinesInfo = @matchAboveLinesBelowLinesInfo + ' and '
end
if (@linesBelowMatchedLine>0)
begin
	set @matchAboveLinesBelowLinesInfo = @matchAboveLinesBelowLinesInfo + convert(nvarchar(max),@linesBelowMatchedLine) + ' Lines below'
end
if (len(@matchAboveLinesBelowLinesInfo)>0)
begin
	set @matchAboveLinesBelowLinesInfo = @matchAboveLinesBelowLinesInfo + ' matched log line are included in alert'
end
SELECT @webconsoleUrl = value FROM GXGlobalParam with (nolock)
WHERE name = 'WebConsoleURL' AND modified = 0
declare @posIdx int = 0
SET @posIdx = PATINDEX('%/webconsole/%', @webconsoleUrl)
IF @posIdx = 0
BEGIN
	SET @posIdx = PATINDEX('%/webconsole%', @webconsoleUrl)
	IF @posIdx = 0
	BEGIN
		SET @webconsoleUrl =  ''
	END
	ELSE
	BEGIN
		SET @webconsoleUrl =  REVERSE(RIGHT(REVERSE (@webconsoleUrl), len(@webconsoleUrl) - NULLIF(charindex('elosnocbew/', REVERSE(@webconsoleUrl)) - 2,0))) + '/'
	END
END
ELSE
BEGIN
	SET @webconsoleUrl = LEFT(@webconsoleUrl, @posIdx+LEN('/webconsole/')-1)
END
if len(@webconsoleUrl)=0
begin
	DECLARE @dm2WebServerList TABLE
	(
		o_componentNameId   INTEGER,
		o_portNumber        INTEGER,
		o_apachePortNumber  INTEGER,
		o_clientName        CHAR(1024),
		o_clientHostName    CHAR(1024)
	)
	--Below are client Ids
	DECLARE @webconsoleforDm2ServerList TABLE
	(
		o_webconsoleId      INTEGER
	)
	DECLARE @dm2WebServerId     INTEGER
	INSERT INTO @dm2WebServerList(o_componentNameId,o_portNumber,o_apachePortNumber,o_clientName,o_clientHostName)
	EXEC SimGetAvaliableDM2WebServers 1
	IF EXISTS(SELECT 1 FROM @dm2WebServerList WHERE o_componentNameId <> 0)
    BEGIN
        --Now, loop over the list of Dm2 webserver clients and fetch all web console clients pointing to them
        DECLARE @dm2TableCur cursor
        --if cursor is already open , close it
        IF ( CURSOR_STATUS('variable', '@dm2TableCur') > 0) /* cursor is open */
        close @dm2TableCur
        SET @dm2TableCur = cursor
        for SELECT DISTINCT o_componentNameId
        FROM @dm2WebServerList
            OPEN @dm2TableCur
                FETCH NEXT FROM @dm2TableCur INTO @dm2WebServerId
                WHILE @@FETCH_STATUS = 0
                BEGIN
                    --Fetch all configured web console clients
                    INSERT INTO @webconsoleforDm2ServerList(o_webconsoleId)
                    EXEC  simGetAssociatedWebConsoles  @dm2WebServerId , 1
                    FETCH NEXT FROM @dm2TableCur INTO @dm2WebServerId
                END
        IF ( CURSOR_STATUS('variable', '@dm2TableCur') > 0) /* cursor is open */
            CLOSE  @dm2TableCur
        IF ( CURSOR_STATUS('variable', '@dm2TableCur') = -1) /* cursor is closed */
                DEALLOCATE @dm2TableCur
		SET @webconsoleUrl = ISNULL( (SELECT TOP 1 attrVal
					FROM    app_clientprop ACP JOIN @webconsoleforDm2ServerList WSL on ACP.componentNameId = WSL.o_webconsoleId
					WHERE   ACP.attrName = 'WebURL' AND ACP.modified = 0) , '')
    END
END
-- If webconsole url has trailing / then remove it
if (substring(@webconsoleUrl,len(@webconsoleUrl),1)='/')
begin
	set @webconsoleUrl = substring(@webconsoleUrl,1,len(@webconsoleUrl)-1)
end
if (@monitoringAppType=2)
begin
	set @lmUrl = '/sysMonitoring.do'
end
else
begin
	set @lmUrl = '/logMonitoring.do'
end
SET @searchUrl = @webconsoleUrl + @lmUrl +@searchUrl
if @searchUrl is null
begin
	set @searchUrl = ''
end
set @searchUrl = 'Please click on this <a class="hc-cell-a" href="'+@searchUrl+'">link</a> for more information'
select @searchCriteria,@searchQuery,@searchUrl,@matchAboveLinesBelowLinesInfo
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetLMSearchProps')
	delete from GxQscripts where name = 'NTGetLMSearchProps'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetLMSearchProps')
	delete from GXDBVersions where aliasname = 'NTGetLMSearchProps'
GO

insert into GXDBVersions values(2, 'NTGetLMSearchProps',  '00000000000000000000', 'NTGetLMSearchProps', '00000000000000000000')
GO

