

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetEmailIds.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetEmailIds.sp,v $ $Id: NTGetEmailIds.sp,v 1.1.54.1 2018/03/27 09:20:04 jiechen Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   AppCheckEntityIncluded   - This procedure takes two argument @entity and @entityList .
--                              @entity will be of the type GenericEntity message xml and @entityList will be of association message type
--                              Which is a list of generic entity , This procedure will check whether @entity is included or not in the entity list
--
--
--  +========================================================================+
--  | Stored Precedure: NTGetEmailIds
--  |
--  | Description:
--  |   This procedure takes two argument @ruleId and @escalationLevel .
--  |  Returns a list of email Ids need to notify the given alert with given esclation Level
--	|
--  |
--  |   Revisions  Author              Description
--  |   ---------  -----------        -------------------------------
--  |   1.0        Nikhil Chorappan    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetEmailIds <<<'

IF EXISTS (select * from sysobjects where name='NTGetEmailIds')
	drop procedure NTGetEmailIds
IF EXISTS (select * from GxQscripts where name='NTGetEmailIds')
	delete from GxQscripts where name = 'NTGetEmailIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetEmailIds')
	delete from GXDBVersions where aliasname = 'NTGetEmailIds'
GO
print '... Creating Procedure: NTGetEmailIds'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetEmailIds
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @ruleId INT,
  @escalationLevel INT
AS
  DECLARE @emailList varchar(MAX) 
BEGIN
DECLARE @emails TABLE
(
   email varchar(100)
)
INSERT INTO @emails
SELECT email FROM ntnotificationgroups AS notifGroup
LEFT OUTER JOIN UMUserGroup
ON UMUserGroup.groupId  =  notifGroup.groupId
LEFT OUTER JOIN UMUsers AS users
ON users.id = UMUserGroup.userId
WHERE NTnotificationID = @ruleId AND escalationLevel = @escalationLevel
UNION
SELECT email FROM NTnotificationUsers AS notifUsers
LEFT OUTER JOIN UMUsers AS users
ON users.id = notifUsers.userId
WHERE NTnotificationID = @ruleId AND escalationLevel = @escalationLevel
UNION
SELECT nonGalaxyUserName FROM NTnotificationNonGalaxyUsers
WHERE NTnotificationID = @ruleId AND escalationLevel = @escalationLevel
SELECT @emailList = COALESCE(@emailList+';' ,'') + email FROM  @emails
select @emailList
END

IF EXISTS (select * from GxQscripts where name = 'NTGetEmailIds')
	delete from GxQscripts where name = 'NTGetEmailIds'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetEmailIds')
	delete from GXDBVersions where aliasname = 'NTGetEmailIds'
GO

insert into GXDBVersions values(2, 'NTGetEmailIds',  '00010001005400010000', 'NTGetEmailIds', '00010001005400010000')
GO

