

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetDetectedAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetDetectedAlerts.sp,v $ $Id: NTGetDetectedAlerts.sp,v 1.1.2.6 2020/08/18 21:03:53 jragunathan Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   NTGetDetectedAlerts
--	- Fetch the list of detected alerts matching input conditions.
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTGetDetectedAlerts')
BEGIN
	print '>>> Drop Stored Procedure: NTGetDetectedAlerts <<<'
	drop procedure NTGetDetectedAlerts
END
IF EXISTS (select * from GxQscripts where name='NTGetDetectedAlerts')
	delete from GxQscripts where name = 'NTGetDetectedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetDetectedAlerts')
	delete from GXDBVersions where aliasname = 'NTGetDetectedAlerts'
GO
print '... Creating Procedure: NTGetDetectedAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetDetectedAlerts
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @m_alertCategory int, 
  @m_alertType int, 
  @m_alertCriteria int,
  @m_alertId int,
  @m_timeBuff nvarchar(max),
  @m_timeBuffRepeatedAlert nvarchar(max)
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @eventId int
  DECLARE @criteria int
  DECLARE @alertType int
  DECLARE @category int
  DECLARE @status int
  DECLARE @processStat int
  DECLARE @occurTime datetime
  DECLARE @processTime datetime
  DECLARE @ntNotificationId int
  DECLARE @nextTriggerTime datetime
  DECLARE @entityId nvarchar(max)
declare @m_alertStatus int = 0
select @m_alertStatus = status from NTNotificationRule
where id=@m_alertId
declare @mappedCriteria table
(
	alertCriteriaID int PRIMARY KEY
)
Insert into @mappedCriteria VALUES
(68),
(69),
(71),
(74),
(76)
if not exists(select 1 from @mappedCriteria where alertCriteriaId=@m_alertCriteria)
begin
	select eventId , criteria , alertType , category , status , processStat , occurTime , processTime , ntNotificationId , nextTriggerTime, entityId from NTDetectedAlerts
	where category = @m_alertCategory AND alertType = @m_alertType AND criteria = @m_alertCriteria
	-- committed jobs should not be sent from here
AND status <> 3043
	---Check for notif based alerts.
	AND (ntNotificationId is NULL OR ntNotificationId = 0 OR ntNotificationId = @m_alertId )
	-- Check for fresh entries.
	AND ( (((processStat & (8|2)) = 0) AND occurTime < @m_timeBuff AND processStat != 0) OR --eAlertStatusProcessed|eAlertStatusPending|eAlertStatusPendingEsc|eAlertStatusPendingMatch
	-- check for repeated entries.
	 ( ((processStat & 2) <> 0) And nextTriggertime <= @m_timeBuffRepeatedAlert ) )
AND ( (@m_alertStatus & 1024)>0 OR (processStat & 256) = 0 )
	 AND ( (processStat & 128) = 0 ) --eAlertStatusVSASubclient ..  Dont return VSA alerts here. They need to be processed by br_ntprocessdiscoveredVMs first.
	 order by occurtime
	 return
 end
if (@m_alertCriteria=76)
 begin
	select eventId , criteria , alertType , category , status , processStat , occurTime , processTime , ntNotificationId , nextTriggerTime, entityId from NTDetectedAlerts
	where category = @m_alertCategory AND alertType = @m_alertType
AND ( ( criteria = 1 OR criteria = 57) AND status = 3043 )
	---Check for notif based alerts.
	AND (ntNotificationId = 0 OR ntNotificationId = @m_alertId OR ntNotificationId is NULL)
	-- Check for fresh entries.
	AND (((processStat & (8|2)) = 0) AND occurTime < @m_timeBuff AND processStat != 0) --eAlertStatusProcessed|eAlertStatusPending|eAlertStatusPendingEsc|eAlertStatusPendingMatch
	AND ( (processStat & 128) = 0 ) --eAlertStatusVSASubclient ..  Dont return VSA alerts here. They need to be processed by br_ntprocessdiscoveredVMs first.
	order by occurtime
	return
 end
 -- For consecutive job failure alerts, dont need to return detected alerts for successful criteria
IF (@m_alertCriteria= 71 )
 BEGIN
	select eventId , criteria , alertType , category , status , processStat , occurTime , processTime , ntNotificationId , nextTriggerTime, entityId from NTDetectedAlerts
	where category = @m_alertCategory AND alertType = @m_alertType
AND ( criteria = 3 OR criteria = 57 Or status = 3001 )
	---Check for notif based alerts.
	AND (ntNotificationId = 0 OR ntNotificationId = @m_alertId OR ntNotificationId is NULL)
	-- Check for fresh entries.
	AND (((processStat & (8|2)) = 0) AND occurTime < @m_timeBuff AND processStat != 0) --eAlertStatusProcessed|eAlertStatusPending|eAlertStatusPendingEsc|eAlertStatusPendingMatch
	AND ( (processStat & (128|256) ) = 0 ) -- 128: eAlertStatusVSASubclient and 256 : eAlertStatusDiscoveredVM Dont return VSA alerts here. They need to be processed by br_ntprocessdiscoveredVMs first.
	-- For mapped alert criteria, we dont need to return VM specific alerts
	order by occurtime
	RETURN
 END
 select eventId , criteria , alertType , category , status , processStat , occurTime , processTime , ntNotificationId , nextTriggerTime, entityId from NTDetectedAlerts
	where category = @m_alertCategory AND alertType = @m_alertType
AND ( criteria = 1 OR criteria = 3 OR criteria = 57 Or status = 3001 )
	---Check for notif based alerts.
	AND (ntNotificationId = 0 OR ntNotificationId = @m_alertId OR ntNotificationId is NULL)
	-- Check for fresh entries.
	AND (((processStat & (8|2)) = 0) AND occurTime < @m_timeBuff AND processStat != 0) --eAlertStatusProcessed|eAlertStatusPending|eAlertStatusPendingEsc|eAlertStatusPendingMatch
	AND ( (processStat & (128|256) ) = 0 ) -- 128: eAlertStatusVSASubclient and 256 : eAlertStatusDiscoveredVM Dont return VSA alerts here. They need to be processed by br_ntprocessdiscoveredVMs first.
	-- For mapped alert criteria, we dont need to return VM specific alerts
	order by occurtime
return
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetDetectedAlerts')
	delete from GxQscripts where name = 'NTGetDetectedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetDetectedAlerts')
	delete from GXDBVersions where aliasname = 'NTGetDetectedAlerts'
GO

insert into GXDBVersions values(2, 'NTGetDetectedAlerts',  '00010001000200060000', 'NTGetDetectedAlerts', '00010001000200060000')
GO

