

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetDefaultTemplateForQuery.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetDefaultTemplateForQuery.sp,v $ $Id: NTGetDefaultTemplateForQuery.sp,v 1.9.12.5 2018/09/18 18:52:15 snandhini Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   NTGetDefaultTemplateForQuery
--					 - Fetch the default template messages for the given custom query
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetDefaultTemplateForQuery <<<'

IF EXISTS (select * from sysobjects where name='NTGetDefaultTemplateForQuery')
	drop procedure NTGetDefaultTemplateForQuery
IF EXISTS (select * from GxQscripts where name='NTGetDefaultTemplateForQuery')
	delete from GxQscripts where name = 'NTGetDefaultTemplateForQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetDefaultTemplateForQuery')
	delete from GXDBVersions where aliasname = 'NTGetDefaultTemplateForQuery'
GO
print '... Creating Procedure: NTGetDefaultTemplateForQuery'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetDefaultTemplateForQuery
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @queryId int,
  @localeId int,
  @queryDetailXmlInfo xml
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
DECLARE @nowTime				datetime
declare @queryType				integer
declare @externalQueryId		nvarchar(max)
declare @alertTypeId			integer
declare @isHealthParam			integer
declare @additionalDetailXml	xml
set @additionalDetailXml = ''
DECLARE @newTemplate INT = ISNULL((SELECT value FROM GXGlobalParam WHERE name='UseNewAlertTemplate'),0)
set @alertTypeId = 65
IF OBJECT_ID('tempdb.dbo.#NTnotificationTemplateTemp') IS NOT NULL DROP TABLE #NTnotificationTemplateTemp
-- Create a new temp table which has all messages modified for custom query
create table #NTnotificationTemplateTemp
(
	NTalertTypeID		    integer,       -- Drives offline, Commcells unreachable ....
    messageType             integer,       -- email, pager, etc ...
    locale                  integer,       -- i.e. "EN_US".. Replaced w/FK To a Locale Lookup Table?  Yes
    defaultformatString     nvarchar(MAX), -- Default Format string for the message
	messageFormatType			integer
)
Insert into #NTnotificationTemplateTemp(NTalertTypeID,messageType,locale,defaultformatString,messageFormatType)
select NTalertTypeID,messageType,locale,defaultformatString,messageFormatType
from NTnotificationTemplate N1 with (nolock)
WHERE N1.NTalertTypeID = 65 and N1.locale = @localeId
declare @columnList table
(
	columnIndex int ,
	columnName nvarchar(max),
	columnFriendlyName nvarchar(max),
	xmlInfo xml,
	isColumnPartOfAlert bit,
	tokenId int,
	columnOrder int
)
if (@queryId>0)
begin
	Insert into @columnList(columnIndex,columnName,columnFriendlyName,xmlInfo,isColumnPartOfAlert)
	select	columnIndex,columnName,columnFriendlyName,convert(xml,convert(varchar(max),xmlInfo)),1
	from NTQueryColumnList with (nolock)
	where QueryId = @queryId
	and columnType = 0
	update @columnList
	set isColumnPartOfAlert = IsNull(xmlInfo.value('(App_AdditionalOutputColumnDetails/@includeInAlertOutput)[1]','bit'),1)
	where xmlInfo is not null and
	xmlInfo.exist('/App_AdditionalOutputColumnDetails')=1
	select @additionalDetailXml = xmlInfo from NTqueryList
	where queryId = @queryId
end
else
begin
	Insert into @columnList(columnIndex,columnName,columnFriendlyName,xmlInfo,isColumnPartOfAlert)
	select Tbl.Col.value('for $i in . return count(../*[local-name(.)=''queryOutputColumns'' and .<< $i])', 'int'),
	IsNull(Tbl.Col.value('@columnName', 'nvarchar(max)'),''),
	IsNull(Tbl.Col.value('@columnFriendlyName', 'nvarchar(max)'),''),
	'',
	IsNull(Tbl.Col.value('(columnAdditionalDetails/@includeInAlertOutput)[1]', 'bit'),1)
	from @queryDetailXmlInfo.nodes('App_QueryDetail/queryOutputColumns') as Tbl(Col)
	select @additionalDetailXml = T.c.query('.')
	from @queryDetailXmlInfo.nodes('App_QueryDetail/additionalQueryDetails') T(c)
	set @additionalDetailXml = replace(convert(nvarchar(max),@additionalDetailXml),'additionalQueryDetails','App_AdditionalQueryDetails')
end
set @queryType = 0
set @externalQueryId = ''
set @queryType = IsNull(@additionalDetailXml.value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1)
set @externalQueryId = IsNull(@additionalDetailXml.value('(App_AdditionalQueryDetails/externalQueryEntity/@externalQueryId)[1]','nvarchar(max)'),'')
if @queryType=0
begin
	set @queryType = 1
end
Update @columnList
set tokenId = (1000 | (CAST(POWER(2, 24) AS BIGINT) * 74)) + columnIndex,
columnOrder = 1
set @isHealthParam = IsNull(@additionalDetailXml.value('(App_AdditionalQueryDetails/@isHealthParam)[1]','int'),0)
if (@queryType=2) -- CustomQueryType::METRICS_QUERY
begin
	-- Now update report columns
	Insert into @columnList(columnIndex,columnName,columnFriendlyName,xmlInfo,isColumnPartOfAlert,tokenId,columnOrder)
select -1,'Alert Name','Alert Name','',1,(1109 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0
	if @isHealthParam=0
	begin
		Insert into @columnList(columnIndex,columnName,columnFriendlyName,xmlInfo,isColumnPartOfAlert,tokenId,columnOrder)
select -1,'Report Name','Report Name','',1,(1111 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0
		union
select -1,'Alert Criteria','Alert Criteria','',1,(1112 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0
	end
end
else if (@queryType=1) -- In case of metrics alerts, query name doesnt make sense since its the same as report name. Also condition cleared will always be not applicable.
-- So for custom alerts template, we add query name before column list and condition cleared at the end of the template.
begin
	Insert into @columnList(columnIndex,columnName,columnFriendlyName,xmlInfo,isColumnPartOfAlert,tokenId,columnOrder)
select -1, dbo.fn_EvFormatEventMsgText(0, @localeId, (1101 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0,2),dbo.fn_EvFormatEventMsgText(0, @localeId, (1101 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0,2),'',1,(1102 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0
	union
select -1,dbo.fn_EvFormatEventMsgText(0, @localeId, (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0,2),dbo.fn_EvFormatEventMsgText(0, @localeId, (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0,2),'',1,(182 | (CAST(POWER(2, 24) AS BIGINT) * 74)),2
	if exists(select 1 from NTqueryColumnList where queryId=@queryId and columnType=1)
	begin
		Insert into @columnList(columnIndex,columnName,columnFriendlyName,xmlInfo,isColumnPartOfAlert,tokenId,columnOrder)
select -1, '','','',1,(1143 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0
	end
end
Update @columnList
set columnFriendlyName = columnName
where columnFriendlyName is null or len(columnFriendlyName)=0
declare @templateNotificationMessage nvarchar(max)
declare @templateNotificationMessageHtml nvarchar(max)
set @templateNotificationMessage = ''
select @templateNotificationMessage = @templateNotificationMessage + columnFriendlyName
	+ case when len(columnFriendlyName)>0 then ' : ' else '' end
	+ dbo.fn_EvFormatEventMsgText(0, @localeId, tokenId , 0,2) +' MsgNewLine_MsgTab_ '
from @columnList
where isColumnPartOfAlert=1
order by columnOrder
set @templateNotificationMessage = ltrim(rtrim(@templateNotificationMessage))
if (patindex('%MsgNewLine_MsgTab_',@templateNotificationMessage)>0)
begin
	set @templateNotificationMessage = substring(@templateNotificationMessage,1,len(@templateNotificationMessage)-len('MsgNewLine_MsgTab_'))
end
-- For html template
set @templateNotificationMessageHtml = dbo.getHtmlEscapedString(@templateNotificationMessage,1)
set @templateNotificationMessageHtml = replace(@templateNotificationMessageHtml,'MsgTab_ ','')
set @templateNotificationMessageHtml = replace(@templateNotificationMessageHtml,'MsgNewLine_','</li><li style="margin-top: 4px; margin-bottom: 4px">')
if (@queryType=1)
begin
	IF @newTemplate=0
	BEGIN
set @templateNotificationMessageHtml = dbo.fn_EvFormatEventMsgText(0, @localeId, (1101 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0,2) + ' : '
+ dbo.fn_EvFormatEventMsgText(0, @localeId, (1102 | (CAST(POWER(2, 24) AS BIGINT) * 74)) , 0,2)
		set @templateNotificationMessageHtml = dbo.getHtmlEscapedString(@templateNotificationMessageHtml,1)+'</li>'
	END
	ELSE
set @templateNotificationMessageHtml = '<tr style="background:#f5f5f5;"><td style="padding:7px 0px 7px 20px;">' + '<font size="3" color="#444444" face="sans-serif"><b>'+dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (1101 | (CAST(POWER(2, 24) AS BIGINT) * 74)) , 0,2),1) + '</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (1102 | (CAST(POWER(2, 24) AS BIGINT) * 74)) , 0,2),1) + '</font></td></tr>'
	-- If the column supports
	if exists(select 1 from NTqueryColumnList where queryId=@queryId and columnType=1)
	begin
		IF @newTemplate=0
set @templateNotificationMessageHtml += dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (1143 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0,2),1)
		ELSE
set @templateNotificationMessageHtml += '<tr><td colspan="3" style="padding:7px 0px 7px 20px;"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (1143 | (CAST(POWER(2, 24) AS BIGINT) * 74)) , 0,2),1) + '</font></td></tr>'
	end
	IF @newTemplate=0
	BEGIN
set @templateNotificationMessageHtml += dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (1142 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0,2),1)
		set @templateNotificationMessageHtml += '<li style="margin-top: 4px; margin-bottom: 4px">'
set @templateNotificationMessageHtml += dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)),0,2) + ' : '
+ dbo.fn_EvFormatEventMsgText(0, @localeId, (182 | (CAST(POWER(2, 24) AS BIGINT) * 74)) , 0,2),1)
		set @templateNotificationMessageHtml += '</li>'
	END
	ELSE
	BEGIN
set @templateNotificationMessageHtml += '<tr><td colspan="3" style="padding:7px 0px 7px 20px;"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (1142 | (CAST(POWER(2, 24) AS BIGINT) * 74)) , 0,2),1) + '</font></td></tr>'
set @templateNotificationMessageHtml +=  '<tr><td style="padding:7px 0px 7px 20px;">' + '<font size="3" color="#444444" face="sans-serif"><b>'+SUBSTRING(dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) , 0,2),1),1,LEN(dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (245 | (CAST(POWER(2, 24) AS BIGINT) * 74)) , 0,2),1))-1)+ '</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">' + dbo.getHtmlEscapedString(dbo.fn_EvFormatEventMsgText(0, @localeId, (182 | (CAST(POWER(2, 24) AS BIGINT) * 74)) , 0,2),1) + '</font></td></tr>'
	END
end
Update #NTnotificationTemplateTemp
set defaultformatString = replace(defaultformatString,'&lt;VARIABLE TOKENS&gt;',@templateNotificationMessageHtml)
where messageFormatType = 1
-- Now for emails, save to disk etc, the text format has new lines. Whereas event viewer, SNMP etc doesnt have.
-- So we replace MsgNewLine_ and MsgTab_ appropriately
Update #NTnotificationTemplateTemp
set defaultformatString = replace(defaultformatString,'<VARIABLE TOKENS>',@templateNotificationMessage)
where messageFormatType = 0
and messageType <> 4 --NT_SNMP_ALERTNOTIF
and messageType <> 8 --NT_APPLOG_ALERTNOTIF
-- For reports queries, we use their defaults for html templates alone based on whether its health report or not.
if (@queryType=2) -- CustomQueryType::METRICS_QUERY
begin
	exec AlrmGetDefaultTemplateForAlert @queryId,@additionalDetailXml,@templateNotificationMessageHtml output, 0
	if (len(@templateNotificationMessageHtml)>0)
	begin
		Update #NTnotificationTemplateTemp
		set defaultformatString = @templateNotificationMessageHtml
		where messageFormatType = 1
	end
	if (@isHealthParam=0)
	begin
		-- Update default text template for event viewer and snmp next..
		Update #NTnotificationTemplateTemp
		set defaultformatString = defaultformatString +' , ' + '<INDEX 0>'
		where messageFormatType = 0
	end
end
Update #NTnotificationTemplateTemp
set defaultformatString = replace(defaultformatString,'<VARIABLE TOKENS>',
	replace(replace(@templateNotificationMessage,'MsgTab_ ',''),
		'MsgNewLine_',','))
where messageFormatType = 0
and messageType in (4,8) --NT_SNMP_ALERTNOTIF,NT_APPLOG_ALERTNOTIF
-- In case default template is present at query level , then use that
declare @customQueryAdditionalInfo xml
declare @customQueryDefaultHtmlTemplate nvarchar(max)
declare @customQueryDefaultTextTemplate nvarchar(max)
if ((@queryId>0) and @queryType!=1)
begin
	select @customQueryAdditionalInfo = @additionalDetailXml
	set @customQueryDefaultHtmlTemplate = IsNull(@customQueryAdditionalInfo.value('(App_AdditionalQueryDetails/@defaultHtmlTemplate)[1]','nvarchar(max)'),'')
	if (len(@customQueryDefaultHtmlTemplate)>0)
	begin
		Update #NTnotificationTemplateTemp
		set defaultformatString = @customQueryDefaultHtmlTemplate
		where messageFormatType = 1
	end
	set @customQueryDefaultTextTemplate = IsNull(@customQueryAdditionalInfo.value('(App_AdditionalQueryDetails/@defaultTextTemplate)[1]','nvarchar(max)'),'')
	if (len(@customQueryDefaultTextTemplate)>0)
	begin
		Update #NTnotificationTemplateTemp
		set defaultformatString = @customQueryDefaultTextTemplate
		where messageFormatType = 0
		and messageType in (4,8) --NT_SNMP_ALERTNOTIF,NT_APPLOG_ALERTNOTIF
	end
end
-- ----------------------------------------------------------------------------
--   BEGIN
-- ----------------------------------------------------------------------------
SELECT	1			         as TAG,
	NULL			         as Parent,
	NULL			         as [CVGui_AlertMsgsForLocaleResp!1],
	NULL					 as [msgs!2!notifType],
	NULL					 as [msgs!2!notifMessage],
	NULL					 as [msgs!2!localeID],
	NULL					 as [msgs!2!esclationLevel],
	NULL					 as [msgs!2!notifMessageHtml],
	NULL					 as [tokenList!3!tokenId],
	NULL					 as [tokenList!3!tokenFormat],
	NULL					 as [tokenList!3!flag]
UNION ALL
----------------------------------
--Load the alert type format string
----------------------------------
SELECT	2, 1, NULL,
    messageType,
    (select defaultformatString
		from #NTnotificationTemplateTemp N1
		WHERE N1.NTalertTypeID = @alertTypeId and N1.locale = @localeId and
		N1.messageType = NTnotificationTemplate.messageType
		and N1.messageFormatType=0
	),
    locale,
    1,
    (select defaultformatString
		from #NTnotificationTemplateTemp N1
		WHERE N1.NTalertTypeID = @alertTypeId and N1.locale = @localeId and
		N1.messageType = NTnotificationTemplate.messageType
		and N1.messageFormatType=1
	),
    NULL,		NULL,	NULL
	FROM NTnotificationTemplate
	WHERE
	NTalertTypeID = @alertTypeId and locale = @localeId
UNION ALL
SELECT DISTINCT	3, 1, NULL,
	NULL, NULL,NULL,NULL,NULL,
    NTOKEN.tokenID, dbo.fn_EvFormatEventMsgText(0,@localeId, NTOKEN.tokenID, 0,2), NTOKEN.flag
	FROM NTavailCriteria AS NTAC, NTAlertType as NTS,  NTmessageTokensForAlert NTOKEN
	WHERE
	NTAC.alertTypeId = NTS.id and NTOKEN.availcriteriaId = NTAC.id
	and NTS.id = @alertTypeId
--ORDER BY  [alertTypeList!3!alertTypeId], [availCriteriaList!4!id!hide], TAG
FOR XML EXPLICIT
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetDefaultTemplateForQuery')
	delete from GxQscripts where name = 'NTGetDefaultTemplateForQuery'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetDefaultTemplateForQuery')
	delete from GXDBVersions where aliasname = 'NTGetDefaultTemplateForQuery'
GO

insert into GXDBVersions values(2, 'NTGetDefaultTemplateForQuery',  '00010009001200050000', 'NTGetDefaultTemplateForQuery', '00010009001200050000')
GO

