

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetCustomAlertsToExecute.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |      Cursor:  NTGetCustomAlertsToExecute()
--  |
--  | Description:  Get all custom alerts which need to executed
--  |
--  |      Input:   ???
--  |
--  |      Output:  Get all custom alerts which need to executed
--  |
--  |      Notes:
--  |
--  |   Revisions  Author		Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.1        mnatarajan 	Initial release
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetCustomAlertsToExecute <<<'

IF EXISTS (select * from sysobjects where name='NTGetCustomAlertsToExecute')
	drop procedure NTGetCustomAlertsToExecute
IF EXISTS (select * from GxQscripts where name='NTGetCustomAlertsToExecute')
	delete from GxQscripts where name = 'NTGetCustomAlertsToExecute'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetCustomAlertsToExecute')
	delete from GXDBVersions where aliasname = 'NTGetCustomAlertsToExecute'
GO
print '... Creating Procedure: NTGetCustomAlertsToExecute'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetCustomAlertsToExecute
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--   PARAMETERS   &   OUTPUTS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
AS
  DECLARE @ntRuleId integer 
  DECLARE @ntRuleStatus integer 
  DECLARE @queryId integer 
  DECLARE @queryStatus integer
  DECLARE @queryType integer
  DECLARE @alertType integer
  DECLARE @alertCategory integer
  DECLARE @ruleQueryId integer
  DECLARE @isHealthParam integer
  DECLARE @formattingTypeSupported integer
  DECLARE @externalQueryId nvarchar(max)
  DECLARE @metricsAlertIsTile integer
  DECLARE @metricsAlertTileId integer
  DECLARE @notifOwner integer
  DECLARE @notifLocale integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @nowTime datetime
set @nowTime = GetUTCDate()
declare @NTTileProps table
(
	NTNotificationId int,
	isTileAlert int,
	tileIDForAlert int
)
Insert into @NTTileProps
select NTRule.id,0,0
from NTNotificationRule  NTRule with (nolock)
where (NTRule.status & (1|2)) = 0
update NTTileProps
set isTileAlert = cast(NTNotificationProp.attrval as int)
from @NTTileProps NTTileProps
inner join NTNotificationProp on
NTTileProps.NTNotificationId=NTNotificationProp.componentNameId
and NTNotificationProp.attrname='IsTileProp'
update NTTileProps
set tileIDForAlert = cast(NTNotificationProp.attrval as int)
from @NTTileProps NTTileProps
inner join NTNotificationProp on
NTTileProps.NTNotificationId=NTNotificationProp.componentNameId
and NTNotificationProp.attrname='TileID'
select NTRule.id,NTRule.status,NTQueryList.queryId,NTQueryList.status,
	IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@queryType)[1]','int'),1),
	IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/@alertType)[1]','int'),0),
	IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/@alertCriteria)[1]','int'),0),
	IsNull(convert(xml,NTNotificationQueryMapping.xmlInfo).value('(CVGui_QueryAdditionalInfo/externalQueryInfo/@externalQueryId)[1]','int'),0),
	IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/@isHealthParam)[1]','int'),0),
	case when (NTNotifRuleHtmlSupport.RuleId is not null and NTNotifRuleTextSupport.ruleId is null) then 2
		 when (NTNotifRuleHtmlSupport.RuleId is null  and NTNotifRuleTextSupport.ruleId is not null) then 1
		else 0
		end,
	IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/externalQueryEntity/@externalQueryId)[1]','nvarchar(max)'),''),
	IsNull(NTTileProps.isTileAlert,0),
	IsNull(NTTileProps.tileIDForAlert,0),
	NTRule.notifOwner,
	NTRule.locale
from NTQueryList with (nolock)
inner join NTNotificationQueryMapping with (nolock)
on NTNotificationQueryMapping.QueryId = NTQueryList.QueryId
inner join NTNotificationRule  NTRule with (nolock)
on NTRule.id = NTNotificationQueryMapping.NtNotificationId
inner join UMUsers on
NTRule.notifOwner=UMusers.id
left join @NTTileProps NTTileProps on
NTRule.id = NTTileProps.NTNotificationId
left join
(
	select distinct NTnotificationRule.id as ruleId
	from NTNotificationRule
	inner join NTMessageFormat on
	NTNotificationRule.id = NTMessageFormat.NTnotificationId
	and (NTMessageFormat.messageType & NTNotificationRule.notifType)>0
	and NTMessageFormat.messageFormatType = 1
) NTNotifRuleHtmlSupport on
NTRule.id = NTNotifRuleHtmlSupport.ruleId
left join
(
	select distinct NTnotificationRule.id as ruleId
	from NTNotificationRule
	inner join NTMessageFormat on
	NTNotificationRule.id = NTMessageFormat.NTnotificationId
	and (NTMessageFormat.messageType & NTNotificationRule.notifType)>0
	and NTMessageFormat.messageFormatType = 0
) NTNotifRuleTextSupport
on NTRule.id = NTNotifRuleTextSupport.ruleId
where (NTRule.status & (1|2)) = 0
and (NTQueryList.status & 1)=0 --Ignore disabled queries
and (UMUsers.enabled = 1)
-- For non scheduled alerts, We compare time. In case currentTime has passed nextRunTime we evaluate the query
-- For scheduled alerts, we check status to ensure it comes from TM properly.
and (@nowTime>=nextRunTime)
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetCustomAlertsToExecute')
	delete from GxQscripts where name = 'NTGetCustomAlertsToExecute'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetCustomAlertsToExecute')
	delete from GXDBVersions where aliasname = 'NTGetCustomAlertsToExecute'
GO

insert into GXDBVersions values(2, 'NTGetCustomAlertsToExecute',  '00000000000000000000', 'NTGetCustomAlertsToExecute', '00000000000000000000')
GO

