

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetClientOsInfo.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetClientOsInfo.sp,v $ $Id: NTGetClientOsInfo.sp,v 1.1.2.2 2018/03/27 08:59:05 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure:    NTGetClientOsInfo
--  |
--  | Description:
--  |   This will return Operating system details of a given client.
--  |
--	|
--  |
--  |   Revisions  Author              Description
--  |   ---------  -----------        -------------------------------
--  |   1.0        Nikhil Chorappan    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetClientOsInfo <<<'

IF EXISTS (select * from sysobjects where name='NTGetClientOsInfo')
	drop procedure NTGetClientOsInfo
IF EXISTS (select * from GxQscripts where name='NTGetClientOsInfo')
	delete from GxQscripts where name = 'NTGetClientOsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetClientOsInfo')
	delete from GXDBVersions where aliasname = 'NTGetClientOsInfo'
GO
print '... Creating Procedure: NTGetClientOsInfo'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetClientOsInfo
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @clientId INT
AS
  DECLARE @Name VARCHAR(MAX)
  DECLARE @Type VARCHAR(MAX)
  DECLARE @SubType VARCHAR(MAX)
  DECLARE @Version VARCHAR(MAX)
  DECLARE @PlatformType VARCHAR(MAX)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET   @Name           = ''
SET   @Type           = ''
SET   @SubType        = ''
SET   @Version        = ''
SET   @PlatformType   = ''
SELECT @Type = Type , @SubType = SubType   , @Version = Version FROM APP_Client    --  Version is not displayed anywhere
INNER JOIN SimOperatingSystem ON APP_Client.simOperatingSystemId = SimOperatingSystem.id
WHERE APP_Client.id  =  @clientId
SET @Name =  dbo.GetClientOSName(@clientId, NULL)
SET @PlatformType =  dbo.GetClientHardwareName(@clientId, NULL)
SELECT @Name , @Type, @SubType, @Version , @PlatformType
END

IF EXISTS (select * from GxQscripts where name = 'NTGetClientOsInfo')
	delete from GxQscripts where name = 'NTGetClientOsInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetClientOsInfo')
	delete from GXDBVersions where aliasname = 'NTGetClientOsInfo'
GO

insert into GXDBVersions values(2, 'NTGetClientOsInfo',  '00010001000200020000', 'NTGetClientOsInfo', '00010001000200020000')
GO

