

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetClientGroupsForClient.sp] ---------- 

/****************************************************************************************************************************************
Input: clientId, alert Id
Output:
     1. List of client groups that a client belongs to and creator of the provided alert id can see
	 2.	List of client groups that a client belongs to and creator of the provided alert id can see and that are selected in the alert
*****************************************************************************************************************************************/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTGetClientGroupsForClient')
BEGIN
	print '>>> Drop Stored Procedure: NTGetClientGroupsForClient <<<'
	drop procedure NTGetClientGroupsForClient
END
IF EXISTS (select * from GxQscripts where name='NTGetClientGroupsForClient')
	delete from GxQscripts where name = 'NTGetClientGroupsForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetClientGroupsForClient')
	delete from GXDBVersions where aliasname = 'NTGetClientGroupsForClient'
GO
print '... Creating Procedure: NTGetClientGroupsForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetClientGroupsForClient
  @clientId INT,
  @alertId INT
AS
  DECLARE @cgName NVARCHAR(1024)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	IF OBJECT_ID('tempdb.dbo.#VisibleGroups') IS NOT NULL
		DROP TABLE #VisibleGroups
	CREATE TABLE #VisibleGroups(entityId INT)
	DECLARE @userId INT = 0
DECLARE @showOnlySelectedGroups INT = ISNULL((SELECT 1 FROM GxGlobalParam WHERE name = 'nShowOnlySelectedgroups' AND value = 1),0)
EXEC sec_getCreateAsUserId 64, @alertId, @userId OUT
	IF @userId = 0
		SET @userId = ISNULL((SELECT notifOwner FROM NTNotificationRule WHERE id = @alertId),0)
	DECLARE @SelectedEntities TABLE(cgId INT, flags INT)
	DECLARE @xmlList XML = (SELECT xmlentitylist FROM NTnotificationRule WHERE id = @alertId)
EXEC sec_getNonIdaObjectsForThisUser @userId, 28, 0, '#VisibleGroups'
	INSERT INTO @SelectedEntities
	SELECT ref.value('@clientGroupId','INT'), ISNULL(ref.value('(flags/@exclude)[1]', 'INT'), 0)
	FROM @xmlList.nodes('CVGui_CommCellTreeNode/associations') R(ref)
WHERE ref.value('@_type_','int') = 28
DECLARE @allGroupsSelected INT = ISNULL((SELECT 1 FROM @xmlList.nodes('CVGui_CommCellTreeNode/associations') R(ref)	WHERE ref.value('@_type_','int') = 27),0)
	DECLARE @clientGroups TABLE(cgId INT);
	IF @allGroupsSelected = 1
	BEGIN
		INSERT INTO @clientGroups
		SELECT DISTINCT CGA.clientGroupId
		FROM App_ClientGroupAssoc CGA
		INNER JOIN #VisibleGroups VG ON VG.entityId = CGA.clientGroupId
		WHERE clientId = @clientId
		DELETE CG FROM @clientGroups CG
		INNER JOIN @SelectedEntities SE ON SE.cgId = CG.cgId AND SE.flags = 1 AND @showOnlySelectedGroups = 1
	END
	ELSE
	BEGIN
		INSERT INTO @clientGroups
		SELECT DISTINCT CGA.clientGroupId
		FROM App_ClientGroupAssoc CGA
		INNER JOIN #VisibleGroups VG ON VG.entityId = CGA.clientGroupId
		LEFT JOIN @SelectedEntities SE ON (SE.cgId = VG.entityId AND SE.flags = 0) OR @showOnlySelectedGroups = 0
		WHERE clientId = @clientId AND (SE.cgId IS NOT NULL OR @showOnlySelectedGroups = 0)
	END
	SELECT name FROM APP_ClientGroup INNER JOIN  @clientGroups ON id = cgId
END
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetClientGroupsForClient')
	delete from GxQscripts where name = 'NTGetClientGroupsForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetClientGroupsForClient')
	delete from GXDBVersions where aliasname = 'NTGetClientGroupsForClient'
GO

insert into GXDBVersions values(2, 'NTGetClientGroupsForClient',  '00000000000000000000', 'NTGetClientGroupsForClient', '00000000000000000000')
GO

