

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetAlertSeverity.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTGetAlertSeverity')
BEGIN
	print '>>> Drop Stored Procedure: NTGetAlertSeverity <<<'
	drop procedure NTGetAlertSeverity
END
IF EXISTS (select * from GxQscripts where name='NTGetAlertSeverity')
	delete from GxQscripts where name = 'NTGetAlertSeverity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetAlertSeverity')
	delete from GXDBVersions where aliasname = 'NTGetAlertSeverity'
GO
print '... Creating Procedure: NTGetAlertSeverity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetAlertSeverity
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
  @notifId integer ,            
  @escLevel integer ,
  @entities NTEXT
AS
  DECLARE @severity integer
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
-------------------
---    BEGIN    ---
-------------------
DECLARE @iDoc                   integer
DECLARE @alertTypeId            integer
DECLARE @queryId                integer
DECLARE @autoComputeSeverity    INTEGER = 0
IF @escLevel = 1
    SET @severity = (SELECT ruleState FROM NTNotificationRule WHERE id = @notifId)
ELSE
    SET @severity = (SELECT ruleState2 FROM NTNotificationRule WHERE id = @notifId)
IF @severity = 0
    SET @autoComputeSeverity = 1
IF @autoComputeSeverity = 1
BEGIN
   IF object_id('tempdb.dbo.#entityList') is not null
   DROP TABLE #entityList
	CREATE TABLE #entityList
	(
		msgIndex        int,
		tokenId         int,
		tokenVal        nvarchar(max),
		msgIndexNew     int
	)
   EXEC sp_xml_preparedocument @iDoc OUTPUT, @entities
   INSERT INTO  #entityList (msgIndex, tokenId, tokenVal,msgIndexNew)
   SELECT id, tokenId, dbo.decodeInvalidXmlChar(val),id
   FROM OPENXML(@iDoc, 'CVGui_DetectedAlertsDataDetails/tokVal/tokenValueList', 0)
   WITH (id int '../../@index', tokenId int '../@tokenId' , val nvarchar(max) '@val' )
   SET @alertTypeId = (SELECT alertTypeId FROM NTNotificationRule WHERE id = @notifId)
   IF @alertTypeId = 58
   BEGIN
		DECLARE @severityList TABLE(severity NVARCHAR(1024))
        INSERT INTO @severityList
SELECT tokenVal FROM #entityList WHERE tokenId = (923 | (CAST(POWER(2, 24) AS BIGINT) * 74))
        IF EXISTS ( SELECT 1 FROM @severityList WHERE severity = 'Critical')
            SET @severity = 1
        ELSE IF EXISTS (SELECT 1 FROM @severityList WHERE severity = 'Minor' OR severity = 'Major')
            SET @severity = 2
        ELSE
            SET @severity = 3
       if object_id('tempdb.dbo.#entityList') is not null
       DROP TABLE #entityList
   END
ELSE IF @alertTypeId = 65
   BEGIN
        SELECT @queryId = queryId  FROM NTNotificationQueryMapping WHERE NTNotificationId  =  @notifId
        set @severity = 3
        select @severity = IsNull(convert(xml,NTQueryList.xmlInfo).value('(App_AdditionalQueryDetails/@querySeverity)[1]','int'),3)
        from NTQueryList where queryId = @queryId
   END
   ELSE
   BEGIN
		DECLARE @criteriaIds TABLE (  criteriaId INT  )
        INSERT INTO @criteriaIds
		SELECT NTcriteria.id
		FROM #entityList
		INNER JOIN NTcriteria
		ON NTcriteria.nameID = tokenVal
WHERE tokenId = (14 | (CAST(POWER(2, 24) AS BIGINT) * 74))
        SET @severity = ISNULL(
		                        (
		                         SELECT TOP 1 MIN(severitynameid) FROM NTAvailCriteriaSeverity
								 INNER JOIN ntavailCriteria  ON ntavailCriteria.id = ntavailCriteriaSeverity.availCriteriaId
								 INNER JOIN @criteriaIds AS criteriaids ON criteriaids.criteriaId = ntavailCriteria.criteriaid
								 WHERE ntavailCriteria.alertTypeId = @alertTypeId
								),  3)
   END
    if (@severity=0)
    begin
        set @severity = 3
    end
END
SELECT @severity

IF EXISTS (select * from GxQscripts where name = 'NTGetAlertSeverity')
	delete from GxQscripts where name = 'NTGetAlertSeverity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetAlertSeverity')
	delete from GXDBVersions where aliasname = 'NTGetAlertSeverity'
GO

insert into GXDBVersions values(2, 'NTGetAlertSeverity',  '00000000000000000000', 'NTGetAlertSeverity', '00000000000000000000')
GO

