

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetAlertDetailsForClientProcessing.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetAlertDetailsForClientProcessing.sp,v $ $Id: NTGetAlertDetailsForClientProcessing.sp,v 1.1.2.6 2019/09/12 20:17:25 pkumar Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   NTGetAlertDetailsForClientProcessing   - Fetch alert details for mongo client processing.
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTGetAlertDetailsForClientProcessing')
BEGIN
	print '>>> Drop Stored Procedure: NTGetAlertDetailsForClientProcessing <<<'
	drop procedure NTGetAlertDetailsForClientProcessing
END
IF EXISTS (select * from GxQscripts where name='NTGetAlertDetailsForClientProcessing')
	delete from GxQscripts where name = 'NTGetAlertDetailsForClientProcessing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetAlertDetailsForClientProcessing')
	delete from GXDBVersions where aliasname = 'NTGetAlertDetailsForClientProcessing'
GO
print '... Creating Procedure: NTGetAlertDetailsForClientProcessing'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetAlertDetailsForClientProcessing
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlData xml OUTPUT
AS
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  BEGIN
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @outputXml XML
DECLARE @isForFailover INT = 0
DECLARE @commcellName NVARCHAR(512)
SET @isForFailover = ISNULL ( (SELECT ref.value('@isForFailover', 'INT') AS Agent
      FROM    @xmlData.nodes('CVGui_GetAlertDetailForClient') R ( ref )),0)
SELECT @commcellName = aliasName FROM App_Commcell WHERE Id =2 -- DEFAULT_COMMCELL_ID
IF @isForFailover = 0
BEGIN
	SET @outputXml = (SELECT NTNotificationRule.id 'alert/alert/@id',
			NTAlertType.id 'alert/alertType/@id',
			(
				SELECT NTSelCriteria.availCriteriaid '@criteriaId',
					(
						SELECT NTSelCriteriaParams.value '@value'
						FROM NTSelCriteriaParams WHERE
						NTSelCriteriaParams.selCriteriaId=NTSelCriteria.Id
						for xml path('criteriaParams'),type
					)
				FROM NTSelCriteria
				WHERE NTSelCriteria.ruleId=NTNotificationRule.id
				for xml path('criteria'),type
			),
			locale 'locale/@localeID'
		 FROM NTNotificationRule INNER JOIN NTAlertType on NTAlertType.id = NTNotificationRule.alertTypeId
AND (NTAlertType.actionsAllowed& 64 )>0
AND (NTNotificationRule.status& (1|2|512 ))=0
		 for xml path('alertDetailList'),root('CVGui_GetAlertDetailForClientResp')
	)
END
ELSE
BEGIN
	DECLARE @notifRuleID INT
	if object_id('tempdb.dbo.#notifRecipientsList') is not null
	BEGIN
		DROP TABLE #notifRecipientsList
	END
	DECLARE @alertStaticInfoResp XML
	SET @alertStaticInfoResp = ( SELECT id '@alertTypeId',name '@alertTypeName',nameID '@alertTypeNameId', categoryId '@alertCategoryId',
			notifTypesAllowed '@notifTypesAllowed', actionsallowed '@actionsAllowed', description '@alertDescription',
			-- Not passing entity since it wont be used by client.
				(
					SELECT criteriaId '@criteriaId',reportingOptions '@reportOption',
						escReportingOptions '@escReportOption', defaultSelection '@defaultSelection',
						NTCriteria.nameID '@criteriaNameId',
						(
							SELECT tokenId '@tokenId',tokenInputformat '@tokenFormat',flag '@flag',tokenType '@tokenType'
							FROM NTMessageTokensForAlert
							WHERE NTMessageTokensForAlert.availCriteriaID = NTAvailCriteria.id
							FOR XML PATH('tokenList'),type
						)
					FROM NTAvailCriteria
					INNER JOIN NTCriteria ON NTAvailCriteria.criteriaId = NTCriteria.id
					WHERE NTAvailCriteria.alertTypeID = NTAlertType.id
					FOR XML PATH('availCriteriaList'),type
				)
FROM NTAlertType WHERE (NTAlertType.actionsAllowed & 1024 )>0
			FOR XML PATH('alertTypeList'),root('alertStaticInfoResp')
	)
	DECLARE @alertCategory XML
	SET @alertCategory = (SELECT Id '@id',name '@name'
	FROM NTCategory
	FOR XML PATH('alertCategoryList'))
	SET @alertStaticInfoResp.modify('insert sql:variable("@alertCategory") into (alertStaticInfoResp)[1]')
	CREATE TABLE #notifRecipientsList (
		NTnotificationId INTEGER NOT NULL,
		Email       nvarchar(510) ,
		recipientType   int default 0
		PRIMARY KEY(NTnotificationId,recipientType,Email)
	)
	IF object_id('tempdb.dbo.#notifSenderInfo') is not null
	BEGIN
		DROP TABLE #notifSenderInfo
	END
	CREATE TABLE #notifSenderInfo (
		NTnotificationId INTEGER NOT NULL,
		senderEmail       nvarchar(510),
		senderDisplayName   nvarchar(510)
		PRIMARY KEY(NTnotificationId)
	)
	-- Get the alert details
	IF ( CURSOR_STATUS('global', 'alertCursor') >= 0   OR CURSOR_STATUS('local', 'alertCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE alertCursor
	IF ( CURSOR_STATUS('global','alertCursor') = -1     OR CURSOR_STATUS('local','alertCursor') = -1 )
		DEALLOCATE alertCursor
	DECLARE alertCursor CURSOR
	FOR SELECT NTNotificationRule.id
		 FROM NTNotificationRule INNER JOIN NTAlertType on NTAlertType.id = NTNotificationRule.alertTypeId
AND (NTAlertType.actionsAllowed& 1024 )>0
AND (NTNotificationRule.status& (1|2|512 ))=0
		 INNER JOIN NTMessageFormat ON NTNotificationRule.ID = NTMessageFormat.NTnotificationID
		 AND NTMessageFormat.messageType = 1 -- Email notification should be selected for it to be sent to client.
	OPEN alertCursor
	FETCH alertCursor INTO @notifRuleID
	WHILE @@FETCH_STATUS = 0
	BEGIN
		DECLARE @userRecipientListTbl table
		(
			emailList          NVARCHAR(MAX),
			noemailList        NVARCHAR(MAX),
			loginList          NVARCHAR(MAX),
			userIdList         NVARCHAR(MAX),
			ccEmailList        NVARCHAR(MAX),
			bccEmailList       NVARCHAR(MAX),
			phoneNumList	   NVARCHAR(MAX)
		)
		DELETE FROM @userRecipientListTbl
		DECLARE @emailList NVARCHAR(MAX)
		DECLARE @ccEmailList NVARCHAR(MAX)
		DECLARE @bccEmailList NVARCHAR(MAX)
		INSERT INTO @userRecipientListTbl
		exec NTGetUserListForRule @notifRuleID, 1,'','',1
		SELECT @emailList = emailList,@ccEmailList = ccEmailList, @bccEmailList = bccEmailList
		FROM @userRecipientListTbl
		INSERT INTO #notifRecipientsList(NTnotificationId,Email,recipientType)
		SELECT @notifRuleID ,Data , 0
		FROM dbo.splitString(@emailList,';')
		UNION
		SELECT @notifRuleID ,Data, 1
		FROM dbo.splitString(@ccEmailList,';')
		UNION
		SELECT @notifRuleID , Data, 2
		FROM dbo.splitString(@bccEmailList,';')
		-- IF alert has recipient information, then use that
		IF NOT EXISTS(select 1 from NTNotificationProp where componentNameId=@notifRuleID
and attrName = 'Sender MailId' and modified=0)
		AND NOT EXISTS(select 1 from NTNotificationProp where componentNameId=@notifRuleID
and attrName = 'Sender Display Name' and modified=0)
		BEGIN
			DECLARE @allEmailList NVARCHAR(MAX)
			SET @allEmailList = @emailList + @ccEmailList + @bccEmailList
			set @allEmailList = (SELECT @allEmailList AS '@recipientEmailAddresses' FOR XML PATH('App_GetSenderForRecipientsReq'));
			DECLARE @senderEmailInfo table
			(
				senderEmailXML          xml
			)
			INSERT INTO @senderEmailInfo
			exec dbo.AppGetSenderForRecipients @allEmailList
			Declare @senderEmail nvarchar(max), @displayname nvarchar(max)
			Declare @emailInfoXml xml;
			select @emailInfoXml = senderEmailXML from @senderEmailInfo
			SELECT	@senderEmail = ISNULL((ref.value('@emailAddress', 'nvarchar(max)')), ''),
			@displayname = ISNULL((ref.value('@displayName', 'nvarchar(max)')), '')
			FROM @emailInfoXml.nodes('/App_Email') R(ref)
			INSERT INTO #notifSenderInfo
			SELECT @notifRuleID, @senderEmail, @displayname
		END
		FETCH alertCursor INTO @notifRuleID
	END
	CLOSE alertCursor
	DEALLOCATE alertCursor
	-- Fill the alert details.
	SET @outputXml = (SELECT CONVERT(NVARCHAR(MAX),NTNotificationRule.xmlEntityList) '@xmlEntityList',
			NTNotificationRule.ruleState '@alertSeverity',
			NTNotificationRule.ruleState2 '@escalationSeverity',
			(SELECT attrVal from NTNotificationProp where componentNameId = NTNotificationRule.id
and attrName = 'Sender MailId' and modified=0
			 UNION
			 SELECT senderEmail FROM #notifSenderInfo WHERE NTnotificationId = NTNotificationRule.id
			) as '@senderEmailId',
			(SELECT attrVal from NTNotificationProp where componentNameId = NTNotificationRule.id
and attrName = 'Sender Display Name' and modified=0
				UNION
				SELECT senderDisplayName FROM #notifSenderInfo WHERE NTnotificationId = NTNotificationRule.id
			) as '@senderDisplayName',
			NTNotificationRule.id 'alert/alert/@id',
			NTNotificationRule.notificationName 'alert/alert/@name',
			NTNotificationRule.notifType 'alert/alert/@notifType',
			NTNotificationRule.status	'alert/alert/@status',
			NTNotificationRule.origCCId 'alert/alert/@origCCId',
			NTNotificationRule.GUID 'alert/alert/@GUID',
			NTAlertType.id 'alert/alertType/@id',
			(
				SELECT NTSelCriteria.availCriteriaid '@criteriaId',
					(
						SELECT TOP 1 MIN(severitynameid) FROM NTAvailCriteriaSeverity
								 INNER JOIN NTAvailCriteria  ON NTAvailCriteria.id = NTAvailCriteriaSeverity.availCriteriaId
								 AND NTSelCriteria.availCriteriaId = NTAvailCriteria.criteriaid
								 WHERE NTAvailCriteria.alertTypeId = NTNotificationRule.alertTypeId
						) '@criteriaSeverity' , -- Send the criteria severity also so that client can decide severity when it sends alert.
					(
						SELECT NTSelCriteriaParams.value '@value'
						FROM NTSelCriteriaParams WHERE
						NTSelCriteriaParams.selCriteriaId=NTSelCriteria.Id
						for xml path('criteriaParams'),type
					)
				FROM NTSelCriteria
				WHERE NTSelCriteria.ruleId=NTNotificationRule.id
				for xml path('criteria'),type
			),
			locale 'locale/@localeID',
			(
				SELECT Email '@nonGalaxyUser', 1 '@escalationLevel',
					RecipientType '@recipientType' FROM #notifRecipientsList
				WHERE NTNotificationID = NTNotificationRule.Id
				FOR XML PATH('recipientsList'),type
			),
			(
				SELECT DISTINCT NTMessageTokensForAlert.tokenId '@tokenId',
					NTMessageTokensForAlert.flag '@flag',
					NTMessageTokensForAlert.tokenType '@tokenType'
				FROM NTMessageTokensForAlert
				INNER JOIN NTAvailCriteria ON NTMessageTokensForAlert.availCriteriaId =
				NTAvailCriteria.ID AND NTAvailCriteria.alertTypeId = NTAlertType.id
				WHERE NTNotificationID = NTNotificationRule.Id
				FOR XML PATH('tokensForAlert'),type
			),
			(
				SELECT messageType '@notifType', formatString '@notifMessage', NTNotificationRule.locale '@localeId',mfOptions '@notifOptions',
					escalationLevel '@esclationLevel',messageFormatType '@messageFormat', formatStringHtml '@notifMessageHtml'
				FROM NTMessageFormat
				WHERE NTMessageFormat.NTnotificationID = NTNotificationRule.ID
				AND NTMessageFormat.messageType = 1 -- Email notification should be selected for it to be sent to client.
				FOR XML PATH('notifMsgs'),type
			)
		 FROM NTNotificationRule INNER JOIN NTAlertType on NTAlertType.id = NTNotificationRule.alertTypeId
AND (NTAlertType.actionsAllowed& 1024 )>0
AND (NTNotificationRule.status& (1|2|512 ))=0
		 INNER JOIN NTMessageFormat ON NTNotificationRule.ID = NTMessageFormat.NTnotificationID
		 AND NTMessageFormat.messageType = 1 -- Email notification should be selected for it to be sent to client.
		 FOR XML PATH('alertDetailList'),root('CVGui_GetAlertDetailForClientResp')
	)
	-- Modify xml response to include alert properties also
	IF @outputXml IS NOT NULL
	BEGIN
		SET @outputXml.modify('insert sql:variable("@alertStaticInfoResp") into (CVGui_GetAlertDetailForClientResp)[1]')
		-- Add commcell name also here so that we can use it.
		SET @outputXml.modify('insert (attribute commcellName {sql:variable("@commcellName")} ) into (CVGui_GetAlertDetailForClientResp)[1]')
	END
END
IF @outputXml IS NULL
BEGIN
	SET @outputXml='<CVGui_GetAlertDetailForClientResp/>'
END
SET @xmlData = @outputXml
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'NTGetAlertDetailsForClientProcessing')
	delete from GxQscripts where name = 'NTGetAlertDetailsForClientProcessing'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetAlertDetailsForClientProcessing')
	delete from GXDBVersions where aliasname = 'NTGetAlertDetailsForClientProcessing'
GO

insert into GXDBVersions values(2, 'NTGetAlertDetailsForClientProcessing',  '00010001000200060000', 'NTGetAlertDetailsForClientProcessing', '00010001000200060000')
GO

