

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTGetActionBaseURL.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTGetActionBaseURL.sp,v $ $Id: NTGetActionBaseURL.sp,v 1.1.2.5 2018/03/27 08:59:51 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: NTGetWorkFlowURL
--  |
--  | Description:
--  |   This procedure will give param name and param value pointing to given
--  |   workflow entity with its given input
--	|
--  |
--  |   Revisions  Author              Description
--  |   ---------  -----------        -------------------------------
--  |   1.0        Nikhil Chorappan    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTGetActionBaseURL <<<'

IF EXISTS (select * from sysobjects where name='NTGetActionBaseURL')
	drop procedure NTGetActionBaseURL
IF EXISTS (select * from GxQscripts where name='NTGetActionBaseURL')
	delete from GxQscripts where name = 'NTGetActionBaseURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetActionBaseURL')
	delete from GXDBVersions where aliasname = 'NTGetActionBaseURL'
GO
print '... Creating Procedure: NTGetActionBaseURL'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTGetActionBaseURL
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @actionEntity XML ,
  @input XML ,
  @webConsoleURL NVARCHAR(MAX)
AS
  DECLARE @paramName NVARCHAR(32)
  DECLARE @paramValue NVARCHAR(1024)
BEGIN
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @type             int
DECLARE @workFlowName     NVARCHAR(MAX)
DECLARE @workflowId       INT
DECLARE @reportName       NVARCHAR(MAX)
DECLARE @reportId         INT
DECLARE @inputsInUrlFormat NVARCHAR(MAX) = ''
DECLARE @workflowURL    NVARCHAR(MAX) = ''
DECLARE @reportURL      NVARCHAR(MAX) = ''
SELECT
   @type         = ISNULL(ref.value('@_type_','INT'),0),
   @reportId     = ISNULL(ref.value('@customReportId','INT'),0),
   @reportName   = ISNULL(ref.value('@customReportName','NVARCHAR(MAX)'),0),
   @workflowId   = ISNULL(ref.value('@workflowId','INT'),0),
   @workFlowName = ISNULL(ref.value('@workflowName','NVARCHAR(MAX)'),0)
FROM @actionEntity.nodes ('CvEntities_GenericEntity') R(ref)
SELECT
	 Level1.value('local-name(.)', 'varchar(50)') ,
	CASE
		WHEN Level2.value('(.)', 'nvarchar(50)') is not null
			THEN Level2.value('(.)', 'nvarchar(50)')
		ELSE
		    Level1.value('(.)', 'nvarchar(50)')
	END
FROM @input.nodes('/inputs/*') AS A(Level1)
outer apply Level1.nodes('*[1]') AS B(Level2);
END

IF EXISTS (select * from GxQscripts where name = 'NTGetActionBaseURL')
	delete from GxQscripts where name = 'NTGetActionBaseURL'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTGetActionBaseURL')
	delete from GXDBVersions where aliasname = 'NTGetActionBaseURL'
GO

insert into GXDBVersions values(2, 'NTGetActionBaseURL',  '00010001000200050000', 'NTGetActionBaseURL', '00010001000200050000')
GO

