

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTDpruneOldAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTDpruneOldAlerts.sp,v $ $Id: NTDpruneOldAlerts.sp,v 1.13.12.7 2020/03/23 18:59:05 mnatarajan Exp $";
--
--  +========================================================================+
--  |   Procedure:  NTDpruneOldAlerts()
--  |
--  | Description:  Retrieves the Commcell Schedules
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        mali     Initial Edit
--  +========================================================================+
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='NTDpruneOldAlerts')
BEGIN
	print '>>> Drop Stored Procedure: NTDpruneOldAlerts <<<'
	drop procedure NTDpruneOldAlerts
END
IF EXISTS (select * from GxQscripts where name='NTDpruneOldAlerts')
	delete from GxQscripts where name = 'NTDpruneOldAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDpruneOldAlerts')
	delete from GXDBVersions where aliasname = 'NTDpruneOldAlerts'
GO
print '... Creating Procedure: NTDpruneOldAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTDpruneOldAlerts
-- Procedure Input
  @id1 integer,
  @id2 integer
-- following are the "columns" returned, in the order in which they are returned
AS
  DECLARE @errCode integer
--:DECLARE	errString		varchar(1024)   -- Would be nice to have, but would require DLL changes too
SET NOCOUNT ON
Declare @rowsInTable	int
Declare @rowsToDelete	int
DECLARE	@retVal			AS integer = 0
DECLARE @tmpVar			nvarchar(max)
DECLARE @errorString	AS varchar(2048) = ''
BEGIN TRY
	SET @tmpVar = ISNULL((Select value FROM GXGlobalParam WITH(NOLOCK) WHERE Name = 'Notification Skip Check' AND Modified = 0), N'0')
	DECLARE @skipCheck  as integer = CONVERT(int, @tmpVar)
	--
	Declare @staleAlertsPeriod AS integer = 5
	Select @staleAlertsPeriod = value FROM GXGlobalParam WITH(NOLOCK) WHERE Name = 'Stale Notification Interval' and modified=0
	if @staleAlertsPeriod is null OR @staleAlertsPeriod<=0
	begin
		set @staleAlertsPeriod = 5
	end
	-- job status
DECLARE @exceededRunTime	INT = 67	-- 67
DECLARE @pendingState		INT = 73			-- 73
	DECLARE @Time30MinsBeforeCurrTime DATETIME = DATEADD(second, -30 * 60, GETDATE())
	DECLARE @staleNotifDuration		  DATETIME = DATEADD(day, -1 * @staleAlertsPeriod, GETDATE())
	-- Now in case we have set option to alert only when certain no of entries occur after 2 hrs.
	-- Now SetStatus_Detected is called at the end of each method. processStat=1 indicates the record is entered completely and is now ready for processing.
	-- In case of errors in entering new NTDetectedAlerts entry, by default processStat would be 0. In order for it to be considered, we set processStat = 1 after 30 mins
	-- processingType has been added below in table  #NTDPruneEvents  below to avoid querying NTDetectedAlerts table again. This can take UPDLock again on NTDetectedAlerts table and can result in deadlock.
	-- 1 means set status detected isnt called still. So we set processStat to 1 here.
	-- 2 means delete entries when processStat is set to 8
	-- 3 means Delete job exceeded run time alerts where job isnt running.
	-- 4 means processing in jobs in pending state alert where owner isnt there
	-- 5 means processing based on notification skip check for stale alerts.
	-- Acquire update locks on clustered index for selected events
	IF OBJECT_ID('tempdb.dbo.#NTDPruneEvents') IS NOT NULL
		 DROP TABLE #NTDPruneEvents
	CREATE TABLE #NTDPruneEvents (eventId INTEGER, processingType INT PRIMARY KEY(processingType,eventId) )
	INSERT INTO #NTDPruneEvents
		SELECT	-- UPDATE1
			a.eventId,1
		FROM
			NTDetectedAlerts a WITH(UPDLOCK, INDEX(0))
		WHERE
			a.processStat IN (0,128)		--  0x80: 128 In case its either not entered or it still has eAlertStatusVSASubclient
			AND a.processTime < @Time30MinsBeforeCurrTime
		UNION
		SELECT	-- DELETE1, DELETE2
			a.eventId , 2
		FROM
			NTDetectedAlerts a WITH(UPDLOCK, INDEX(0))
		WHERE
			(@skipCheck & 3) <> 3			-- Not Skipping, so acquire lock
			AND a.processStat = 8
		UNION
		SELECT	-- UPDATE2
			a.eventId, 3
		FROM
			NTDDpDr d WITH(NOLOCK)
			INNER JOIN NTDetectedAlerts a WITH(UPDLOCK, INDEX(0)) ON
				d.jobId_l NOT IN (SELECT jobId FROM JMJobInfo WITH(NOLOCK))
				AND d.eventId = a.eventId
				AND a.processStat <> 0		-- So that we prune entries which have been completely entered in DB
				AND a.criteria = @exceededRunTime
		UNION
		SELECT	-- UPDATE3
			a.eventId, 4
		FROM
			NTDetectedAlerts a WITH(UPDLOCK, INDEX(0))
		WHERE
			a.processStat <> 0		-- So that we prune entries which have been completely entered in DB
			AND a.criteria = @pendingState
			AND a.ntNotificationId NOT IN (
				-- Retrieve list of all owners who have created alert with this criteria.
				SELECT DISTINCT
					NTR.id
				FROM
					NTnotificationRule NTR WITH(NOLOCK)
					INNER JOIN NTSelCriteria WITH(NOLOCK) ON
						NTSelCriteria.ruleId = NTR.id
						AND NTSelCriteria.availCriteriaId = @pendingState
				where
					notifOwner <> -10
					AND (NTR.status & (1|2)) = 0 --NT_STATUS_DISABLED|NT_STATUS_DELETED
			)
		UNION
		SELECT	-- DELETE3
			a.eventId , 5
		FROM
			NTDetectedAlerts a WITH(UPDLOCK, INDEX(0))
		WHERE
			(@skipCheck & 3) <> 3			-- Not Skipping, so acquire lock
			AND a.processTime < @staleNotifDuration
			AND a.criteria != @exceededRunTime
	-- Doing delete op first to avoid doing unnecessary UPDATE OP on entries which are going to be deleted anyways. Also grouping for processingTYpe 2 and 5 together.
	IF ( @skipCheck & 3) != 3           -- SKIP ALL CHECKS
	BEGIN
		-- Job can run for any no of time. We will prune this entry only when the job is completed.
		-- DELETE3
		DELETE NTDetectedAlerts
		FROM NTDetectedAlerts inner join #NTDPruneEvents e on NTDetectedAlerts.eventId = e.eventId -- Only delete rows where update locks have been acquired, others rows have to wait until next SPs execution (avoid deadlocks)
		AND e.processingType IN (2,5)
			-- For debugging we can always set notification skip check to 3 since its internal key for alerts debugging.
		DELETE FROM NTDBDetectedAlert where processStat  = 1 --  Remove all processed alerts from the db alerts table.
	END
	-- Now set entries which are still set to 0 to 1 after 30 mins
	-- UPDATE1
	-- Now if a job is no longer present, we update the processstat to 8. So that it isnt processed if Notification skip check registry key is present.
	-- And it gets deleted if the above key isnt present.
	-- UPDATE2
	-- For criteria _NT_JOBS_PENDING_STATE, if user has selected it before and then removed the selection or deleted the alert itself
	-- then remove the detectedalert for him.
	-- UPDATE3
	-- Also grouping for processingType 1,3 and 4 together so that its done in single pass.
	UPDATE NTDetectedAlerts
		SET processStat = CASE WHEN processingType = 1  THEN 1 ELSE 8 END
	FROM NTDetectedAlerts INNER JOIN #NTDPruneEvents e
	ON NTDetectedAlerts.eventId = e.eventId -- Only update rows where update locks have been acquired, others rows have to wait until next SPs execution (avoid deadlocks)
	AND e.processingType IN (1,3,4)
	-- No need to delete rows from NTDetectedAlerts based on maxEventscount. Because of this, events with processStat 0 and 1 are considered for deletion.
	-- All valid events for deletion are considered above.
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @retVal	 = ERROR_NUMBER()
	SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
END CATCH
NT_PRUNE_EXIT:
SELECT	@retVal   --, @errorString
RETURN
-- Tell the AWK processor that there are no more input lines to scan
GO
--- exec NTDpruneOldAlerts 0, 0

IF EXISTS (select * from GxQscripts where name = 'NTDpruneOldAlerts')
	delete from GxQscripts where name = 'NTDpruneOldAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDpruneOldAlerts')
	delete from GXDBVersions where aliasname = 'NTDpruneOldAlerts'
GO

insert into GXDBVersions values(2, 'NTDpruneOldAlerts',  '00010013001200070000', 'NTDpruneOldAlerts', '00010013001200070000')
GO

