

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTD_MatchConsecutiveJobFailureAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--  Author: Ankur Varsheny
--  Date:   01/29/2013
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTD_MatchConsecutiveJobFailureAlert.sp,v $ $Id: NTD_MatchConsecutiveJobFailureAlert.sp,v 1.2.86.1 2018/03/27 09:00:36 jiechen Exp $";
--This procedure check if a job completed with errors for a give subclient consecutively for @count number of times.
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTD_MatchConsecutiveJobFailureAlert <<<'

IF EXISTS (select * from sysobjects where name='NTD_MatchConsecutiveJobFailureAlert')
	drop procedure NTD_MatchConsecutiveJobFailureAlert
IF EXISTS (select * from GxQscripts where name='NTD_MatchConsecutiveJobFailureAlert')
	delete from GxQscripts where name = 'NTD_MatchConsecutiveJobFailureAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTD_MatchConsecutiveJobFailureAlert')
	delete from GXDBVersions where aliasname = 'NTD_MatchConsecutiveJobFailureAlert'
GO
print '... Creating Procedure: NTD_MatchConsecutiveJobFailureAlert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure NTD_MatchConsecutiveJobFailureAlert
  @i_subClientId integer,
  @i_selCriteriaId integer,
  @i_eventId integer
AS
  DECLARE @retVal integer;
  DECLARE @failedJobsInfo nvarchar(max);
DECLARE @count  integer
DECLARE @errorCode  integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @retVal     = 0
set @errorCode  = 0
set @failedJobsInfo = '<App_ConsecutiveJobFailureMatchInfo/>'
-- THIS IS THE FIRST TIME THIS EVENT OCCURRED: ----
SELECT @count = value
    FROM NTSelCriteriaParams
    WHERE selCriteriaId = @i_selCriteriaId
SET @errorCode = @@Error
IF @errorCode <> 0 OR @count is null OR @count = 0
        GOTO RETURN_PROC
declare @currentJobID int
declare @alertLocaleId int
select @currentJobID = jobId_l from NTDdpDr
where eventId = @i_eventId
if @currentJobID is null
begin
	-- Job id is null.. This shldnt be the case. Lets not match
	GOTO RETURN_PROC
end
select @alertLocaleId = locale
from NTNotificationRule NTR inner join NTSelCriteria SelC on
NTR.id = SelC.ruleId
and selC.id = @i_selCriteriaId
if @alertLocaleId is null
begin
	set @alertLocaleId = 0
end
DECLARE @lastNJobs TABLE(
	jobId BigINT,
	status int,
	startTime int,
	endTime int,
	errorCode nchar(10),
	failureReason nvarchar(max)
)
-- Look only for jobs for this subclient before the current job finished.
-- Jobs which are failed to start shouldnt be considered in looking for this successive failures.
INSERT INTO @lastNJobs
SELECT TOP(@count) jobId,status,servStartDate,servEndDate,'',failureReason from JMBkpStats with (nolock) where appId=@i_subClientId and status!=9 --_CVJobStatus::DROPPED
and jobId<=@currentJobID and commcellId = 2
order by jobId desc
DECLARE @foundErrorCount INT = (SELECT COUNT(Distinct LastNjobs.jobid ) FROM @lastNJobs LastNjobs
		where LastNjobs.status in (2,3,4,14,15)) -- (_CVJobStatus::Fail,_CVJobStatus::PARTIALSUCCESS,_CVJobStatus::KILLED,_CVJobStatus::JMSUCCESSWITHWARNINGS,_CVJobStatus::SYSTEMFAILED)
IF (@count = @foundErrorCount)
	SET @retVal = 1
if @retVal =0
begin
	-- No match. No point proceeding further
	GOTO RETURN_PROC
end
Update LastNJobs
set LastNJobs.failureReason = dbo.JMGetLocalizedMessageFunc(@alertLocaleId,LastNJobs.failureReason)
from @lastNJobs LastNJobs
set @failedJobsInfo = (select JobId '@jobId',startTime '@startTime',endTime '@endTime',failureReason '@failureReason',status '@status' from @lastNJobs LastNJobsInfo
	for xml path('failedJobInfo'),root('App_ConsecutiveJobFailureMatchInfo'))
RETURN_PROC:
if @failedJobsInfo is null
begin
	set @failedJobsInfo = '<App_ConsecutiveJobFailureMatchInfo/>'
end
SELECT   @retVal,@failedJobsInfo
RETURN   @errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'NTD_MatchConsecutiveJobFailureAlert')
	delete from GxQscripts where name = 'NTD_MatchConsecutiveJobFailureAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTD_MatchConsecutiveJobFailureAlert')
	delete from GXDBVersions where aliasname = 'NTD_MatchConsecutiveJobFailureAlert'
GO

insert into GXDBVersions values(2, 'NTD_MatchConsecutiveJobFailureAlert',  '00010002008600010000', 'NTD_MatchConsecutiveJobFailureAlert', '00010002008600010000')
GO

