

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTDProcessStickyAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTDProcessStickyAlerts.sp,v $ $Id: NTDProcessStickyAlerts.sp,v 1.4.60.2 2018/03/20 00:41:35 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  NTDProcessStickyAlerts()
--  |
--  | Description:  Retrieves the Commcell Schedules
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        mnatarajan     Initial Edit
--  +========================================================================+
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTDProcessStickyAlerts <<<'

IF EXISTS (select * from sysobjects where name='NTDProcessStickyAlerts')
	drop procedure NTDProcessStickyAlerts
IF EXISTS (select * from GxQscripts where name='NTDProcessStickyAlerts')
	delete from GxQscripts where name = 'NTDProcessStickyAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDProcessStickyAlerts')
	delete from GXDBVersions where aliasname = 'NTDProcessStickyAlerts'
GO
print '... Creating Procedure: NTDProcessStickyAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTDProcessStickyAlerts
-- Procedure Input
-- following are the "columns" returned, in the order in which they are returned
AS
SET NOCOUNT ON
declare @configId int
declare @criteria int
declare @alertType int
declare @status int
declare @suppressionOpType nvarchar(max)
declare @query nvarchar(max)
declare @alertsToBeProcessed table
(
	entity xml,
	entityType nvarchar(max) ,
	entityId nvarchar(max),
	entityName nvarchar(max) ,
	isConditionCleared bit	,
	alertType int ,
	alertCriteria int ,
	subStoreId	int,
	storeId int
)
declare @tempResultsForEachQuery table
(
	entity xml ,
	entityType nvarchar(max) ,
	entityId nvarchar(max) ,
	entityName nvarchar(max),
	subStoreId	int,
	storeId int
)
-- In case there are no active alerts with these criterias selected, then SP returns empty
-- Otherwise Alerts framework doesnt add and we keep sending same data again and again as new.
if not exists(
		select * from NTSelCriteria NTSel with (nolock)
		inner join NTNotificationRule  NTRule with (nolock)
		on NTRule.id = NTsel.ruleid
where availCriteriaid=70
and (NTRule.status & (1|2)) = 0
	)
	begin
		goto END_ITEM_SP
	end
--Close and deallocate the cursor if it is already open
IF ( CURSOR_STATUS(N'global', N'stickyAlertsCursor') >= 0  /* cursor is open */
OR CURSOR_STATUS(N'local', 'stickyAlertsCursor') >= 0 )
	CLOSE stickyAlertsCursor
IF ( CURSOR_STATUS('global','stickyAlertsCursor') = -1  /* cursor is closed */
OR CURSOR_STATUS('local','stickyAlertsCursor') = -1 )
	DEALLOCATE stickyAlertsCursor
DECLARE stickyAlertsCursor cursor for
select configId,criteria,alertType,status,suppressionOpType,query
from NTStickyAlertsConfig with (nolock)
where (status & 1)=0
Open stickyAlertsCursor
Fetch next from stickyAlertsCursor into  @configId,@criteria,@alertType,@status,@suppressionOpType,@query
WHILE   @@FETCH_STATUS = 0
BEGIN
	delete from @tempResultsForEachQuery
	BEGIN TRY
		set @query = 'set @xmlVal =( '+@query+' )'
		declare @xmlVal xml
		-- First param to sp_executesql is the string query to be executed. Second param is param definition for the string query
		-- second param indicates @xmlVal in @query is of xml type
		-- third param maps param in param definition to local variable.
		execute sp_executesql @query,N'@xmlVal xml output',@xmlVal = @xmlVal output
		if @xmlVal is not null
		begin
			-- Now read the xml and convert it
			-- Now read the xml and convert it
			Insert into @tempResultsForEachQuery(entityType ,entityId ,entityName, substoreid,storeid,entity )
			select ISNULL(Tbl.Col.value('@entityType', 'nvarchar(max)'),'') ,
					ISNULL(Tbl.Col.value('@entityId', 'nvarchar(max)'),''),
					ISNULL(Tbl.Col.value('@entityName', 'nvarchar(max)'),''),
					ISNULL(Tbl.Col.value('@subStoreId', 'nvarchar(max)'),''),
					ISNULL(Tbl.Col.value('@storeId', 'nvarchar(max)'),''),
					Tbl.Col.query('entity')
			from @xmlVal.nodes('/App_StickyAlertsToBeProcessed/alertEntities') as Tbl(Col)
		end
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		Fetch next from stickyAlertsCursor into  @configId,@criteria,@alertType,@status,@suppressionOpType,@query
		continue
	END CATCH
	delete from @tempResultsForEachQuery
	where (entityType is null OR Len(entityType)=0) OR
	(entityId is null OR Len(entityId)=0) OR
	(entityName is null OR Len(entityId)=0)
	-- Now update the NTDetectedAlerts for conditionCleared status. For entries which are not present now.
	Update NTDEtectedAlerts
	set processStat = 4 -- Condition Cleared
	where alertType = @alertType and criteria = @criteria
	and processStat != 8
	and eventid not in
	(
		select NTDA.eventid from NTDetectedAlerts NTDA with (nolock)
		inner join NTDParams NTDPObjType with (nolock) on NTDA.eventid = NTDPObjType.eventid
		and NTDPObjType.type = 26 -- enumSuppObjType
		inner join NTDParams NTDPObjId with (nolock) on NTDA.eventid = NTDPObjId.eventid
		and NTDPObjId.type = 27 -- enumSuppObjId
		inner join @tempResultsForEachQuery Temp
		on NTDPObjType.value = Temp.entityType
		and NTDPObjId.value = Temp.entityId
		where NTDA.alertType = @alertType and NTDA.criteria = @criteria
	)
	-- Now remove entries from this tempTable which are already existing.
	delete Temp from @tempResultsForEachQuery as Temp
	where exists(
		select NTDA.eventid from NTDetectedAlerts NTDA with (nolock)
		inner join NTDParams NTDPObjType with (nolock) on NTDA.eventid = NTDPObjType.eventid
		and NTDPObjType.type = 26 -- enumSuppObjType
		and NTDPObjType.value = Temp.entityType
		inner join NTDParams NTDPObjId with (nolock) on NTDA.eventid = NTDPObjId.eventid
		and NTDPObjId.type = 27 -- enumSuppObjId
		and NTDPObjId.value = Temp.entityId
		where NTDA.alertType = @alertType and NTDA.criteria = @criteria
		and NTDA.processStat != 8 -- We dont want to match processed entries. They shld ideally be pruned. but in case global param is set for skip check.
	)
	Insert into @alertsToBeProcessed(entity,entityType,entityId,entityName,isConditionCleared,
	alertType,alertCriteria,subStoreId,storeid)
	select Temp.entity,Temp.entityType,Temp.entityId,Temp.entityName,0,@alertType,@criteria,Temp.subStoreId,Temp.storeid
	from @tempResultsForEachQuery Temp
	Fetch next from stickyAlertsCursor into  @configId,@criteria,@alertType,@status,@suppressionOpType,@query
END
Close stickyAlertsCursor
DEAllocate stickyAlertsCursor
END_ITEM_SP:
-- Now that we have all the results/ all new alerts to be sent, we will return xml
declare @xml xml
set @xml = (select entityType '@entityType',entityId '@entityId',entityName '@entityName',isConditionCleared '@isConditionCleared',
	alertType '@alertType',alertCriteria '@alertCriteria', subStoreId '@subStoreId',storeid '@storeId', entity.query('.')
from @alertsToBeProcessed
for xml path('alertEntities'),root('App_StickyAlertsToBeProcessed'))
if @xml is null
begin
	set @xml = '<App_StickyAlertsToBeProcessed/>'
end
select @xml
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'NTDProcessStickyAlerts')
	delete from GxQscripts where name = 'NTDProcessStickyAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDProcessStickyAlerts')
	delete from GXDBVersions where aliasname = 'NTDProcessStickyAlerts'
GO

insert into GXDBVersions values(2, 'NTDProcessStickyAlerts',  '00010004006000020000', 'NTDProcessStickyAlerts', '00010004006000020000')
GO

