

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTDProcessCustomQueryAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTDProcessCustomQueryAlerts.sp,v $ $Id: NTDProcessCustomQueryAlerts.sp,v 1.9.48.7 2020/12/15 02:57:10 snandhini Exp $";
--
--  +========================================================================+
--  |   Procedure:  NTDProcessCustomQueryAlerts()
--  |
--  | Description:  Executes query for given rule.
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        mnatarajan     Initial Edit
--  +========================================================================+
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='NTDProcessCustomQueryAlerts')
BEGIN
	print '>>> Drop Stored Procedure: NTDProcessCustomQueryAlerts <<<'
	drop procedure NTDProcessCustomQueryAlerts
END
IF EXISTS (select * from GxQscripts where name='NTDProcessCustomQueryAlerts')
	delete from GxQscripts where name = 'NTDProcessCustomQueryAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDProcessCustomQueryAlerts')
	delete from GXDBVersions where aliasname = 'NTDProcessCustomQueryAlerts'
GO
print '... Creating Procedure: NTDProcessCustomQueryAlerts'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure NTDProcessCustomQueryAlerts
  @NTNotificationId INT
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @queryIdForCursor int
declare @queryString nvarchar(max)
declare @queryLastRunTime int
declare @userId	int
declare @userName			nvarchar(max)
Declare @xmlInfo nvarchar(max)
declare @localeId int
declare @filterQueryString nvarchar(max)
declare @filterQueryxml xml
declare @commcellAssociationList xml
declare @isOverwriteAssociationAtAlertAllowed int
declare @xmlEntityList xml
declare @paramName nvarchar(max)
declare @javaType nvarchar(max)
declare @isAllEntitiesSelected int
set @queryIdForCursor = NULL
select @queryIdForCursor = NTQueryList.queryId,
	@queryString = NTQueryList.queryString,
	@userId = NTRule.notifOwner,
	@queryLastRunTime = dbo.GetUnixTime(NTNotificationQueryMapping.lastRunTime),
	@xmlInfo = NTNotificationQueryMapping.xmlInfo,
	@localeId = NTRule.locale,
	@filterQueryString = NTNotificationQueryMapping.queryCriteriaString,
	@commcellAssociationList = NTQueryList.commcellAssociation,
	@isOverwriteAssociationAtAlertAllowed = NTQueryList.isOverwriteAssociationAtAlertAllowed,
	@xmlEntityList = NTRule.xmlEntityList
from NTNotificationQueryMapping with (nolock)
inner join NTNotificationRule  NTRule with (nolock)
on NTRule.id = NTNotificationQueryMapping.NtNotificationId
and NTRule.id = @NTNotificationId
inner join NTQueryList with (nolock)
on NTNotificationQueryMapping.QueryId = NTQueryList.QueryId
where (NTRule.status & (1|2)) = 0 -- Ignore disabled alerts.
and (NTQueryList.status & 1)=0 --Ignore disabled queries
  -- There is no query which needs to be executed now.
if (@queryIdForCursor is NULL)
begin
	goto END_ITEM_SP
end
declare @xmlVal xml
set @xmlVal = ''
if (@xmlInfo is not null and len(@xmlInfo)>0)
	set @xmlVal = @xmlInfo
declare @QueryOutputColumnNames table
(
            columnName nvarchar(max),
            lmColumnType int,
            sqlcolumnType nvarchar(max),
			isPrimaryKey int,
			colIndex int
)
declare @filterCommcellIdFilterStringList table
(
	commcellId int,
	filterString nvarchar(max)
)
declare @associatedCommcellIdQueryFilterStringList table
(
	commcellId int,
	filterString nvarchar(max),
	isExcluded int
)
declare @inputColTypeList table
(
	paramName nvarchar(maX),
	value nvarchar(maX),
	sqlDataType nvarchar(maX),
	listType int,
	listColDataType nvarchar(maX),
	javaType nvarchar(maX),
	isAllEntitiesSelected int default 0
)
declare @xmlInfoXml xml = convert(xml,@xmlInfo)
Insert into @inputColTypeList
select T2.Col.value('@paramName','nvarchar(max)'),
	   T2.Col.value('@value','nvarchar(max)'),
	'nvarchar(max)',
	0,
	'nvarchar(max)',
	'string',
	0
from @xmlInfoXml.nodes('CVGui_QueryAdditionalInfo/queryParameters/queryParameters') as T2(Col)
declare @queryInputColList table
(
	paramName nvarchar(maX),
	javaDataType nvarchar(maX),
	listType int
)
insert into @queryInputColList(javadataType,paramName,listType)
select CONVERT(xml,xmlInfo).value('(App_XMLSchema/@inputType)[1]','nvarchar(max)'),
columnName,
CONVERT(xml,xmlInfo).value('(App_XMLSchema/@listType)[1]','int')
 from NTQueryColumnList
where columnType=1
and queryId=@queryIdForCursor
update InputCol
set sqlDataType = dbo.NTGetSqlDataType(QueryInputCols.javaDataType),
listType = QueryInputCols.listType,
listColDataType = dbo.NTGetSqlDataType(QueryInputCols.javaDataType),
javaType = QueryInputCols.javaDataType
from @inputColTypeList InputCol , @queryInputColList QueryInputCols
where InputCol.paramName = QueryInputCols.paramName
and QueryInputCols.listType = 0
update InputCol
set sqlDataType = dbo.NTGetListDataType(QueryInputCols.javaDataType),
listType = QueryInputCols.listType,
listColDataType = dbo.NTGetSqlDataType(QueryInputCols.javaDataType),
javaType = QueryInputCols.javaDataType
from @inputColTypeList InputCol , @queryInputColList QueryInputCols
where InputCol.paramName = QueryInputCols.paramName
and QueryInputCols.listType = 1
update InputCol
set isAllEntitiesSelected = dbo.NTGetIsAllEntitiesSelectedForParam(value,paramName)
from @inputColTypeList InputCol
where InputCol.listType>0
and sqlDataType='CVListEntity'
update InputCol
set value = dbo.NTGetValueForParamModified(value,paramName, javaType,listType,1)
from @inputColTypeList InputCol
set @userName = ''
select @userName = name from umusers where id=@userId
Insert into @inputColTypeList(paramName,Value,sqlDataType,listType,listColDataType,javaType)
select 'userId',convert(nvarchar(max),@userId),'int',0,'int','int'
union
select 'localeId',convert(nvarchar(max),@localeId),'int',0,'int','int'
union
select 'lastRunTime',convert(nvarchar(max),@queryLastRunTime),'int',0,'int','int'
union
select 'userName',@userName,'nvarchar(max)',0,'nvarchar(max)','string'
delete from @inputColTypeList
where paramName is null or len(paramName)=0
delete from @QueryOutputColumnNames
Insert into @QueryOutputColumnNames(colIndex,columnName,lmColumnType,sqlcolumnType,isPrimaryKey)
select	columnIndex,columnName,lmDataType,'nvarchar(max)',isPrimaryKey
from NTQueryColumnList with (nolock)
where QueryId = @queryIdForCursor
and columnType = 0
-- In case user doesnt mark primary key, we mark all columns to be primary key
if not exists(select 1 from @QueryOutputColumnNames
	where isPrimaryKey = 1)
begin
	update @QueryOutputColumnNames
	set isPrimaryKey = 1
end
declare @sqlQuery nvarchar(max)
set @sqlQuery = ''
Update @QueryOutputColumnNames
set sqlcolumnType = dbo.NTGetSqlDataTypeFRomLMDataType(lmColumnType)
Update @QueryOutputColumnNames
set sqlcolumnType = 'int'
where lmColumnType = 0
Update @QueryOutputColumnNames
set sqlcolumnType = 'datetime'
where lmColumnType = 7
set @filterQueryxml = convert(varchar(max),@filterQueryString)
if (@isOverwriteAssociationAtAlertAllowed=0)
begin
	Insert into @associatedCommcellIdQueryFilterStringList(commcellId,filterString,isExcluded)
	select ISNULL(T2.Col.value('@commCellId','int'),0),
		'',
		ISNULL(T2.Col.value('(flags/@exclude)[1]', 'int'),0)
	from @commcellAssociationList.nodes('App_Associations/entity') as T2(Col)
end
else
begin
	Insert into @associatedCommcellIdQueryFilterStringList(commcellId,filterString,isExcluded)
	select ISNULL(T2.Col.value('@commCellId','int'),0),
    '',
    ISNULL(T2.Col.value('(flags/@exclude)[1]', 'int'),0)
	from @xmlEntityList.nodes('CVGui_CommCellTreeNode/associations') as T2(Col)
end
if (not exists(select 1 from @associatedCommcellIdQueryFilterStringList))
begin
	Insert into @associatedCommcellIdQueryFilterStringList
	select 2,'',0
end
-- Also in case all associations are selected, then we expand them.
if (exists(select 1 from @associatedCommcellIdQueryFilterStringList where commcellId=0 and isExcluded=0))
begin
	Insert into @associatedCommcellIdQueryFilterStringList
	select APP_CommCell.id,'',0
	from APP_CommCell
	where ( (type = 1 AND ID > 2) Or ID = 2)
	delete from @associatedCommcellIdQueryFilterStringList
	where commcellId=0
end
-- Also remove all commcells which are excluded
Delete AssociatedCommcells
from @associatedCommcellIdQueryFilterStringList AssociatedCommcells inner join
@associatedCommcellIdQueryFilterStringList ExcludedCommcells
on ExcludedCommcells.commcellID = AssociatedCommcells.commcellId
where ExcludedCommcells.isExcluded = 1
-- Now we remove all remote GRCs from selected which are disabled etc.
Delete AssociatedCommcells
from @associatedCommcellIdQueryFilterStringList AssociatedCommcells,
(
	select commcellid
	from GRC_CommCellProp
	where propId = 30 AND longVal <> 0 --GRC_COMMCELL_DISABLED_BY_USER
	union
	select APP_CommCell.id from
	App_commcell left join App_client on
	App_commcell.clientId = app_client.id
	where app_client.id is null
) DisabledCommcells
where AssociatedCommcells.commcellId<>2 and AssociatedCommcells.commcellId=DisabledCommcells.commcellId
Insert into @filterCommcellIdFilterStringList(commcellId,filterString)
select T2.Col.value('@commcellId','int'),
	T2.Col.value('@queryCriteriaString','nvarchar(max)')
from @filterQueryxml.nodes('CVGui_CommcellQueryCriteriaStringList/commcellQueryCriterias') as T2(Col)
update AssociatedCommcells
set filterString = FilteredCommcells.filterString
from @associatedCommcellIdQueryFilterStringList AssociatedCommcells,
@filterCommcellIdFilterStringList FilteredCommcells where
FilteredCommcells.commcellId = AssociatedCommcells.commcellId Or
(
	FilteredCommcells.commcellId = 0 and AssociatedCommcells.commcellId <> 2
)
-- For all list inputs with all entities selected, we modify query string to fill all entities for those params
IF ( CURSOR_STATUS('global', 'queryStringModifyCursor') >= 0   OR CURSOR_STATUS('local', 'queryStringModifyCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
	CLOSE queryStringModifyCursor
IF ( CURSOR_STATUS('global','queryStringModifyCursor') = -1     OR CURSOR_STATUS('local','queryStringModifyCursor') = -1 )
	DEALLOCATE queryStringModifyCursor
DECLARE queryStringModifyCursor CURSOR FOR
select paramName,javaType from @inputColTypeList
where listType=1
and isAllEntitiesSelected>0
declare @preprocessQueryString nvarchar(max) = ''
set @preprocessQueryString = ''
OPEN queryStringModifyCursor
FETCH NEXT FROM queryStringModifyCursor INTO @paramName,@javaType
WHILE @@FETCH_STATUS = 0
BEGIN
	declare @cvEntityString nvarchar(max)
	set @cvEntityString = ''
	if (@javaType like '%clientEntity%')
	begin
		set @cvEntityString = 'select id,name from App_client with (nolock) where id>1'
	end
	else if (@javaType like '%mediaAgentEntity%')
	begin
		-- added inSCGId as 0
		set @cvEntityString = 'select id,name from App_client with (nolock) INNER JOIN dbo.scgV2GetClientProps(''='',5,0,0) AS MAList on App_client.id = MAList.clientId And App_client.id>1'
	end
	else if @javaType like '%userEntity%'
	begin
		set @cvEntityString = 'select id,login from UMUsers with (nolock) where id>=1 and flags<>0'
	end
	else if @javaType like '%libraryEntity%'
	begin
		set @cvEntityString = 'select LibraryId,aliasName from MMLibrary with (nolock) where LibraryId>=1'
	end
	else if @javaType like '%clientGroupEntity%'
	begin
		set @cvEntityString = 'select id,name from App_clientgroup with (nolock)'
	end
	else if @javaType like '%storagepolicyEntity%'
	begin
		set @cvEntityString = 'select id,name from archGroup with (nolock) where id>1'
	end
	else if @javaType like '%usergroupEntity%'
	begin
		set @cvEntityString = 'select id,name from UMGroups with (nolock) where name <> ''CV_Restricted_Visibility'' and umdsproviderid=0 '
	end
	else if @javaType like '%workflowEntity%'
	begin
		set @cvEntityString = 'select workflowId,Name from WF_Definition with (nolock) where (flags & 16) = 0'
	end
	else if @javaType like '%commcellEntity%'
	begin
		set @cvEntityString = 'select id,aliasName from APP_CommCell with (nolock) where id>1'
	end
	else if @javaType like '%SchedulePolicyEntity%'
	begin
		set @cvEntityString = 'select taskid,taskName from TM_Task with (nolock) where taskid>1'
	end
	declare @tableCreationString nvarchar(max) = ''
	set @tableCreationString = 'declare @' + @paramName + ' table(EntityId int, entityName nvarchar(max))'
	set @preprocessQueryString = @preprocessQueryString + char(13)+char(10) + @tableCreationString + char(13)+char(10)
	set @preprocessQueryString = @preprocessQueryString + 'Insert into @' + @paramName + '(EntityId, EntityName)' + char(13)+char(10) + @cvEntityString + char(13)+char(10)
	FETCH NEXT FROM queryStringModifyCursor INTO @paramName,@javaType
END
CLOSE queryStringModifyCursor
DEALLOCATE queryStringModifyCursor
-- In case query starts with CTE statement and all entities for one input is selected, then query execution throws error without below ; addition
if (@preprocessQueryString is not null and len(@preprocessQueryString)>0)
begin
	set @preprocessQueryString = @preprocessQueryString + ';'
end
set @queryString = @preprocessQueryString + char(13)+char(10) + @queryString
declare @queryExecReqXml xml = NULL
set @queryExecReqXml = (select @queryLastRunTime as '@lastRunTime',
	@localeId as '@localeId',
	@queryString as '@queryString',
	@queryIdForCursor as '@queryId',
	@NTNotificationId as '@ntNotificationId',
	(select login from UMUsers where id=@userId) as 'userInfo/@userName' ,
	(
		-- For inputs where all entities are selected, we will append them to query itself. We pass only other input params and their values here.
		select paramName as '@paramName',
			value as '@value',
			sqlDataType as '@sqlDataType',
			listType as '@isList',
			listColDataType as '@listColDataType',
			lower(javaType) as '@javaType'
		from @inputColTypeList
		where listType<>1
		OR isAllEntitiesSelected=0
		for xml path('queryParameters'),root('queryParameters'),TYPE
	) as queryAdditionalInfo,
	(
		select  replace(columnName,'''','''''') '@columnName',
			sqlcolumnType '@sqlDataType',
			isPrimaryKey '@isPrimaryKey',
			lmColumnType '@origColumnDataType'
		from @QueryOutputColumnNames
		order by colIndex
		for xml path('queryOutputCols'),TYPE
	) as queryOutputCols,
	(
		select commcellId as '@commcellId',
			filterString '@queryCriteriaString'
		from @associatedCommcellIdQueryFilterStringList
		for xml path('commcellQueryCriterias'),root('commcellQueryCriteriaList'),TYPE
	)
	for xml path('CVGui_QueryExecuteReqParams'))
END_ITEM_SP:
	select IsNull(@queryExecReqXml,'<CVGui_QueryExecuteReqParams/>')
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'NTDProcessCustomQueryAlerts')
	delete from GxQscripts where name = 'NTDProcessCustomQueryAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDProcessCustomQueryAlerts')
	delete from GXDBVersions where aliasname = 'NTDProcessCustomQueryAlerts'
GO

insert into GXDBVersions values(2, 'NTDProcessCustomQueryAlerts',  '00010009004800070000', 'NTDProcessCustomQueryAlerts', '00010009004800070000')
GO

