

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTDMatchJobDelayAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--  Author: Muath Ali
--  Date:   04/12/2005
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTDMatchJobDelayAlert.sp,v $ $Id: NTDMatchJobDelayAlert.sp,v 1.8.278.1 2018/03/20 00:47:04 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTDMatchJobDelayAlert <<<'

IF EXISTS (select * from sysobjects where name='NTDMatchJobDelayAlert')
	drop procedure NTDMatchJobDelayAlert
IF EXISTS (select * from GxQscripts where name='NTDMatchJobDelayAlert')
	delete from GxQscripts where name = 'NTDMatchJobDelayAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDMatchJobDelayAlert')
	delete from GXDBVersions where aliasname = 'NTDMatchJobDelayAlert'
GO
print '... Creating Procedure: NTDMatchJobDelayAlert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure NTDMatchJobDelayAlert
  @i_eventId integer,
  @i_selCriteriaId integer
AS
  DECLARE @retVal integer;
DECLARE @EventTime	DATETIME
DECLARE @processTime	DATETIME
DECLARE @NowTime	DATETIME
DECLARE @errorCode	integer
DECLARE @Delay     integer
DECLARE	@delta		integer
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
SET @Delay		= 0
SET @retVal		= -1
set @errorCode	= 0
-- THIS IS THE FIRST TIME THIS EVENT OCCURRED: ----
SET	@NowTime = GETDATE()
SELECT @EventTime = occurtime, @processTime = processTime
	FROM ntDetectedAlerts
	WHERE eventId = @i_eventId
SET @errorCode = @@Error
IF @errorCode <> 0
		GOTO RETURN_PROC
SELECT @Delay = value
	FROM NTSelCriteriaParams
	WHERE selCriteriaId = @i_selCriteriaId
SET @errorCode = @@Error
IF @errorCode <> 0
		GOTO RETURN_PROC
SET	@delta = DATEDIFF(MINUTE, @EventTime, @nowTime)
--select step='test',eventTime=@eventTime, nowtime=@nowTime, diff=@delta
IF @delta >= (@Delay * 60)
BEGIN
--	select step='got here'
	IF @delta > (@Delay * 60)+4 AND @EventTime <> @processTime
		SET @retVal = 1
	ELSE
		SET @retVal = 0
	UPDATE ntDetectedAlerts
		SET    processTime = GETDATE()
		WHERE  eventId = @i_eventId
	IF @@ERROR <> 0
		GOTO RETURN_PROC
END
RETURN_PROC:
SELECT   @retVal
RETURN   @errorCode;
GO

IF EXISTS (select * from GxQscripts where name = 'NTDMatchJobDelayAlert')
	delete from GxQscripts where name = 'NTDMatchJobDelayAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDMatchJobDelayAlert')
	delete from GXDBVersions where aliasname = 'NTDMatchJobDelayAlert'
GO

insert into GXDBVersions values(2, 'NTDMatchJobDelayAlert',  '00010008027800010000', 'NTDMatchJobDelayAlert', '00010008027800010000')
GO

