

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTDMatchDistToClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--  Author: Muath Ali
--  Date:   03/28/2005
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTDMatchDistToClients.sp,v $ $Id: NTDMatchDistToClients.sp,v 1.13.50.2 2018/03/20 00:51:19 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTDMatchDistToClients <<<'

IF EXISTS (select * from sysobjects where name='NTDMatchDistToClients')
	drop procedure NTDMatchDistToClients
IF EXISTS (select * from GxQscripts where name='NTDMatchDistToClients')
	delete from GxQscripts where name = 'NTDMatchDistToClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDMatchDistToClients')
	delete from GXDBVersions where aliasname = 'NTDMatchDistToClients'
GO
print '... Creating Procedure: NTDMatchDistToClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTDMatchDistToClients
  @i_eventId integer,
  @i_XML NTEXT
AS
  DECLARE @retVal integer;
SET NOCOUNT ON
--This will turn off message: "xxx rows affected".
DECLARE @idoc           integer
DECLARE @IncAll         integer
DECLARE @clientCount    integer
SET @retVal = -1
 --------------------------------------------------------------
---- Changes to accommodate new entity selection protocol ------
 --------------------------------------------------------------
 declare @varXml xml
 set @varXml =  CAST(@i_XML AS xml )
declare @entitiesTable  table
(
    typ  int,
	clientId int,
	clientGroupId int,
	exclude int
)
insert into @entitiesTable
(
   typ,
   clientGroupId,
   clientId,
   exclude
)
SELECT
  ISNULL(ref.value('@_type_','INT'),0),
  ISNULL(ref.value('@clientGroupId','INT'),0),
  ISNULL(ref.value('@clientId','INT'),0),
  ISNULL(ref.value('(flags/@exclude)[1]','INT'),0)
FROM @varXml.nodes ('/CVGui_CommCellTreeNode/associations') R(ref)
IF( (SELECT count(*)  from @entitiesTable  ) >0 )
BEGIN
DECLARE @ClientIDs TABLE
(
   clientId int
)
	------------------------------------------------------------------------------
	---Handling if allClients or all clientGroups are selected--------------------
	------------------------------------------------------------------------------
	IF( (SELECT count(*)  from @entitiesTable where typ = 27 ) >0 )
	BEGIN
	   -- All client groups are included
	   -- So we need list of all clients which are associated to any clientGroup
	   -- and which is not part of excluded clientgroup
		INSERT INTO @ClientIDs
		SELECT  clientId FROM APP_ClientGroupAssoc with (nolock)
		EXCEPT
		SELECT  APP_ClientGroupAssoc.clientId FROM @entitiesTable AS ET
		LEFT OUTER JOIN APP_ClientGroupAssoc with (nolock)
		ON ET.clientGroupId = APP_ClientGroupAssoc.clientGroupId
		WHERE exclude = 1
	END
	IF ( (SELECT count(*)  from @entitiesTable where typ = 2 ) >0 )
	BEGIN
		-- All clients  are included
		-- So we need the list of all the clients of commserv
		-- and which is not specifically excluded in entityList
		INSERT INTO @ClientIDs
		select id from APP_Client with (nolock)
		EXCEPT
		SELECT  clientId FROM @entitiesTable WHERE exclude = 1
		--during install software job, for new clients clientid comes as -1 as there wouldnt be any entry in app_client table for it
		--to support it, Add -1 if all clients is selected,
		INSERT INTO @ClientIDs values(-1)
	END
	------------------------------------------------------------------------------
	 -- If All entities are not selected.
	 -- LOGIC
	 --   1. Take all clients inside non excluded client groups
	 --	  2. union it with non excluded clients
	 --	  3. Remove the clients excluded at client level
	 --   (  Reason for step 3) : clients excluded at client level may be present in client groups which are included)
	 --   4. Remove the clients inside Client Group which is excluded .
	 --   (  Reason for step 3) : clients inside excluded clientGroup may be present in clients are included at client Level)
	------------------------------------------------------------------------------
	INSERT INTO @ClientIDs
	-- Take all clients inside non excluded clientGroups (STEP 1)
	  SELECT distinct APP_ClientGroupAssoc.clientId FROM @entitiesTable AS ET
	  LEFT OUTER JOIN APP_ClientGroupAssoc with (nolock)
	  ON APP_ClientGroupAssoc.clientGroupId = ET.clientGroupId
	  WHERE exclude <>1
	UNION
	-- Take all non excluded clients (STEP 2)
	  SELECT distinct clientId FROM @entitiesTable
	  WHERE exclude <>1
	EXCEPT
	(
	  ----- select all excluded clients to remove ---------------------
	  -- (STEP 3) Remove the clients excluded at client level
	  SELECT distinct clientId FROM @entitiesTable
	  WHERE exclude = 1
	  UNION
	  -- (STEP 4) Remove the clients inside excluded clientGroups
	  SELECT distinct APP_ClientGroupAssoc.clientId FROM @entitiesTable AS ET
	  LEFT OUTER JOIN APP_ClientGroupAssoc with (nolock)
	  ON APP_ClientGroupAssoc.clientGroupId = ET.clientGroupId
	  WHERE exclude = 1
    )
	-- 6, 18, 19, 20, 21 hardcoded values defined as enums in EvNDetectParams.h
	-- enumClientList, enumSuccClntList, enumFailClntList,
	-- enumUpToDateClntList, enumUnknownClntList, enumJobRunningClntList
	-- enumLowCacheClntList, enumUnreachableClntList, enumClntStatusList, enumClntIdsList
	SELECT     @clientCount = COUNT(*)
	FROM       @ClientIDs c
	INNER JOIN NTDParams p
	ON         c.clientId = CAST(p.value AS integer)
	WHERE      p.eventId = @i_eventId AND p.type in (6, 18, 19, 20, 21, 31, 32, 33, 34, 35)
IF @@ERROR <> 0
	 set @retVal =  @@ERROR
IF @clientCount > 0
BEGIN
   set @retVal = 0
END
select @retVal
return @retVal
END
-------------------------------------------------------------------------------------------------------------
EXEC sp_xml_preparedocument @idoc OUTPUT, @i_XML
SELECT @IncAll = includeAll
FROM    OPENXML(@idoc, '//clients', 0)
WITH(
        includeAll       integer     './@includeAll'
        ) as XMLDoc
IF @@ERROR <> 0
   GOTO RETURN_PROC
-- Magic names and numbers as dectated by GUI, it was "very" difficult to modify GUI code to
-- produce a more consistent xml
IF @IncAll = 1
BEGIN
   set @retVal = 0
   GOTO RETURN_PROC
END
SELECT  ClientId
INTO    #ClientIDs
FROM    OPENXML(@idoc, '//clients/clients', 0)
WITH(
        clientId  integer
        ) as XMLDoc
WHERE ClientId IS NOT null
IF @@ERROR <> 0
   GOTO RETURN_PROC
SELECT @IncAll = includeAll
FROM    OPENXML(@idoc, '//clientGroups', 0)
WITH(
        includeAll       integer     './@includeAll'
        ) as XMLDoc
IF @@ERROR <> 0
   GOTO RETURN_PROC
CREATE TABLE #ClientGroupIDs(clientGroupId integer)
IF @IncAll = 1 -- If all Client Groups are selected then put all of them #clientGroupIDs in to the table
BEGIN
	INSERT INTO #ClientGroupIDs
	SELECT DISTINCT clientGroupId FROM APP_ClientGroupAssoc
END
ELSE
BEGIN	-- Else insert the  individual client groups in to the table
	INSERT INTO #ClientGroupIDs
	SELECT clientGroupId
	FROM OPENXML(@idoc,'//clientGroups/clientGroups',0)
	WITH(
		clientGroupId integer
		) as XMLDoc
	WHERE clientGroupId IS NOT null
	IF @@ERROR <> 0
	   GOTO RETURN_PROC
END
-- Expanding the client groups --> Clients
INSERT INTO #ClientIDs
SELECT distinct clientId
from APP_ClientGroupAssoc where clientGroupId in (select clientGroupId from #ClientGroupIDs)
-- 6, 18, 19, 20, 21 hardcoded values defined as enums in EvNDetectParams.h
-- enumClientList, enumSuccClntList, enumFailClntList,
-- enumUpToDateClntList, enumUnknownClntList, enumJobRunningClntList
-- enumLowCacheClntList, enumUnreachableClntList, enumClntStatusList, enumClntIdsList
SELECT     @clientCount = COUNT(*)
FROM       #ClientIDs c
INNER JOIN NTDParams p
ON         c.clientId = CAST(p.value AS integer)
WHERE      p.eventId = @i_eventId AND p.type in (6, 18, 19, 20, 21, 31, 32, 33, 34, 35)
IF @@ERROR <> 0
   GOTO RETURN_PROC
IF @clientCount > 0
BEGIN
   set @retVal = 0
   GOTO RETURN_PROC
END
RETURN_PROC:
   IF @@ERROR <> 0   SET @retVal = @@ERROR
   EXEC sp_xml_removedocument @idoc
   IF EXISTS (select * from sysobjects where name='#ClientIDs')
      DROP TABLE #ClientIDs
   IF EXISTS (select * from sysobjects where name='#ClientGroupIDs')
      DROP TABLE #ClientGroupIDs
SELECT   @retVal
RETURN   @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'NTDMatchDistToClients')
	delete from GxQscripts where name = 'NTDMatchDistToClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDMatchDistToClients')
	delete from GXDBVersions where aliasname = 'NTDMatchDistToClients'
GO

insert into GXDBVersions values(2, 'NTDMatchDistToClients',  '00010013005000020000', 'NTDMatchDistToClients', '00010013005000020000')
GO

