

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTDMarkClearedForCustomAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTDMarkClearedForCustomAlerts.sp,v $ $Id: NTDMarkClearedForCustomAlerts.sp,v 1.4.2.1 2018/03/27 09:12:52 jiechen Exp $";
--
--  +========================================================================+
--  |   Procedure:  NTDMarkClearedForCustomAlerts()
--  |
--  | Description:  Marks detected alerts processed for given custom notification rules
--  |
--  |       Input:  userId
--  |
--  |      Output:  Returns rows that match input criteria
--  |      Return:  None
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        mnatarajan     Initial Edit
--  +========================================================================+
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTDMarkClearedForCustomAlerts <<<'

IF EXISTS (select * from sysobjects where name='NTDMarkClearedForCustomAlerts')
	drop procedure NTDMarkClearedForCustomAlerts
IF EXISTS (select * from GxQscripts where name='NTDMarkClearedForCustomAlerts')
	delete from GxQscripts where name = 'NTDMarkClearedForCustomAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDMarkClearedForCustomAlerts')
	delete from GXDBVersions where aliasname = 'NTDMarkClearedForCustomAlerts'
GO
print '... Creating Procedure: NTDMarkClearedForCustomAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTDMarkClearedForCustomAlerts
  @detectedTime int,
  @notificationIdsXml xml
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @notifRules table
(
	ruleId int
)
Insert into @notifRules
select Tbl.Col.value('@val','int')  from
@notificationIdsXml.nodes('/CVGui_NotifRuleIdsList/ruleIds') as Tbl(Col)
Update NTD
set processStat = 4
from NTDetectedAlerts NTD
inner join @notifRules NotifRules on
NotifRules.ruleId = NTD.NtNotificationId
and NTD.alertType=65
and NTD.processTime < dbo.GetDateTime(@detectedTime+datepart(TZoffset, sysdatetimeoffset())*60) and (NTD.processStat & (12))=0	-- eAlertStatusCleared|eAlertStatusProcessed
select @@error
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'NTDMarkClearedForCustomAlerts')
	delete from GxQscripts where name = 'NTDMarkClearedForCustomAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDMarkClearedForCustomAlerts')
	delete from GXDBVersions where aliasname = 'NTDMarkClearedForCustomAlerts'
GO

insert into GXDBVersions values(2, 'NTDMarkClearedForCustomAlerts',  '00010004000200010000', 'NTDMarkClearedForCustomAlerts', '00010004000200010000')
GO

