

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTDClearDelayedJobAlert.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2005  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTDClearDelayedJobAlert.sp,v $ $Id: NTDClearDelayedJobAlert.sp,v 1.3.304.2 2018/03/20 00:32:41 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: NTDClearDelayedJobAlert
--  |
--  | Description:
--  |  Add JMJobDataStats table entries for the given backup job and copy.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Jun Lu   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTDClearDelayedJobAlert <<<'

IF EXISTS (select * from sysobjects where name='NTDClearDelayedJobAlert')
	drop procedure NTDClearDelayedJobAlert
IF EXISTS (select * from GxQscripts where name='NTDClearDelayedJobAlert')
	delete from GxQscripts where name = 'NTDClearDelayedJobAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDClearDelayedJobAlert')
	delete from GXDBVersions where aliasname = 'NTDClearDelayedJobAlert'
GO
print '... Creating Procedure: NTDClearDelayedJobAlert'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure NTDClearDelayedJobAlert
  @i_jobId_h INTEGER,
  @i_jobId_l INTEGER,
  @i_tableName VARCHAR(512)
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @RestoreFilesCmd varchar(8000)
   SET @retVal = 0
   CREATE TABLE #EventIdsTbl (ids integer)
   IF @@ERROR <> 0 GOTO RETURN_PROC
    SET @RestoreFilesCmd = 'Select tbl.eventId from ' + @i_tableName +
       ' tbl with(nolock) inner join NTDetectedAlerts da with(nolock) on tbl.eventId = da.eventId ' +
       ' where tbl.jobId_h = ' +
       QUOTENAME(@i_jobId_h , '''' ) + ' and tbl.jobId_l = ' + QUOTENAME(@i_jobId_l , '''') +
       ' and da.criteria = 5'
   INSERT INTO #EventIdsTbl EXECUTE ( @RestoreFilesCmd );
   IF @@ERROR <> 0 GOTO RETURN_PROC
   UPDATE NTDetectedAlerts SET processStat = 8 WHERE eventId IN (SELECT Ids FROM #EventIdsTbl)
   IF @@ERROR <> 0 GOTO RETURN_PROC
   DROP TABLE #EventIdsTbl
RETURN_PROC:
   SET @retVal = @@ERROR
   SELECT @retVal
   RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'NTDClearDelayedJobAlert')
	delete from GxQscripts where name = 'NTDClearDelayedJobAlert'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDClearDelayedJobAlert')
	delete from GXDBVersions where aliasname = 'NTDClearDelayedJobAlert'
GO

insert into GXDBVersions values(2, 'NTDClearDelayedJobAlert',  '00010003030400020000', 'NTDClearDelayedJobAlert', '00010003030400020000')
GO

