

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTDAlertTrace.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2005  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTDAlertTrace.sp,v $ $Id: NTDAlertTrace.sp,v 1.2.266.1 2018/03/20 00:50:03 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: NTDAlertTrace
--  |
--  | Description:
--  |  alert trace
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        Muath Ali   Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTDAlertTrace <<<'

IF EXISTS (select * from sysobjects where name='NTDAlertTrace')
	drop procedure NTDAlertTrace
IF EXISTS (select * from GxQscripts where name='NTDAlertTrace')
	delete from GxQscripts where name = 'NTDAlertTrace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDAlertTrace')
	delete from GXDBVersions where aliasname = 'NTDAlertTrace'
GO
print '... Creating Procedure: NTDAlertTrace'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure NTDAlertTrace
  @i_eventId integer,
  @i_criteria integer,
  @i_alertType integer,
  @i_oldAlertType integer,
  @i_oldCondition integer,
  @i_conditionCleared char(16), 
  @i_clientId integer,
  @i_libId integer,
  @i_sparePoolId integer,
  @i_driveId integer,
  @i_mediaId integer,
  @i_mediaAgentId integer,
  @i_mountPathId integer,
  @i_jobId_l integer,
  @i_jobId_h integer,
  @i_taskId integer,
  @i_schedPolicyId integer,
  @i_spId integer,
  @i_spCopyId integer  
AS
  DECLARE @retVal INTEGER;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
DECLARE @MaxCount integer
   SELECT @MaxCount = Count(*) from NTDTrace
   IF @MaxCount > 9999
   BEGIN
      DELETE NTDTrace FROM (SELECT TOP 200 * FROM NTDTrace order by logTime) AS t1
      WHERE NTDTrace.logTime = t1.logTime
      AND   NTDTrace.eventId = t1.eventId
   END
   INSERT INTO NTDTrace VALUES(
                        GETDATE(),
                        @i_eventId,
                        @i_criteria,
                        @i_alertType,
                        @i_oldAlertType,
                        @i_oldCondition,
                        @i_conditionCleared,
                        @i_clientId,
                        @i_libId,
                        @i_sparePoolId,
                        @i_driveId,
                        @i_mediaId,
                        @i_mediaAgentId,
                        @i_mountPathId,
                        @i_jobId_l,
                        @i_jobId_h,
                        @i_taskId,
                        @i_schedPolicyId,
                        @i_spId,
                        @i_spCopyId
                        )
   SET @retVal = @@ERROR
   SELECT @retVal
   RETURN @retVal;
GO

IF EXISTS (select * from GxQscripts where name = 'NTDAlertTrace')
	delete from GxQscripts where name = 'NTDAlertTrace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTDAlertTrace')
	delete from GXDBVersions where aliasname = 'NTDAlertTrace'
GO

insert into GXDBVersions values(2, 'NTDAlertTrace',  '00010002026600010000', 'NTDAlertTrace', '00010002026600010000')
GO

