

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTCreateDefaultAlertsForOrganization.sp] ---------- 

-- ALLOW_COMMENTS_BELOW_HERE:
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='NTCreateDefaultAlertsForOrganization')
BEGIN
	print '>>> Drop Stored Procedure: NTCreateDefaultAlertsForOrganization <<<'
	drop procedure NTCreateDefaultAlertsForOrganization
END
IF EXISTS (select * from GxQscripts where name='NTCreateDefaultAlertsForOrganization')
	delete from GxQscripts where name = 'NTCreateDefaultAlertsForOrganization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTCreateDefaultAlertsForOrganization')
	delete from GXDBVersions where aliasname = 'NTCreateDefaultAlertsForOrganization'
GO
print '... Creating Procedure: NTCreateDefaultAlertsForOrganization'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure NTCreateDefaultAlertsForOrganization
--	+-------------------------------+
--	| PARAMETERS   &   OUTPUTS		|
--	+-------------------------------+
  @tenantGrpId Integer,
  @tenantAdminUserId Integer,
  @tenantClientGrpId Integer,
  @errorCode integer          OUTPUT,
  @errorString nvarchar(1024)   OUTPUT
AS
set @errorCode = 0
set @errorString  = ''
DECLARE @nowTime			as integer	= dbo.GetUnixTime (GetUTCdate())
DECLARE @clientGroupName	AS nvarchar(MAX)= ''
select @clientGroupName = name from App_ClientGroup with (nolock) where id=@tenantClientGrpId
DECLARE @organizationId int
select @organizationId = umdsproviderId from UMGroups with (nolock) where id=@tenantGrpId
DECLARE @xmlEntities		AS nvarchar(MAX)= '<CVGui_CommCellTreeNode><associations _type_="28" clientGroupId="'+convert(nvarchar(max),@tenantClientGrpId)+'" clientGroupName="Laptop Clients" /></CVGui_CommCellTreeNode>'
DECLARE	@emptyDateTime		AS datetime	= '1900-01-01 00:00:00.000'
DECLARE @localeId			AS integer		= 1
DECLARE	@ruleState			AS integer		= 0
DECLARE	@reportOptions		AS integer		= 1		-- 'NT_REPORT_IMMEDIATE'
DECLARE @persistTimeSeconds AS integer		= 0
DECLARE @SelCriteriaId		integer
DECLARE @createdAlertsId	INT = 1
DECLARE @thisCriteria		int
DECLARE @notifType			AS integer	= 1			-- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)
--
---
----  FOR CURSOR -----
DECLARE @alertId			INTEGER
DECLARE @alertType			INTEGER
DECLARE @notificationName	NVARCHAR(128)			-- 'NT_MAX_NOTIFICATION_NAME_SIZE'
DECLARE @description		NVARCHAR(1024)			-- 'NT_MAX_ALERT_DESCRIPTION_SIZE'
DECLARE @msgFmtText			NVARCHAR(max)
DECLARE @msgFmtHtml 		NVARCHAR(max)
DECLARE @isAlertEnabled		bit
DECLARE @cursorXmlEntities  nvarchar(MAX)
DECLARE @enableBackupJobSucceededOrganizationAlert INT = 0
SELECT @enableBackupJobSucceededOrganizationAlert = value FROM GXGlobalParam (NOLOCK) WHERE name='enableBackupJobSucceededOrganizationAlert'
IF @enableBackupJobSucceededOrganizationAlert>0
BEGIN
	SET @enableBackupJobSucceededOrganizationAlert = 1
END
--
--
DECLARE @alertsToAdd table (
		alertId				int primary key,
		alertType			int Not Null,
notificationName	nvarchar(128),
description			nvarchar(1024),
		msgFmtText			nvarchar(max),
		msgFmtHtml			nvarchar(max),
		isAlertEnabled		bit,
		xmlEntities			nvarchar(MAX)
)
DECLARE @criteriasToAdd table (
		alertId				int ,
		criteriaId			int ,
		criteriaParamType	int,
		criteriaParamValue	int,
		criteriaParamUnit	int
		primary key(alertId,criteriaId)
)
----------------------
DECLARE	@thisAlertId		integer
SET @errorCode	= 0
SET @errorString= ''
DECLARE @startTranHere int  = 0
if @@TRANCOUNT =0
begin
	set @startTranHere = 1
end
BEGIN TRY
	if @startTranHere=1
	begin
		BEGIN TRAN
	end
	declare @statusForAlert int = 0
	DECLARE @htmldefaultTemplateForDataProtAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDataProtAlert nvarchar(max)
IF EXISTS(SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name='UseNewAlertTemplate' AND value=1)
		set @htmldefaultTemplateForDataProtAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Agent Type</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;AGENT TYPE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Instance</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;INSTANCE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Backup Set</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;BACKUPSET NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Subclient</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SUBCLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Backup Level</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;LEVEL&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Storage Policies Used</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STORAGE POLICIES USED&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Virtual Machine Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VIRTUAL MACHINE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Virtual Machine Host Name</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VIRTUAL MACHINE HOST NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Virtual Machine Backup Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VM STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure reason for Virtual Machine Backup</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;VM FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Start Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;START TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Scheduled Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SCHEDULE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>End Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;END TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Error Code</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ERR CODE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Protected Counts</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;PROTECTED COUNT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failed Counts</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILED COUNT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>&lt;ADDITIONAL VM INFO&gt; </b></font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForDataProtAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><table cellpadding="0" cellspacing="0" border="1" align="center" width="75%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px"><tr><td><center><table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"><tr style="background-color: #666666"><td align="left" valign="middle"><div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"><font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font></div></td></tr><tr><td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;COMMCELL NAME&gt;</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;DETECTED CRITERIA&gt;</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Detected Time: </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">&lt;TIME&gt;</font></strong></ul></td></tr><tr><td width="100%" colspan="1" align="left"><ul><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">User: &lt;USER NAME&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Job ID: &lt;JOB ID&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Status: &lt;STATUS&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">Client: &lt;CLIENT NAME&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Agent Type: &lt;AGENT TYPE NAME&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Instance: &lt;INSTANCE NAME&gt;</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Backup Set: &lt;BACKUPSET NAME&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Subclient: &lt;SUBCLIENT NAME&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Backup Level: &lt;LEVEL&gt;</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Storage Policies Used: &lt;STORAGE POLICIES USED&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Virtual Machine Name: &lt;VIRTUAL MACHINE NAME&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Virtual Machine Host Name: &lt;VIRTUAL MACHINE HOST NAME&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Virtual Machine Backup Status: &lt;VM STATUS&gt;</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Failure reason for Virtual Machine Backup: &lt;VM FAILURE REASON&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Start Time: &lt;START TIME&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Scheduled Time: &lt;SCHEDULE TIME&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">End Time: &lt;END TIME&gt;</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Error Code: &lt;ERR CODE&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Failure Reason: &lt;FAILURE REASON&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Protected Counts: &lt;PROTECTED COUNT&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">Failed Counts: &lt;FAILED COUNT&gt;</font> </li><li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">&lt;ADDITIONAL VM INFO&gt;</font> </li></ul></td></tr><tr style="background-color: #666666"><td colspan="1" align="left"></td></tr></table></center></td></tr></table>'
	set @textdefaultTemplateForDataProtAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Agent Type: <AGENT TYPE NAME> MsgNewLine_MsgTab_ Instance: <INSTANCE NAME> MsgNewLine_MsgTab_ Backup Set: <BACKUPSET NAME> MsgNewLine_MsgTab_ Subclient: <SUBCLIENT NAME> MsgNewLine_MsgTab_ Backup Level: <LEVEL> MsgNewLine_MsgTab_ Storage Policies Used: <STORAGE POLICIES USED> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Protected Counts: <PROTECTED COUNT> MsgNewLine_MsgTab_ Failed Counts: <FAILED COUNT> MsgNewLine_MsgTab_  Current Backup Size: <CURRENT BACKUP SIZE> MsgNewLine_MsgTab_ Previous Job ID: <PREVIOUS JOBID> MsgNewLine_MsgTab_ Previous Backup Size: <PREVIOUS BACKUP SIZE> MsgNewLine_MsgTab_ Percentage Change: <PERCENTAGE CHANGE> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
3,
			'Backup job failed',
			'Default backup job failed Alert',
			@textdefaultTemplateForDataProtAlert,
			@htmldefaultTemplateForDataProtAlert,
			1,
			@xmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,3,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
3,
			'Backup job succeeded',
			'Default backup job succeeded Alert',
			@textdefaultTemplateForDataProtAlert,
			@htmldefaultTemplateForDataProtAlert,
			@enableBackupJobSucceededOrganizationAlert,
			@xmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,1,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	DECLARE @htmldefaultTemplateForDataRecovAlert nvarchar(max)
	DECLARE @textdefaultTemplateForDataRecovAlert nvarchar(max)
IF EXISTS(SELECT 1 FROM GXGlobalParam WITH(NOLOCK) WHERE name='UseNewAlertTemplate' AND value=1)
		set @htmldefaultTemplateForDataRecovAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"> <table cellspacing="0" cellpadding="0" width="100%" style="border: 1px solid #2f4e66;"> <tr> <td> <center> <table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"> <tr style="background-color: #2f4e66"> <td valign="middle" align="left" colspan="3"> <div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"> <font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font> </div> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Type </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ALERT CATEGORY - ALERT TYPE&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font> </td> </tr> <tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Detected Criteria </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;DETECTED CRITERIA&gt;</font> </td> </tr> <tr> <td colspan="3" style="padding-top: 5px; padding-bottom: 5px; padding-right: 0; padding-left: 0"> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>User </b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;USER NAME&gt;</font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Job ID</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB ID&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Status</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;STATUS&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Client</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;CLIENT NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Agent Type</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;AGENT TYPE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Instance</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;INSTANCE NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Backup Set</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;BACKUPSET NAME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Operation</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;JOB OPERATION&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Start Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;START TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Scheduled Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SCHEDULE TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>End Time</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;END TIME&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Size</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SIZE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Error Code</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;ERR CODE&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failure Reason</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILURE REASON&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Failed Counts</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;FAILED COUNT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Skipped Counts</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;SKIPPED COUNT&gt; </font> </td> </tr> <tr> <td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"> <font size="3" color="#444444" face="sans-serif"><b>Recovered Counts</b></font> </td> <td colspan="2"> <font size="3" color="#444444" face="sans-serif">&lt;RECOVERED COUNT&gt;</font> </td> </tr> <tr style="background-color: #2f4e66"> <td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"> <font size="3" face="sans-serif" color="#ffffff">Generated At &lt;TIME&gt; </font> </td> </tr> </table> </center> </td> </tr> </table> </div>'
	ELSE
		set @htmldefaultTemplateForDataRecovAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> <table cellpadding="0" cellspacing="0" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px" border="1" align="center" width="75%"><tr><td><center><table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"><tr style="background-color: #666666"><td valign="middle" align="left"><div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"><font size="6" face="Helvetica,sans-serif" color="#EEEEEE">&lt;ALERT NAME&gt; </font></div></td></tr><tr><td colspan="1" valign="middle" align="left"  bgcolor="#DCDEDE" ><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>CommCell: </strong></font><font color="#660000" size="4" face="Helvetica,sans-serif"><strong>&lt;COMMCELL NAME&gt;</strong></font></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Type: </strong></font><font color="#660000" size="4" face="Helvetica,sans-serif"><strong>&lt;ALERT CATEGORY - ALERT TYPE&gt;</strong></font></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Detected Criteria: </strong></font><font color="#660000" size="4" face="Helvetica,sans-serif"><strong>&lt;DETECTED CRITERIA&gt;</strong></font></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>Detected Time: </strong></font><font color="#660000" size="4" face="Helvetica,sans-serif"><strong>&lt;TIME&gt;</strong></font></ul></td></tr><tr><td width="100%" colspan="1" align="left"><font size="3" face="Helvetica,sans-serif" color="#000000"><ul><li style="margin-top: 4px; margin-bottom: 4px">User: &lt;USER NAME&gt;</li><li style="margin-top: 4px; margin-bottom: 4px">Job ID: &lt;JOB ID&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Status: &lt;STATUS&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Client: &lt;CLIENT NAME&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Agent Type: &lt;AGENT TYPE NAME&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Instance: &lt;INSTANCE NAME&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Backup Set: &lt;BACKUPSET NAME&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Operation: &lt;JOB OPERATION&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Start Time: &lt;START TIME&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Scheduled Time: &lt;SCHEDULE TIME&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">End Time: &lt;END TIME&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Error Code: &lt;ERR CODE&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Failure Reason: &lt;FAILURE REASON&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Failed Counts: &lt;FAILED COUNT&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Skipped Counts: &lt;SKIPPED COUNT&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">Recovered Counts: &lt;RECOVERED COUNT&gt; </li></ul></font></td></tr><tr style="background-color: #666666"><td colspan="1" align="left" >&nbsp;</td></tr></table></center>'
	set @textdefaultTemplateForDataRecovAlert = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ Detected Criteria: <DETECTED CRITERIA> MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Job ID: <JOB ID> MsgNewLine_MsgTab_ Status: <STATUS> MsgNewLine_MsgTab_ Client: <CLIENT NAME> MsgNewLine_MsgTab_ Agent Type: <AGENT TYPE NAME> MsgNewLine_MsgTab_ Instance: <INSTANCE NAME> MsgNewLine_MsgTab_ Backup Set: <BACKUPSET NAME> MsgNewLine_MsgTab_ Operation: <JOB OPERATION> MsgNewLine_MsgTab_ Start Time: <START TIME> MsgNewLine_MsgTab_ Scheduled Time: <SCHEDULE TIME> MsgNewLine_MsgTab_ End Time: <END TIME> MsgNewLine_MsgTab_ Error Code: <ERR CODE> MsgNewLine_MsgTab_ Failure Reason: <FAILURE REASON> MsgNewLine_MsgTab_ Failed Counts: <FAILED COUNT> MsgNewLine_MsgTab_ Skipped Counts: <SKIPPED COUNT> MsgNewLine_MsgTab_ Recovered Counts: <RECOVERED COUNT> MsgNewLine_MsgTab_'
	Insert @alertsToAdd values(
			@createdAlertsId,
4,
			'Restore job succeeded',
			'Default restore job succeeded Alert',
			@textdefaultTemplateForDataRecovAlert,
			@htmldefaultTemplateForDataRecovAlert,
			1,
			@xmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,1,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	Insert @alertsToAdd values(
			@createdAlertsId,
4,
			'Restore job failed',
			'Default restore job failed Alert',
			@textdefaultTemplateForDataRecovAlert,
			@htmldefaultTemplateForDataRecovAlert,
			1,
			@xmlEntities
	)
	Insert into @criteriasToAdd
select @createdAlertsId,3,1,10,2
	set @createdAlertsId = @createdAlertsId + 1
	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newDefaultAlertsCursor
	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )
		DEALLOCATE newDefaultAlertsCursor
	DECLARE newDefaultAlertsCursor CURSOR FOR
		SELECT  alertId, alertType, notificationName, description, msgFmtText, msgFmtHtml , isAlertEnabled, XmlEntities
		   FROM @alertsToAdd
	OPEN newDefaultAlertsCursor
		FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
		WHILE @@FETCH_STATUS = 0
		BEGIN
		-- Set the status based on whether alert is enabled or disabled.
		if @isAlertEnabled=1
		begin
			set @statusForAlert = 0
		end
		else
		begin
			set @statusForAlert = 1
		end
		-- No need to check whether this alert is already present. Since we have to create for each organization.
		INSERT NTNotificationRule (	categoryId,				alertTypeId,
									notificationName,		revision,
									lastModified,			description,
									notifType,				notifOwner,
									locale,					status,
									ruleState,				ruleState2,
									lastTimeTriggered,		lastTimeTriggered2,
									lastTimeChecked,		hasAttachments,
									hasAttachments2,		xmlEntityList,
									origCCId,				GUID)
		select						categoryId,				@alertType,
									@notificationName,		1,
									@nowTime,				@description,
									@notifType,				@tenantAdminUserId,
									0,						@statusForAlert,
								        -- 1 DefaultLocale US-English .. Create  default alerts in disabled state
									@ruleState,				@ruleState,
									@emptyDateTime,			@emptyDateTime,
									@emptyDateTime,			0,
									0,						@cursorXmlEntities ,
									2,				newid()
				from NTAlerttype where id = @alertType
		SET @thisAlertId = @@Identity
		INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
		select criteriaId,1,@thisAlertId,0,0,0
		from @criteriasToAdd
		where alertId = @alertId
		SET @SelCriteriaId = @@identity
		if exists(select 1 from @criteriasToAdd where alertId = @alertId and criteriaParamType is not null and
			criteriaParamValue is not null and criteriaParamUnit is not null)
		begin
			INSERT NTSelCriteriaParams (selCriteriaid, paramIndex, type, value, unit, occurrences)
			select id,0,criteriaParamType,criteriaParamValue,criteriaParamUnit,0
			from NTSelcriteria , @criteriasToAdd newCriterias
			where NTSelcriteria.ruleid = @thisAlertId
			and newCriterias.alertId = @alertId
			and newCriterias.criteriaParamType is not null and
			newCriterias.criteriaParamValue is not null and newCriterias.criteriaParamUnit is not null
		end
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 1, null, null, 0)
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 2, null, null, 0)
-- ADD DEFAULT (EMAIL) MESSAGE:
									 --
		INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
							SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
							baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
			VALUES		(@thisAlertId, 1, 1, @msgFmtText, N'',
0, 0, 0, 0, 2,
						 '', '', '', '', 1, @msgFmtHtml)
		INSERT INTO NTnotificationGroups(NTNotificationId,groupId,escalationLevel)
		select @thisAlertId,@tenantGrpId,1
DECLARE @alertTemplateLocalizedHtml NVARCHAR(MAX) = '$$1241513986$$ $$1241514196$$ $$1241513997$$ $$1241514197$$ $$1241513990$$ $$1241514006$$ $$1241513985$$<table cellpadding="0" cellspacing="0" border="1" align="center" width="75%" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px"><tr><td><center><table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"><tr style="background-color: #666666"><td align="left" valign="middle"><div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"><font size="6" face="Helvetica,sans-serif" color="#EEEEEE">$$1241513997$$ </font></div></td></tr><tr><td bgcolor="#DCDEDE" colspan="1" align="left" valign="middle"><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>$$1241514372$$ </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">$$1241513988$$</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>$$1241514197$$ </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">$$1241513990$$</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>$$1241514198$$ </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">$$1241513998$$</font></strong></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>$$1241514199$$ </strong></font><strong><font color="#660000" size="4" face="Helvetica,sans-serif">$$1241513991$$</font></strong></ul></td></tr><tr><td width="100%" colspan="1" align="left"><ul><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514200$$ $$1241514167$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514201$$ $$1241514019$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514202$$ $$1241514007$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514209$$ $$1241514026$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514210$$ $$1241514027$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514211$$ $$1241514028$$</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514212$$ $$1241514029$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514213$$ $$1241514030$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514214$$ $$1241514031$$</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514454$$ $$1241514456$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241515113$$ $$1241515112$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241515114$$ $$1241515115$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241515110$$ $$1241515109$$</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241515111$$ $$1241515108$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514203$$ $$1241514020$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514204$$ $$1241514022$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514205$$ $$1241514021$$</font> </li> <li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514397$$ $$1241514396$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514206$$ $$1241514023$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514216$$ $$1241514032$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"><font size="3" face="Helvetica,sans-serif" color="#000000">$$1241514215$$ $$1241514033$$</font> </li><li style="margin-top: 4px; margin-bottom: 4px"> <font size="3" face="Helvetica,sans-serif" color="#000000">$$1241515154$$</font> </li></ul></td></tr><tr style="background-color: #666666"><td colspan="1" align="left"></td></tr></table></center></td></tr></table>'
DECLARE @alertTemplateLocalizedText NVARCHAR(MAX) = '$$1241513986$$ $$1241514196$$ $$1241513997$$ $$1241514197$$ $$1241513990$$ $$1241514006$$ $$1241513985$$ MsgNewLine_ $$1241514196$$ $$1241513997$$ MsgNewLine_ $$1241514197$$ $$1241513990$$ MsgNewLine_MsgTab_ $$1241514198$$ $$1241513998$$ MsgNewLine_MsgTab_ $$1241514199$$ $$1241513991$$ MsgNewLine_MsgTab_ $$1241514372$$ $$1241513988$$ MsgNewLine_MsgTab_ $$1241514200$$ $$1241514167$$ MsgNewLine_ MsgNewLine_ MsgTab_ $$1241514201$$ $$1241514019$$ MsgNewLine_MsgTab_ $$1241514202$$ $$1241514007$$ MsgNewLine_MsgTab_ $$1241514209$$ $$1241514026$$ MsgNewLine_MsgTab_ $$1241514210$$ $$1241514027$$ MsgNewLine_MsgTab_ $$1241514211$$ $$1241514028$$ MsgNewLine_MsgTab_ $$1241514212$$ $$1241514029$$ MsgNewLine_MsgTab_ $$1241514213$$ $$1241514030$$ MsgNewLine_MsgTab_ $$1241514214$$ $$1241514031$$ MsgNewLine_MsgTab_ $$1241514454$$ $$1241514456$$ MsgNewLine_MsgTab_ $$1241514203$$ $$1241514020$$ MsgNewLine_MsgTab_ $$1241514204$$ $$1241514022$$ MsgNewLine_MsgTab_ $$1241514205$$ $$1241514021$$ MsgNewLine_MsgTab_ $$1241514397$$ $$1241514396$$ MsgNewLine_MsgTab_ $$1241514206$$ $$1241514023$$ MsgNewLine_MsgTab_ $$1241514216$$ $$1241514032$$ MsgNewLine_MsgTab_ $$1241514215$$ $$1241514033$$ MsgNewLine_MsgTab_  $$1241514429$$ $$1241514428$$ MsgNewLine_MsgTab_ $$1241514433$$ $$1241514432$$ MsgNewLine_MsgTab_ $$1241514431$$ $$1241514430$$ MsgNewLine_MsgTab_ $$1241514435$$ $$1241514434$$ MsgNewLine_MsgTab_'
IF (@alertType <> 3)
		BEGIN
SET @alertTemplateLocalizedHtml = '$$1241513986$$ $$1241514196$$ $$1241513997$$ $$1241514197$$ $$1241513990$$ $$1241514006$$ $$1241513985$$ <table cellpadding="0" cellspacing="0" style="border-left-color: #dedede; border-bottom-width: 0px; border-bottom-style: solid; border-left-width: 0px; border-top-style: solid; border-top-color: #dedede; border-right-color: #dedede; border-bottom-color: #dedede; border-left-style: solid; border-right-style: solid; border-top-width: 0px; border-right-width: 0px" border="1" align="center" width="75%"><tr><td><center><table cellpadding="0" border="0" id="contentTbl" width="100%" align="center" cellspacing="0"><tr style="background-color: #666666"><td valign="middle" align="left"><div style="margin-left: 10px; margin-bottom: 4px; margin-top: 4px"><font size="6" face="Helvetica,sans-serif" color="#EEEEEE">$$1241513997$$ </font></div></td></tr><tr><td colspan="1" valign="middle" align="left"  bgcolor="#DCDEDE" ><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>$$1241514372$$ </strong></font><font color="#660000" size="4" face="Helvetica,sans-serif"><strong>$$1241513988$$</strong></font></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>$$1241514197$$ </strong></font><font color="#660000" size="4" face="Helvetica,sans-serif"><strong>$$1241513990$$</strong></font></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>$$1241514198$$ </strong></font><font color="#660000" size="4" face="Helvetica,sans-serif"><strong>$$1241513998$$</strong></font></ul><ul style="margin-top: 4px; margin-bottom: 4px"><font size="4" face="Helvetica,sans-serif"><strong>$$1241514199$$ </strong></font><font color="#660000" size="4" face="Helvetica,sans-serif"><strong>$$1241513991$$</strong></font></ul></td></tr><tr><td width="100%" colspan="1" align="left"><font size="3" face="Helvetica,sans-serif" color="#000000"><ul><li style="margin-top: 4px; margin-bottom: 4px">$$1241514200$$ $$1241514167$$</li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514201$$ $$1241514019$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514202$$ $$1241514007$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514209$$ $$1241514026$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514210$$ $$1241514027$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514211$$ $$1241514028$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514212$$ $$1241514029$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514924$$ $$1241515138$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514203$$ $$1241514020$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514204$$ $$1241514022$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514205$$ $$1241514021$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514397$$ $$1241514396$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514206$$ $$1241514023$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514215$$ $$1241514033$$ </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514217$$ &lt;SKIPPED COUNT&gt; </li><li style="margin-top: 4px; margin-bottom: 4px">$$1241514218$$ &lt;RECOVERED COUNT&gt; </li></ul></font></td></tr><tr style="background-color: #666666"><td colspan="1" align="left" >&nbsp;</td></tr></table></center>'
SET @alertTemplateLocalizedText = '$$1241513986$$ $$1241514196$$ $$1241513997$$ $$1241514197$$ $$1241513990$$ $$1241514006$$ $$1241513985$$ MsgNewLine_ $$1241514196$$ $$1241513997$$ MsgNewLine_ $$1241514197$$ $$1241513990$$ MsgNewLine_MsgTab_ $$1241514198$$ $$1241513998$$ MsgNewLine_MsgTab_ $$1241514199$$ $$1241513991$$ MsgNewLine_MsgTab_ $$1241514372$$ $$1241513988$$ MsgNewLine_MsgTab_ $$1241514200$$ $$1241514167$$ MsgNewLine_ MsgNewLine_ MsgTab_ $$1241514201$$ $$1241514019$$ MsgNewLine_MsgTab_ $$1241514202$$ $$1241514007$$ MsgNewLine_MsgTab_ $$1241514209$$ $$1241514026$$ MsgNewLine_MsgTab_ $$1241514210$$ $$1241514027$$ MsgNewLine_MsgTab_ $$1241514211$$ $$1241514028$$ MsgNewLine_MsgTab_ $$1241514212$$ $$1241514029$$ MsgNewLine_MsgTab_ $$1241514924$$ $$1241515138$$ MsgNewLine_MsgTab_ $$1241514203$$ $$1241514020$$ MsgNewLine_MsgTab_ $$1241514204$$ $$1241514022$$ MsgNewLine_MsgTab_ $$1241514205$$ $$1241514021$$ MsgNewLine_MsgTab_ $$1241514397$$ $$1241514396$$ MsgNewLine_MsgTab_ $$1241514206$$ $$1241514023$$ MsgNewLine_MsgTab_ $$1241514215$$ $$1241514033$$ MsgNewLine_MsgTab_ $$1241514217$$ $$1241514035$$ MsgNewLine_MsgTab_ $$1241514218$$ $$1241514034$$ MsgNewLine_MsgTab_'
		END
		-- Add a notification prop to indicate this alert is added for which organization.
		INSERT INTO NTNotificationProp(componentNameId,attrName,attrType,attrVal,created,modified)
SELECT @thisAlertId,'OrganizationId','7',CONVERT(NVARCHAR(10),@organizationId),@nowTime,0
		UNION ALL
SELECT @thisAlertId,'Alert formatted message Html','1',@alertTemplateLocalizedHtml, @nowTime,0
		UNION ALL
SELECT @thisAlertId,'Alert formatted message Text','1',@alertTemplateLocalizedText,@nowTime,0
		 DECLARE @roleId INTEGER =0
		SET @roleId =ISNULL((SELECT id
								FROM UMRoles
WHERE flags & 1 | 2 <> 0 and name like 'Alert Owner'),0)
EXEC sec_setCreatorForEntity @tenantAdminUserId, @roleId, '', @errorCode OUTPUT, @errorString OUTPUT, 64, @thisAlertId ,0,0,0,0,0,0,0,0,@tenantGrpId
		FETCH NEXT FROM newDefaultAlertsCursor INTO @alertId,@alertType, @notificationName, @description, @msgFmtText, @msgFmtHtml,@isAlertEnabled,@cursorXmlEntities
	END
END TRY
 BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
     set @errorCode = ERROR_NUMBER()
     set @errorString = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
 END CATCH
 	IF ( CURSOR_STATUS('global', 'newDefaultAlertsCursor') >= 0   OR CURSOR_STATUS('local', 'newDefaultAlertsCursor') >= 0 )  -- CLOSE CURSOR IF OPEN
		CLOSE newDefaultAlertsCursor
	IF ( CURSOR_STATUS('global','newDefaultAlertsCursor') = -1     OR CURSOR_STATUS('local','newDefaultAlertsCursor') = -1 )
		DEALLOCATE newDefaultAlertsCursor
 if (@startTranHere=1)
 begin
	IF @errorCode = 0
		COMMIT TRAN
	ELSE
		ROLLBACK TRAN
  end
GO

IF EXISTS (select * from GxQscripts where name = 'NTCreateDefaultAlertsForOrganization')
	delete from GxQscripts where name = 'NTCreateDefaultAlertsForOrganization'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTCreateDefaultAlertsForOrganization')
	delete from GXDBVersions where aliasname = 'NTCreateDefaultAlertsForOrganization'
GO

insert into GXDBVersions values(2, 'NTCreateDefaultAlertsForOrganization',  '00000000000000000000', 'NTCreateDefaultAlertsForOrganization', '00000000000000000000')
GO

