

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTCreateDefaultAlertForFailover.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2019  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='NTCreateDefaultAlertForFailover')
BEGIN
	print '>>> Drop Stored Procedure: NTCreateDefaultAlertForFailover <<<'
	drop procedure NTCreateDefaultAlertForFailover
END
IF EXISTS (select * from GxQscripts where name='NTCreateDefaultAlertForFailover')
	delete from GxQscripts where name = 'NTCreateDefaultAlertForFailover'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTCreateDefaultAlertForFailover')
	delete from GXDBVersions where aliasname = 'NTCreateDefaultAlertForFailover'
GO
print '... Creating Procedure: NTCreateDefaultAlertForFailover'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure NTCreateDefaultAlertForFailover
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
BEGIN
	-- If package isnt installed then return.
IF NOT EXISTS(SELECT 1 FROM dbo.simInstalledPackages WITH (NOLOCK) WHERE simPackageID IN (24, 1024))
    BEGIN
        RETURN
    END
	DECLARE @curUtcDateTime BIGINT = DATEDIFF(SECOND, '01/01/1970', GetUTCdate())
	DECLARE @isTranBegin INT = 0
BEGIN TRY
    DECLARE @queryId INT
    SET @queryId = 0
    DECLARE @adminID            as integer      = ISNULL((Select top 1 ID from UMUSERS where (flags & 67) = 67 AND Name <> 'ROMS'), 1)
    DECLARE @errCode INTEGER
    DECLARE @errStr  nvarchar(1024) = ''
    DECLARE @queryName nvarchar(max) = 'Failover Health check'
	IF @@TRANCOUNT = 0
	BEGIN
		BEGIN TRAN
		SET @isTranBegin = 1
	END
	SELECT @queryId = queryID FROM NTQueryList (NOLOCK) WHERE queryName=@queryName
	IF (@queryId=0)
    BEGIN
    INSERT INTO NTQueryList(queryMessageId,defaultfrequency,status,queryCreator,visibility,taskId,queryString,
        xmlInfo,queryName,queryDescription,queryCriteriaName,GUID,commcellAssociation,isOverwriteAssociationAtAlertAllowed)
select 0,3600,2,@adminID,0,0,
'SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @lastSyncTimeRespXML XML
DECLARE @lastSyncTimeRespXMLTbl TABLE
(
	xmlResp XML
)
INSERT INTO @lastSyncTimeRespXMLTbl
EXEC AppGetCSFailoverLastSyncTime
SELECT @lastSyncTimeRespXML = xmlResp FROM @lastSyncTimeRespXMLTbl
IF OBJECT_ID(''tempdb.dbo.#failoverNodesInfo'') IS NOT NULL
	DROP TABLE #failoverNodesInfo
CREATE TABLE #failoverNodesInfo (
		clientId		INT,
		lastSyncTime	INT,
		scheduleCreatedTime INT
	)
INSERT INTO #failoverNodesInfo (lastSyncTime,scheduleCreatedTime,clientId )
SELECT ISNULL(ref.value(''@lastSyncTime'', ''INT''),0) ,
       ISNULL(ref.value(''@scheduleCreatedTime'', ''INT''),0),
	   ref.value(''(client/@clientId)[1]'', ''INT'')
FROM @lastSyncTimeRespXML.nodes (''App_CSFailoverLastSycTimesResp/lastSyncTimeList'') R(ref)
DECLARE @curTime INT = Dbo.getunixtime(getutcdate())
SELECT clientId,ISNULL(App_client.displayname,App_client.name) ClientName,''LiveSync jobs to Standby CommServe ''+ ISNULL(App_client.displayname,App_client.name)+ '' has not run in the past''+
	CASE WHEN @notifyWhenSyncNotDoneIn>60 THEN '' ''+CAST( @notifyWhenSyncNotDoneIn/60 AS NVARCHAR(10)) + '' Hours''
	ELSE ''''
	END +
	CASE WHEN @notifyWhenSyncNotDoneIn%60!=0 THEN '' ''+CAST( @notifyWhenSyncNotDoneIn%60 AS NVARCHAR(10)) + '' Minutes''
	ELSE ''''
	END+''. Check your production CommServe to correct the problem.''	as FailureReason
FROM #failoverNodesInfo failoverNodesInfo
INNER JOIN APP_Client on failoverNodesInfo.clientId = APP_Client.id
-- Alert when sync hasnt happened in specified time and alert when schedule is created not too recently.
WHERE @curTime-lastSyncTime>@notifyWhenSyncNotDoneIn*60
AND @curTime-scheduleCreatedTime>@notifyWhenSyncNotDoneIn*60
IF OBJECT_ID(''tempdb.dbo.#failoverNodesInfo'') IS NOT NULL
	DROP TABLE #failoverNodesInfo
',
--------- END QUERY ---------
--------- BEGIN - GENERATED CODE, PLEASE DO NOT MODIFY ---------
'<?xml version="1.0" encoding="UTF-16" standalone="no" ?><App_AdditionalQueryDetails alertCriteria="0" alertType="0" defaultHtmlTemplate="" defaultTextTemplate="" isHealthParam="0" querySeverity="3"><externalQueryEntity _type_="125"/><scriptDescription description="Custom rule to notify administrators when replication to Standby commserve is not running for specified time" guid="D34E04D0-ABAE-45E9-A02F-55E80521127E" reportName="Failover Health check" revision="$Revision: 1.1.2.2 $ M&lt;1561586966390>"/></App_AdditionalQueryDetails>',
'Failover Health check','Custom rule to notify administrators when replication to Standby commserve is not running for specified time',
'',NEWID(),
'<App_Associations><entity _type_="124" commCellId="2" /></App_Associations>',0
    SET @queryId = @@IDENTITY
    INSERT INTO NTQueryColumnList(queryId,columnIndex,isColumnFilterable,lmDataType,columnName,columnFriendlyName,
isPrimaryKey,supportedOpTypes,columnType,xmlInfo)
SELECT @queryId,0,0,0,'clientId','ClientId',1,'0,1,4,5,6,7',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'
UNION
SELECT @queryId,0,0,0,'notifyWhenSyncNotDoneIn','Notify when LiveSync has not run in (Minutes)',0,'',1,'<App_XMLSchema attribute="0" className="java.lang.Integer" controlHidden="0" controlType="0" defaultValue="1440" displayName="Notify when LiveSync has not run in (Minutes)" documentation="" hidden="0" inputName="notifyWhenSyncNotDoneIn" inputType="java.lang.Integer" listType="0" maximumValue="" minimumValue="" name="notifyWhenSyncNotDoneIn" readOnly="0" required="1" searchable="0" type="{http://www.w3.org/2001/XMLSchema}integer"><defaultValues val="1440"/></App_XMLSchema>'
UNION
SELECT @queryId,1,0,1,'ClientName','ClientName',0,'2,3,0,1',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails includeInAlertOutput="0" isAlertRecipient="0"/>'
UNION
SELECT @queryId,2,0,1,'FailureReason','FailureReason',0,'2,3,0,1',0,'<?xml version="1.0" encoding="UTF-8" standalone="no" ?><App_AdditionalOutputColumnDetails shldColumnBePartOfAlert="1"/>'
	END
	-- Now that rule is created, create the alert in disabled state.
	DECLARE @xmlEntities        AS nvarchar(MAX)= '<CVGui_CommCellTreeNode><clients includeAll="0" /><clientGroups includeAll="0" /><libraries includeAll="0" /><mediaAgents includeAll="0" /><storagePolcies includeAll="0" /><trackingPolicies includeAll="0" /><trackingSchedules /><trackingJobs /><criterias includeAll="0" /><workflows includeAll="0" /><commcells includeAll="0" /></CVGui_CommCellTreeNode>'
    DECLARE @emptyDateTime      AS datetime = '1900-01-01 00:00:00.000'
    DECLARE @localeId           AS integer      = 0
    -- We need only 1 alert per each DR CS
DECLARE @status             AS integer      = 1048576 + 16 + 2048 + 1     -- 'NNT_STATUS_LAPTOP_ALERT
    DECLARE @ruleState          AS integer      = 0
    DECLARE @reportOptions      AS integer      = 3     -- 'NT_REPORT_IMMEDIATE'
    DECLARE @persistTimeSeconds AS integer      = 86400 -- 1 day repeat duration
DECLARE @categoryId         as integer      =  9                -- 'NT_CATEGORY_CUSTOM_ALERT'
    DECLARE @SelCriteriaId      integer
	-- If failover feature is enabled, enable alert.
	IF EXISTS(SELECT 1 FROM Gxglobalparam WHERE name='nCSFailoverConfigStatus' AND Value='1' AND modified = 0) AND (@status & 1)>0
	BEGIN
		SET @status = @status - 1 -- Remove disabled flag
	END
    DECLARE @htmldefaultTemplate nvarchar(max)
    DECLARE @textdefaultTemplate nvarchar(max)
    SET @htmldefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END><div id="contentTbl-table-scroll"><table cellspacing="0" cellpadding="0" width="100%" style="border-top-color: #2f4e66; border-top-style: solid; border-top-width: 1px; border-right-color: #2f4e66; border-right-style: solid; border-right-width: 1px; border-bottom-color: #2f4e66; border-bottom-style: solid; border-bottom-width: 1px; border-left-color: #2f4e66; border-left-style: solid; border-left-width: 1px"><tr><td><center><table id="contentTbl" cellspacing="0" cellpadding="0" width="100%" border="0"><tr style="background-color: #2f4e66"><td valign="middle" align="left" colspan="3"><div style="margin-left: 20px; margin-bottom: 25px; margin-top: 25px"><font color="#FFFFFF" size="5" face="sans-serif"><b>&lt;ALERT NAME&gt; </b></font></div></td></tr><tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"><td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"><font size="3" color="#444444" face="sans-serif"><b>CommCell </b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">&lt;COMMCELL NAME&gt;</font></td></tr><tr style="background-color: #f5f5f5; background-image: null; background-repeat: repeat; background-attachment: scroll; background-position: null"><td style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"><font size="3" color="#444444" face="sans-serif"><b>Alert Rule Name</b></font></td><td colspan="2"><font size="3" color="#444444" face="sans-serif">&lt;QUERY NAME&gt;</font></td></tr><tr><td colspan="3" style="padding-top: 7px; padding-right: 0px; padding-bottom: 7px; padding-left: 20px"><font size="3" color="#444444" face="sans-serif">&lt;INDEX 2&gt;</font></td></tr><tr style="background-color: #2f4e66"><td colspan="3" align="right" style="padding-top: 7px; padding-right: 20px; padding-bottom: 7px; padding-left: 0px"><font size="3" face="sans-serif" color="#ffffff">Generated At: &lt;TIME&gt; </font></td></tr></table></center></td></tr></table></div>'
    SET @textdefaultTemplate = '<SUBJECT BEGIN> Alert: <ALERT NAME> Type: <ALERT CATEGORY - ALERT TYPE> <IS ESCALATED?> <SUBJECT END> MsgNewLine_ Alert: <ALERT NAME> MsgNewLine_ Type: <ALERT CATEGORY - ALERT TYPE> MsgNewLine_MsgTab_ MsgNewLine_MsgTab_ Detected Time: <TIME> MsgNewLine_MsgTab_ CommCell: <COMMCELL NAME> MsgNewLine_ MsgNewLine_ MsgNewLine_MsgTab_ User: <USER NAME> MsgNewLine_ MsgNewLine_ MsgTab_ Alert Rule Name : <QUERY NAME> MsgNewLine_MsgTab_ <INPUT DATA> MsgNewLine_MsgTab_ FailureReason : <INDEX 2> MsgNewLine_MsgTab_ Condition Cleared: : <CONDITION CLEARED Y/N>'
    DECLARE @thisCriteria       int
DECLARE @notifType          AS integer  = 1           -- !! WAS !! 'NT_LAPTOP_ALERTNOTIF' + EMAIL (TO FAKE OUT GUI, FOR NOW!)
    --
    ---
    ----  FOR CURSOR -----
DECLARE @alertType          INTEGER = 65
DECLARE @notificationName   NVARCHAR(128)         -- 'NT_MAX_NOTIFICATION_NAME_SIZE'
DECLARE @description        NVARCHAR(1024)         -- 'NT_MAX_ALERT_DESCRIPTION_SIZE'
    --
    --
    DECLARE @thisAlertId        integer
    SET @notificationName = 'LiveSync to Standby Commserve delayed'
    SET @description = 'Alert to notify administrator when replication to Standby commserve is not running for specified time'
SELECT @thisAlertId = id FROM NTNotificationRule WHERE (status& 1048576)>0 and revision=1
AND (Status& 2=0)
    -- Check whether this alert is already present. If so, dont insert again.
    IF @thisAlertId>0
    BEGIN
        GOTO FINISH_PROCESSING
    END
    INSERT NTNotificationRule ( categoryId,             alertTypeId,
                                notificationName,       revision,
                                lastModified,           description,
                                notifType,              notifOwner,
                                locale,                 status,
                                ruleState,              ruleState2,
                                lastTimeTriggered,      lastTimeTriggered2,
                                lastTimeChecked,        hasAttachments,
                                hasAttachments2,        xmlEntityList,
                                origCCId,               GUID)
    VALUES (                    @categoryId,            @alertType              ,
                                @notificationName,      1,
                                @curUtcDateTime,        @description,
                                @notifType,             @adminID,
                                0,						@status,          -- 0 DefaultLocale US-English
                                @ruleState,             @ruleState,
                                @emptyDateTime,         @emptyDateTime,
                                @emptyDateTime,         0,
                                0,                      @xmlEntities,
                                default,                newid() )
    SET @thisAlertId = @@Identity
    INSERT NTSelCriteria(availCriteriaid, esclationLevel, ruleId, reportingOptions, delayTimeSeconds, persistTimeSeconds)
VALUES(75, 1, @thisAlertId, @reportOptions, 0, @persistTimeSeconds)      -- 'NT_GENERIC_QUERY
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 1, null, null, 0)
	INSERT INTO NTmessages (NTnotificationID, escalationLevel, lastSetMessageTime, firstDetectTime, NTmessageState)
		VALUES (@thisAlertId, 2, null, null, 0)
-- ADD DEFAULT (EMAIL) MESSAGE:
                                    --
    INSERT NTmessageFormat (NTnotificationID,messageType,escalationLevel,formatString,formattedMessage,
                        SubjFieldStart,SubjFieldLen,MsgBodyStart,MsgBodyLen,mfOptions,
                        baseDir,userName,password, rssID, messageFormatType, formatStringHtml)
        VALUES      (@thisAlertId, 1, 1, @textdefaultTemplate, N'', 0, 0, 0, 0, 0,'', '', '', '', 1, @htmldefaultTemplate)
		INSERT INTO NTNotificationQueryMapping
            VALUES(
                @queryId, @thisAlertId, @emptyDateTime, @emptyDateTime,
                0, 0,
                '',
                '<CVGui_QueryAdditionalInfo><queryParameters><queryParameters isList="0" javaType="" listColDataType="" paramName="notifyWhenSyncNotDoneIn" sqlDataType="" value="&lt;notifyWhenSyncNotDoneIn>1440&lt;/notifyWhenSyncNotDoneIn>"/></queryParameters><externalQueryInfo _type_="125"/></CVGui_QueryAdditionalInfo>',
                '',
                'Failover Health check'
            )
		INSERT INTO NTnotificationUsers(NtnotificationId,userId,escalationLevel)
		SELECT @thisAlertId,@adminID,1
-- ADD DEFAULT USER (SHOULDN'T HAVE TO DO THIS, BUT REQ'D TO SUPPORT CURRENT ALERT GUI)
--      INSERT NTnotificationUsers  (NTnotificationID, userId,    escalationLevel)
--          VALUES (@thisAlertId, @adminID, 1)
FINISH_PROCESSING:
	-- Now disable or enable the alert depending on whether feature is enabled or disabled.
	IF EXISTS(SELECT 1 FROM Gxglobalparam WHERE name='nCSFailoverConfigStatus' AND Value='1' AND modified = 0)
	BEGIN
		UPDATE NTNotificationRule
		SET status = status -1
		WHERE id = @thisAlertId
		AND (Status&1)>0
	END
	ELSE
	BEGIN
		UPDATE NTNotificationRule
		SET status = status |1
		WHERE id = @thisAlertId
	END
	IF (@isTranBegin = 1)
	BEGIN
		COMMIT TRAN
	END
END TRY
BEGIN CATCH
    IF @isTranBegin = 1
        ROLLBACK TRAN
    if len(@errStr)=0 and len(ERROR_MESSAGE())>0
    begin
        set @errStr = ERROR_MESSAGE()
    end
    if len(@errStr)>0
        RAISERROR(@errStr, 16, 1)
END CATCH
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'NTCreateDefaultAlertForFailover')
	delete from GxQscripts where name = 'NTCreateDefaultAlertForFailover'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTCreateDefaultAlertForFailover')
	delete from GXDBVersions where aliasname = 'NTCreateDefaultAlertForFailover'
GO

insert into GXDBVersions values(2, 'NTCreateDefaultAlertForFailover',  '00000000000000000000', 'NTCreateDefaultAlertForFailover', '00000000000000000000')
GO

