

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NTCheckDetectedAlerts.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/NTCheckDetectedAlerts.sp,v $ $Id: NTCheckDetectedAlerts.sp,v 1.1.4.2 2017/05/15 22:54:27 mnatarajan Exp $";
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   NTCheckDetectedAlerts
--	- Fetch the list of detected alerts matching input conditions.
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NTCheckDetectedAlerts <<<'

IF EXISTS (select * from sysobjects where name='NTCheckDetectedAlerts')
	drop procedure NTCheckDetectedAlerts
IF EXISTS (select * from GxQscripts where name='NTCheckDetectedAlerts')
	delete from GxQscripts where name = 'NTCheckDetectedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTCheckDetectedAlerts')
	delete from GXDBVersions where aliasname = 'NTCheckDetectedAlerts'
GO
print '... Creating Procedure: NTCheckDetectedAlerts'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NTCheckDetectedAlerts
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @m_alertCategory int, 
  @m_alertType int, 
  @m_alertCriteria int,
  @m_alertId int,
  @m_timeBuff nvarchar(max),
  @m_timeBuffRepeatedAlert nvarchar(max)
AS
  DECLARE @isAnyEventPresent int
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @m_alertStatus int = 0
select @m_alertStatus = status from NTNotificationRule
where id=@m_alertId
if exists(select 1 from NTDetectedAlerts
	where category = @m_alertCategory AND alertType = @m_alertType AND criteria = @m_alertCriteria
	---Check for notif based alerts.
	AND (ntNotificationId is NULL OR ntNotificationId = 0 OR ntNotificationId = @m_alertId )
	-- Dont check for fresh entries here.
	AND (
	-- check for repeated entries.
	 ( ((processStat & 2) <> 0) And nextTriggertime <= @m_timeBuffRepeatedAlert ) )
AND ( (@m_alertStatus & 1024)>0 OR (processStat & 256) = 0 )
	 )
begin
	select 1
	return
end
select 0
return
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'NTCheckDetectedAlerts')
	delete from GxQscripts where name = 'NTCheckDetectedAlerts'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NTCheckDetectedAlerts')
	delete from GXDBVersions where aliasname = 'NTCheckDetectedAlerts'
GO

insert into GXDBVersions values(2, 'NTCheckDetectedAlerts',  '00010001000400020000', 'NTCheckDetectedAlerts', '00010001000400020000')
GO

