

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/NASClientVolumes.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: pbellam
--	Date:   08/11/2014
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: NASClientVolumes <<<'

IF EXISTS (select * from sysobjects where name='NASClientVolumes')
	drop procedure NASClientVolumes
IF EXISTS (select * from GxQscripts where name='NASClientVolumes')
	delete from GxQscripts where name = 'NASClientVolumes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NASClientVolumes')
	delete from GXDBVersions where aliasname = 'NASClientVolumes'
GO
print '... Creating Procedure: NASClientVolumes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure NASClientVolumes
  @ClientId int,
  @StoragePoolIds XML
AS
  DECLARE @o_XMLText XML;
BEGIN
	SET NOCOUNT ON
	-- Need to validate the Input. In case of invalid input, should throw an error.
	-- And also need to create a table variable , to store the ids from the XML input. Later we can use this table to access Ids instead of .nodes
	SET @o_XMLText = ISNULL(( 	SELECT
								(
									SELECT
										A.name AS '@volumeName',
										A.id AS '@volumeId',
										A.StoragePoolId AS '@aggregateId',
										A.clientId AS '@clientId',
										A.totalSpaceMB AS '@totalSpaceMB',
										A.freeSpaceMB AS '@freeSpaceMB',
										A.usedSpaceMB AS '@usedSpaceMB',
										A.ReserveField1 AS '@reserveField1'
									FROM SMArrayVolume A WITH (NOLOCK)
									WHERE A.ClientId = @ClientId and A.StoragePoolId in (select R.ref.value('.','int') FROM @StoragePoolIds.nodes('/AggregateIDs/AggregateID') R(ref))
									FOR XML PATH('nasClientVolumes'), TYPE
								) FOR XML PATH('DM2ContentIndexing_NASClientVolumesResp')
							),'<DM2ContentIndexing_NASClientVolumesResp/>')
	select @o_XMLText
	SET NOCOUNT OFF
	END
GO

IF EXISTS (select * from GxQscripts where name = 'NASClientVolumes')
	delete from GxQscripts where name = 'NASClientVolumes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='NASClientVolumes')
	delete from GXDBVersions where aliasname = 'NASClientVolumes'
GO

insert into GXDBVersions values(2, 'NASClientVolumes',  '00000000000000000000', 'NASClientVolumes', '00000000000000000000')
GO

