

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MergeVMClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--
--  +========================================================================+
--  |   Procedure:  MergeVMClients
--  |
--  | Description:  xx
--  |
--  |       Input:  xx
--  |
--  |      Output: The stored procedure can be used to remove duplicate virtual machine clients. Virtual machine properties and jobs would be merged to a single client.
--  |      Return:  xxx
--  |
--  |   Revisions  Author						Description
--  |   ---------  -------				--------------------------------
--  |   1.1        Shravani Chepuri  Initial Edit
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MergeVMClients <<<'

IF EXISTS (select * from sysobjects where name='MergeVMClients')
	drop procedure MergeVMClients
IF EXISTS (select * from GxQscripts where name='MergeVMClients')
	delete from GxQscripts where name = 'MergeVMClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MergeVMClients')
	delete from GXDBVersions where aliasname = 'MergeVMClients'
GO
print '... Creating Procedure: MergeVMClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure MergeVMClients
  @i_xmlText XML,
  @i_localeId INTEGER
AS
  DECLARE @o_xmlMsg xml
SET NOCOUNT ON
BEGIN TRY
	DECLARE @lastError	integer = 0
	DECLARE @localErrorMsg	nvarchar(1024) =''
	DECLARE @clientName1 nvarchar(1024) =''
	DECLARE @clientName2 nvarchar(1024) =''
	SET @clientName1=ISNULL( (SELECT  T.c.value('@clientName', 'nvarchar(1024)') FROM   @i_xmlText.nodes('EvGui_MergeVMClientsReq/client1') T(c)), '')
	SET @clientName2=ISNULL( (SELECT  T.c.value('@clientName', 'nvarchar(1024)') FROM   @i_xmlText.nodes('EvGui_MergeVMClientsReq/client2') T(c)), '')
	EXEC [dbo].[QS_SetVMClient]  @clientName1,@clientName2, @i_localeId, @o_Msg = @localErrorMsg OUTPUT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	Set @lastError = ERROR_NUMBER()
	SET @localErrorMsg  = ERROR_MESSAGE()
END CATCH
SET @o_xmlMsg = (SELECT
		@lastError  as '@errorCode',
		@localErrorMsg as '@errorMessage'
		FOR XML PATH('EvGui_GenericResp'), TYPE)
SELECT @o_xmlMsg AS [o_xmlMsg]
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MergeVMClients')
	delete from GxQscripts where name = 'MergeVMClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MergeVMClients')
	delete from GXDBVersions where aliasname = 'MergeVMClients'
GO

insert into GXDBVersions values(2, 'MergeVMClients',  '00000000000000000000', 'MergeVMClients', '00000000000000000000')
GO

