

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/MarkDeletedFlagOnOrphanOraTSAndDF.sp] ---------- 

--/******************************************************************************/
--/*  Copyright (c) CommVault Systems                                           */
--/*  All Rights Reserved                                                       */
--/*                                                                            */
--/*  THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF CommVault Systems          */
--/*  The copyright notice above does not evidence any                          */
--/*  actual or intended publication of such source code.                       */
--/*                                                                            */
--/*  File name   :  MarkDeletedFlagOnOrphanOraTSAndDF                          */
--/*  Author	:  Prashanth Bangalore                                                                          */
--/*  Description :  Stored proc used to mark OracleTableSpaces and             */
--/*                 OracleDataFiles Table rows associated with given instanceid*/                              */
--/******************************************************************************/
--dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/MarkDeletedFlagOnOrphanOraTSAndDF.sp,v $ $Id: MarkDeletedFlagOnOrphanOraTSAndDF.sp,v 1.4.2.2 2018/03/27 08:43:54 jiechen Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: MarkDeletedFlagOnOrphanOraTSAndDF <<<'

IF EXISTS (select * from sysobjects where name='MarkDeletedFlagOnOrphanOraTSAndDF')
	drop procedure MarkDeletedFlagOnOrphanOraTSAndDF
IF EXISTS (select * from GxQscripts where name='MarkDeletedFlagOnOrphanOraTSAndDF')
	delete from GxQscripts where name = 'MarkDeletedFlagOnOrphanOraTSAndDF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MarkDeletedFlagOnOrphanOraTSAndDF')
	delete from GXDBVersions where aliasname = 'MarkDeletedFlagOnOrphanOraTSAndDF'
GO
print '... Creating Procedure: MarkDeletedFlagOnOrphanOraTSAndDF'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure MarkDeletedFlagOnOrphanOraTSAndDF
  @i_instance integer,
  @browseTime integer, 
  @backupsetId integer = 0,
  @backupNode varchar(64) = ''
AS
DECLARE @ErrTbl table
(
	errCode integer,
        errStr varchar(80)
)
DECLARE @IdTbl table
(
	tblId integer
)
  DECLARE @errCode integer = 0
  DECLARE @errStr varchar(80) = ''
DECLARE @strIdList varchar(MAX)
SET NOCOUNT ON
BEGIN TRY
IF @i_instance = 0
BEGIN
set @errStr = 'Invalid Instance Id'
set @errCode = -1
goto EXIT_PROC
END
IF @browseTime  = 0
BEGIN
SET @errStr = 'Input Error: Updating DELETED OBJECTS requires modifiction time to be passed'
SET @errCode = -1
END
BEGIN TRAN
-- This handles deletion here
-- where the Tablespaces that got deleted will be handled
	update OracleTableSpaces set deleteFlag = 1 ,deleted = @browseTime
	OUTPUT  INSERTED.id into @IdTbl
	where instId = @i_instance  and modified != @browseTime and deleteFlag = 0
		and (@backupsetId = 0 or @backupsetId = backupSetId)
		and (@backupNode = '' or  bkpNode = @backupNode) ;
	IF @@ROWCOUNT > 0
	BEGIN
		SELECT  @strIdList = stuff( (SELECT ',' + (convert(varchar(10), a.tblId) )  from
		   @IdTbl  a   for XML PATH('') ),1,1,'')
		insert into @ErrTbl EXEC OracleObjectsUpdate  @i_instance, 5, 0, 1, 2, 0, @strIdList, 0, ''
		select @errCode = isnull(errCode, 0), @errStr = isnull(errStr, '') from @ErrTbl
		IF @errCode <> 0
		BEGIN
			GOTO EXIT_PROC
		END
		delete from  @IdTbl;
	END
	update oracleDataFiles set deleteFlag = 1, deleted = @browseTime
	OUTPUT  INSERTED.id into @IdTbl
	where instId = @i_instance  and modified != @browseTime and deleteFlag = 0
		and (@backupsetId = 0 or @backupsetId = backupSetId)
		and (@backupNode = '' or  bkpNode = @backupNode)  ;
	IF @@ROWCOUNT > 0
	BEGIN
		SELECT  @strIdList = stuff( (SELECT ',' + (convert(varchar(10), a.tblId) )  from
		   @IdTbl  a   for XML PATH('') ),1,1,'')
		insert into @ErrTbl EXEC OracleObjectsUpdate  @i_instance, 1, 0, 1, 2, 0, @strIdList, 0, '';
		select @errCode = isnull(errCode, 0), @errStr = isnull(errStr, '') from @ErrTbl;
		IF @errCode <> 0
		BEGIN
			GOTO EXIT_PROC
		END
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	select @errCode = @@ERROR, @errStr = ERROR_MESSAGE()
END CATCH
IF @errCode = 0
BEGIN
	COMMIT TRAN
END
ELSE
BEGIN
	ROLLBACK TRAN
END
EXIT_PROC:
SELECT  @errCode, @errStr
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'MarkDeletedFlagOnOrphanOraTSAndDF')
	delete from GxQscripts where name = 'MarkDeletedFlagOnOrphanOraTSAndDF'
GO

IF EXISTS (select * from GXDBVersions where aliasname='MarkDeletedFlagOnOrphanOraTSAndDF')
	delete from GXDBVersions where aliasname = 'MarkDeletedFlagOnOrphanOraTSAndDF'
GO

insert into GXDBVersions values(2, 'MarkDeletedFlagOnOrphanOraTSAndDF',  '00010004000200020000', 'MarkDeletedFlagOnOrphanOraTSAndDF', '00010004000200020000')
GO

